[目录](index.md)

* [基本用法](1.usage.md)
* [选项 *](2.options.md)
* [界面操控](3.operation.md)
* [实验性功能](experimental-features.md)
  * [截图 (导出图片)](plugin-screenshot.md)
* [参与贡献](4.contribution.md)
* [贡献代码指南](5.development.md)

2.1. 综述
===

上一章的示例中简单提到了 jsMind 的 options 对象：

```javascript
var options = {
    container:'jsmind_container', // [必选] 容器的ID
    editable:true,                // [可选] 是否启用编辑
    theme:'orange'                // [可选] 主题
};
var jm = new jsMind(options);
```

不过这只是很少的一部分，jsMind 的 options 对象的完整定义如下所示:

```javascript
options = {
   container : '',         // [必选] 容器的ID
   editable : false,       // 是否启用编辑
   theme : null,           // 主题
   mode :'full',           // 布局模式
   support_html : true,    // 是否支持节点里的HTML元素
   log_level: 'info',      // 日志级别
   view:{
       engine: 'canvas',   // 思维导图各节点之间线条的绘制引擎
       hmargin:100,        // 思维导图距容器外框的最小水平距离
       vmargin:50,         // 思维导图距容器外框的最小垂直距离
       line_width:2,       // 思维导图线条的粗细
       line_color:'#555',  // 思维导图线条的颜色
       line_style:'curved',// 思维导图线条的样式，直线(straight)或者曲线(curved)
       custom_line_render: null,  // 自定义的线条渲染方法
       draggable: false,   // 当容器不能完全容纳思维导图时，是否允许拖动画布代替鼠标滚动
       hide_scrollbars_when_draggable: false, // 当设置 draggable = true 时，是否隐藏滚动条
       node_overflow: 'hidden', // 节点文本过长时的样式
       zoom: {             // 配置缩放
           min: 0.5,       // 最小的缩放比例
           max: 2.1,       // 最大的缩放比例
           step: 0.1,      // 缩放比例间隔
       },
       custom_node_render: null, // 自定义的节点渲染方法
   },
   layout:{
       hspace:30,          // 节点之间的水平间距
       vspace:20,          // 节点之间的垂直间距
       pspace:13,          // 节点与连接线之间的水平间距（用于容纳节点收缩/展开控制器）
       cousin_space:0      // 相邻节点的子节点之间的额外的垂直间距
   },
   shortcut:{
       enable:true,        // 是否启用快捷键
       handles:{},         // 命名的快捷键事件处理器
       mapping:{           // 快捷键映射
           addchild   : [45, 4096+13], 	// <Insert>, <Ctrl> + <Enter>
           addbrother : 13,    // <Enter>
           editnode   : 113,   // <F2>
           delnode    : 46,    // <Delete>
           toggle     : 32,    // <Space>
           left       : 37,    // <Left>
           up         : 38,    // <Up>
           right      : 39,    // <Right>
           down       : 40,    // <Down>
       }
   },
};
```

以上选项是 jsMind 的默认选项，除 container 之外，其它选项都是可选的，你可以添加相应的选项以覆盖这些默认选项。

下面将对这些选项进行详细介绍。

2.2. 常规选项
===

**container** : (string) [必选] 容器的ID

> 实例化一个 jsMind 时，此参数不可缺省。jsMind 通过此参数查找页面元素，并将思维导图输出到该元素中。为了便于控制思维导图的大小和位置，请使用[块元素][1]作为思维导图的容器，如`<div>`。

> 你可以给该元素进行修饰，但是一般仅限于设置其大小、位置、边框等；如果想改变思维导图的字体、字号、背景颜色、前景颜色等，建议通过添加自定义主题的方式进行处理。

**editable** : (bool) 是否启用编辑

> 该参数控制是否支持在思维导图上进行编辑，jsMind 目前提供的编辑行为有添加节点、删除节点、修改节点标题、移动节点位置等，如果该参数设置为 true，将可以使用 API 进行以上这些操作，否则这些 API 将不会生效。默认情况下，该参数的值为 false 。

> 需要注意的是，jsMind 仅提供了编辑接口和少量的快捷键支持，并未提供完整的编辑功能，此参数仅用于限制这些 API 的使用。

**theme** : (string) 主题

> 指定 jsMind 的主题名。

**mode** : (string) 布局模式

> 当往脑图里添加一级子节点时，jsMind 将根据此参数决定把节点放置在哪一侧。目前支持两种布局模式:

> * `full` - 子节点动态分布在根节点两侧 [默认值]
> * `side` - 子节点只分布在根节点右侧

> 需要注意的是，此参数只在添加节点时（`jsMind.add_node(...)`）生效。

**support_html** : (bool) 是否支持节点里的HTML元素

> 该参数的默认值为 true ，含义为允许在节点的标题中使用 HTML 代码，如果你愿意，你甚至可以在节点标题里插入一个表格`<table>`。如果你希望标题中只有纯文本，请将该参数设为 false 。

> 需要注意的是，在 freemind 中，节点的样式是使用 html 语言进行控制的，如果你使用 freemind 格式的数据时，建议将此参数设置为 true。

**log_level** : (string) log 级别

> log 级别一共有五种: `debug`/`info`/`warn`/`error`/`disable`，默认设置为 `info`，如果需要关闭所有日志，请设置为 `disable`。

2.3. 排版选项
===

**view.engine** : (string) 思维导图各节点之间线条的绘制引擎

> jsMind 现支持两种线条的绘制引擎：

> * `canvas` - 把线条绘制在 canvas 上 [默认值]
> * `svg` - 使用 svg 绘制线条，当思维导图的节点很多，面积巨大的时候，使用该模式能带来显著的性能提升

**view.enable_device_pixel_ratio** : (bool) 按设备像素比例绘制高清思维导图。 (0.8.5 及以上版本支持)

> 此参数仅用于改善 canvas 的绘制效果，当绘制引擎设置为 svg 时则无须设置。

**view.hmargin** : (number) 思维导图距容器外框的最小水平距离（像素）  
**view.vmargin** : (number) 思维导图距容器外框的最小垂直距离（像素）

> 这两个参数决定了思维导图与容器的边框能距离多近。把思维导图本身作为一个对象的话，这两个参数就类似该对象的 margin(css) 属性。这两个参数的默认值为 container 的宽和高。

**view.line_width** : (number) 思维导图线条的粗细（像素）  
**view.line_color** : (string) 思维导图线条的颜色（html的颜色表示方法）。如果一个 `node` 设置了 `data.leading-line-color`，此选项将会被覆盖

> 默认情况下，线条的粗细是2px，颜色是深灰色（#555）。

**view.line_style** : (string) 思维导图线条的样式。可用的选项有: 

> * `curved` 表示曲线 [默认值]
> * `straight` 表示直线

**view.custom_line_render** : (function) 自定义思维导图线条的渲染方法

> * 方法参数签名: `function custom_line_render({ctx, start_point: {x, y}, end_point: {x, y}}):void` 
> * `this`对应[当前渲染的线条对象](https://github.com/hizzgdev/jsmind/blob/master/src/jsmind.graph.js)，`ctx` 是一个 canvas 上下文对象或一个标签名为`path`的DOM对象，具体取决于`view.engine`的值，`start_point` 和 `end_point` 是起始点的坐标对象，坐标对象包含 `x` 和 `y` 属性。 
> * 注意: 如果你想要使用[`this`](https://github.com/hizzgdev/jsmind/blob/master/src/jsmind.graph.js)对象, 请不要使用箭头函数

**view.draggable** : (bool) 当容器不能完全容纳思维导图时，是否允许拖动画布代替鼠标滚动

> 当思维导图不能在容器中完全显示时，默认情况下容器内会出现滚动条。开启此选项后，将允许通过拖拽画布的方式查看思维导图的不同部分。此参数默认值为 `false` (不开启此功能)

**view.hide_scrollbars_when_draggable** : (bool) 当设置 draggable = true 时，是否隐藏滚动条

> 此参数仅当 `view.draggable` 为 true 时生效，其用于设置是否隐藏水平和垂直容器内的滚动条。
> 此参数的默认值为 `false` (显示滚动条)，当设置为 `true` 时，容器内的滚动条将会被隐藏，用户无法通过滚动鼠标滚轮的方式查看思维导图的不同部分。

**view.node_overflow** : (string) 节点文本过长时的样式 (0.5.3 及以上版本支持)

> 节点文本过长时，jsMind 支持两种样式：

> * `hidden` - 隐藏部分文本以保持脑图的整体易读性 [默认值]
> * `wrap` - 对文本进行换行，以展示全部文本内容

**view.zoom** : (object) 脑图缩放配置 (0.6.3 及以上版本支持)
> * min - 最小的缩放比例，默认 0.5
> * max - 最大的缩放比例，默认 2.1
> * step - 缩放比例间隔，默认 0.1

**view.custom_node_render** : (function) 脑图节点的自定义渲染方法 (0.7.6 及以上版本支持)

> 此选项可用于修改 jsMind 默认的渲染逻辑，此参数为一个 javascript 方法，其方法签名为 `function (jm, element, node): boolean `。其返回值用于表示是否已经对此节点进行了渲染，如果返回 `true`, jsMind 将不会再次渲染此节点；如果返回 false, jsMind 将使用默认渲染逻辑对此节点进行渲染。

**view.expander_style** : (string) 子节点展开控制器的样式 (0.7.8 及以上版本支持)

> * `char` - 在展开控制器上显示 `-`, `+` 用于表示节点的展开状态 [default]
> * `number` - 在展开控制器上显示子节点的数量，多于100个子节点时将显示 `...`

**layout.hspace** : (number) 节点之间的水平间距（像素）  
**layout.vspace** : (number) 节点之间的垂直间距（像素）

> 这两个参数相当于节点对象的 margin(css)属性，水平方向上默认值为 30 像素，垂直方向上默认值为 20 像素。

**layout.pspace** : (number) 节点收缩/展开控制器的尺寸（像素）

> 如果某一节点（根节点除外）存在下级节点，则此节点外侧则会显示出收缩/展开下级节点的控制器，此参数用于设置此控制器的大小（宽和高），默认值为 13 像素。

**layout.cousin_space** : (number) 相邻节点的子节点之间的额外的垂直间距（像素）(0.5.5 及以上版本支持)

> 该参数默认值为零，即不添加额外的间距。

2.4. 快捷键
===

**shortcut.enable** : (bool) 是否启用快捷键

> 该参数用于控制是否可以在jsMind界面上使用键盘快捷键对思维导图进行编辑（或其它操作），默认值为 true，即启用快捷键。

**shortcut.handles** : (object{string : function}) 命名的快捷键事件处理器

> jsMind提供了一些常用的处理器，用于操作思维导图（参见下一节），该参数提供了定义额外处理器的能力。
> 该参数是一个 string->function(jsmind,event) 的集合，string 指名了该处理器的名称，function 则是这个处理器具体要执行的逻辑，在下一节的 shortcut.mapping 的配置中，将把处理器的名称绑定到具体的按键上，实现快捷操作的目的。比如以下代码就定义了一个处理器：

```javascript
handles : {
    'dosomething' : function(jm,e){
        // do something...
    },
    'dosomeotherthing' : function(jm,e){
        // do some other things
    }
    ...
}
```

**shortcut.mapping** : (object{string : number | [number]}) 快捷键映射配置

> 该参数用于配置具体的按键与处理器之间的对应关系，此代码显示了默认情况下的对应关系，如 [Insert] 键的代码是 45 ，可用于添加一个子节点，而 112 代表的是 [F1] 键，用于 dosomething。
> 提示：还可以为一个处理器配置多个快捷键，把键码替换为数组即可。

```javascript
mapping:{                         // handle mapping.
   addchild   : [45, 4096+13],    // <Insert>, <Ctrl> + <Enter>
   addbrother : 13,               // <Enter>
   editnode   : 113,              // <F2>
   delnode    : 46,               // <Delete>
   toggle     : 32,               // <Space>
   left       : 37,               // <Left>
   up         : 38,               // <Up>
   right      : 39,               // <Right>
   down       : 40,               // <Down>

   // 示例
   dosomething: 112,              // <F1>
}
```

> 除了上述这种单一按键的情况，jsMind新增了对组合按键的支持，组合快捷键的代码为常规按键的代码加上功能键的标识代码。
> 目前支持四种功能键，对应的标识代码分别为：

> * Meta  : 8192
> * Ctrl  : 4096
> * ALT   : 2048
> * SHIFT : 1024

> 以下是一些示例：

```javascript
mapping:{
   addchild  : 4096 + 73,          // <Ctrl> + <I>
   delnode   : 4096 + 2048 + 68,   // <Ctrl> + <ALT> + <D>
}
```

版权声明
===

禁止转载、禁止演绎。

jsMind 项目仍在不断升级变化，版本更新时会同时更新对应的文档。为避免给使用者带来困惑，在没有得到书面许可前，禁止转载本文档，同时禁止对本文档进行任何形式的更改。

[1]:http://www.nowamagic.net/librarys/veda/detail/1190 "CSS块级元素、内联元素概念"
