[Table of Contents](index.md)

* [Usage](1.usage.md)
* [Options](2.options.md)
* [Operation](3.operation.md)
* [Experimental Features](experimental-features.md)
  * [Screenshot (Export as Image)](plugin-screenshot.md)
* [Contribution](4.contribution.md)
* [Development Guide *](5.development.md)


> First of all, I would like to express my gratitude to you. The open source community is thriving because of you, and jsMind has gained even greater value because of you.

Contributing process
===

The basic process of contributing code to jsMind is:

1. fork jsmind
2. Develop new features or improve the current version
3. Test your code
4. Submit a pull-request to jsmind
5. Waiting for review, you may be asked to modify your code during the review
6. Merge your pull-request

Preparation
===

**Pull-Request and Fork** : read the github [article of pull-request](https://docs.github.com/cn/pull-requests) to learn how to submit your code using fork and pull-request.

**Node.js** : Node.js is not required to use jsMind in your project, but it is used to perform unit test, code formatting, packaging and compression. Node.js 18.x is used by CI environment of jsMind.

**Visual Studio Code** : If your IDE is VS Code, it's recommended to install the plugin `esbenp.prettier-vscode`. In this way, your code will be formatted according to the configuration of jsMind automatically.

Development
===

jsMind is written in ES6 format, source code is in `/src`. Generally, only the code in it needs to be modified.

Please remember to format the code at any time during the development process. Execute the following code on the command line to format the code:

```
npm run format
```

Unit Test
===

The code of unit test is in `/tests/unit`. Please add unit test for the code changes, and make sure all unit tests pass.

Execute the following command to run the unit tests:

```
npm run test-es6
```

Packaging and compression
===

Execute the following command to package the code into a js file that can work in web browsers:

```
npm run build
```

The js file will be generated into `/es6`

Local running and debugging
===
Execute the following command to start a simple http server

```
npm run server
```

The accessible url will be printed in the command line window, which probably be `http://localhost:8080`. Now visit http://localhost:8080/example/2_features_es6.html and test or debug.

it is strongly recommended to test all the use cases on the page, no matter you are developing a new feature or fixing a bug.

It should be noted: If the ES6 files is changed, you may have to run `npm run build` and refresh the page to preview the changes.


copyright
===

Reproduction and deduction are prohibited.

The jsMind project is still being updated and the corresponding documentation is updated at the same time as the version is updated. In order to avoid confusion to the user, it is forbidden to reprint this document without written permission and to make changes of any kind to this document.