[Table of Contents](index.md)

* [Usage *](1.usage.md)
* [Options](2.options.md)
* [Operation](3.operation.md)
* [Experimental Features](experimental-features.md)
  * [Screenshot (Export as Image)](plugin-screenshot.md)
* [Contribution](4.contribution.md)
* [Development Guide](5.development.md)

1.1. Basic Framework
===

At first, 2 files (jsmind.css and jsmind.js) are required. Here we link to the resources on the CDN. It is recommended to use the latest version.

```html
<link type="text/css" rel="stylesheet" href="https://unpkg.com/jsmind@0.8.6/style/jsmind.css" />

<script type="text/javascript" src="https://unpkg.com/jsmind@0.8.6/es6/jsmind.js"></script>

```
> CDNs in common use: [UNPKG](https://unpkg.com/jsmind/), [jsDelivr](https://www.jsdelivr.com/package/npm/jsmind/), and [the mirror of jsDelivr in China](https://jsd.onmicrosoft.cn/npm/jsmind/). the resource urls would look like:
> - https://unpkg.com/jsmind@0.8.6/es6/jsmind.js
> - https://cdn.jsdelivr.net/npm/jsmind@0.8.6/es6/jsmind.js
> - https://jsd.onmicrosoft.cn/npm/jsmind@0.8.6/es6/jsmind.js
>
> The version number appear in the url of CDN. It's strongly recommended that you also specify the version number in your project to avoid the risks that caused by version upgrades. Access the [jsMind on NPM](https://www.npmjs.com/package/jsmind) to get the latest version number of jsMind.

Add script jsmind.draggable-node.js for enabling draggable node feature.

```html
<script type="text/javascript" src="https://unpkg.com/jsmind@0.8.6/es6/jsmind.draggable-node.js"></script>
```

The second, a div element should be in your HTML as container

```html
<div id="jsmind_container"></div>
```

The last, show an empty mindmap:

```html
<script type="text/javascript">
    var options = {                     // for more detail at next chapter
        container:'jsmind_container',   // [required] id of container
        editable:true,                  // [required] whether allow edit or not
        theme:'orange'                  // [required] theme
    };
    var jm = new jsMind(options);
    jm.show();
</script>
```

Or, show a mindmap with some topics:

```html
<script type="text/javascript">
    var mind = { /* jsMind data, for more detail at next section */ };
    var options = {
        container:'jsmind_container',
        editable:true,
        theme:'orange'
    };
    var jm = new jsMind(options);
    // show it
    jm.show(mind);
</script>
```

1.2. Data Format
===

3 formats are supported by jsMind: `node_tree`,`node_array` and `freemind`. jsMind can load mind maps in these formats, and can also export data to any of these formats.

These are simple demo for the data format:

A. `node_tree` format, default format in jsMind

```javascript
var mind = {
    "meta":{
        "name":"jsMind remote",
        "author":"hizzgdev@163.com",
        "version":"0.2"
    },
    "format":"node_tree",
    "data":{"id":"root","topic":"jsMind","children":[
        {"id":"easy","topic":"Easy","direction":"left","children":[
            {"id":"easy1","topic":"Easy to show"},
            {"id":"easy2","topic":"Easy to edit"},
            {"id":"easy3","topic":"Easy to store"},
            {"id":"easy4","topic":"Easy to embed"}
        ]},
        {"id":"open","topic":"Open Source","direction":"right","children":[
            {"id":"open1","topic":"on GitHub"},
            {"id":"open2","topic":"BSD License"}
        ]},
        {"id":"powerful","topic":"Powerful","direction":"right","children":[
            {"id":"powerful1","topic":"Base on Javascript"},
            {"id":"powerful2","topic":"Base on HTML5"},
            {"id":"powerful3","topic":"Depends on you"}
        ]},
        {"id":"other","topic":"test node","direction":"left","children":[
            {"id":"other1","topic":"I'm from local variable"},
            {"id":"other2","topic":"I can do everything"}
        ]}
    ]}
};
```

B. `node_array` format

```javascript
var mind = {
    "meta":{
        "name":"example",
        "author":"hizzgdev@163.com",
        "version":"0.2"
    },
    "format":"node_array",
    "data":[
        {"id":"root", "isroot":true, "topic":"jsMind"},

        {"id":"easy", "parentid":"root", "topic":"Easy", "direction":"left"},
        {"id":"easy1", "parentid":"easy", "topic":"Easy to show"},
        {"id":"easy2", "parentid":"easy", "topic":"Easy to edit"},
        {"id":"easy3", "parentid":"easy", "topic":"Easy to store"},
        {"id":"easy4", "parentid":"easy", "topic":"Easy to embed"},

        {"id":"open", "parentid":"root", "topic":"Open Source", "direction":"right"},
        {"id":"open1", "parentid":"open", "topic":"on GitHub"},
        {"id":"open2", "parentid":"open", "topic":"BSD License"},

        {"id":"powerful", "parentid":"root", "topic":"Powerful", "direction":"right"},
        {"id":"powerful1", "parentid":"powerful", "topic":"Base on Javascript"},
        {"id":"powerful2", "parentid":"powerful", "topic":"Base on HTML5"},
        {"id":"powerful3", "parentid":"powerful", "topic":"Depends on you"},
    ]
};
```

C. `freemind` format

```javascript
var mind = {
    "meta":{
        "name":"example",
        "author":"hizzgdev@163.com",
        "version":"0.2"
    },
    "format":"freemind",
    "data":"<map version=\"1.0.1\"> <node ID=\"root\" TEXT=\"jsMind\" > <node ID=\"easy\" POSITION=\"left\" TEXT=\"Easy\" > <node ID=\"easy1\" TEXT=\"Easy to show\" /> <node ID=\"easy2\" TEXT=\"Easy to edit\" /> <node ID=\"easy3\" TEXT=\"Easy to store\" /> <node ID=\"easy4\" TEXT=\"Easy to embed\" /> </node> <node ID=\"open\" POSITION=\"right\" TEXT=\"Open Source\" > <node ID=\"open1\" TEXT=\"on GitHub\" /> <node ID=\"open2\" TEXT=\"BSD License\" /> </node> <node ID=\"powerful\" POSITION=\"right\" TEXT=\"Powerful\" > <node ID=\"powerful1\" TEXT=\"Base on Javascript\" /> <node ID=\"powerful2\" TEXT=\"Base on HTML5\" /> <node ID=\"powerful3\" TEXT=\"Depends on you\" /> </node> <node ID=\"other\" POSITION=\"left\" TEXT=\"test node\" > <node ID=\"other1\" TEXT=\"I'm from local variable\" /> <node ID=\"other2\" TEXT=\"I can do everything\" /> </node> </node> </map>"
};
```

1.3. Themes
===

15 themes were supported in jsmind, you can preview those themes by visiting [feature-demo](http://hizzgdev.github.io/jsmind/example/2_features.html).

+ primary
+ warning
+ danger
+ success
+ info
+ greensea
+ nephrite
+ belizehole
+ wisteria
+ asphalt
+ orange
+ pumpkin
+ pomegranate
+ clouds
+ asbestos

or, you can add your custom theme in jsmind.css.

```css
/* greensea theme */
jmnodes.theme-greensea jmnode{background-color:#1abc9c;color:#fff;}
jmnodes.theme-greensea jmnode:hover{background-color:#16a085;}
jmnodes.theme-greensea jmnode.selected{background-color:#11f;color:#fff;}
jmnodes.theme-greensea jmnode.root{}
jmnodes.theme-greensea jmexpander{}
jmnodes.theme-greensea jmexpander:hover{}
```

1.4. Styles
===

In addition to the Themes, there are some styles can be set at node level:

* background-color: the background color of a node, e.g. `#1abc9c`, `blue`
* foreground-color: the foreground color of a node, e.g. `#1abc9c`, `blue`
* width: node width (px), e.g. `400`
* height: node height (px), e.g. `400`
* font-size: font size of the topic of a node (px), e.g. `32`
* font-weight: font weight of the topic of a node, e.g. `bold`
* font-style: font style of the topic of a node, e.g.`italic`
* background-image: background image url e.g. `http://fakeurl.com/fake-picture.png`, or a data url, e.g. `data:image/png;base64,...`
* background-rotation: the rotation of the background image, e.g. `30`
* leading-line-color: the color of the leading line of a node, e.g. `#1abc9c`, `blue`

How to set:

* set by api: add the settings to the `data` parameter of `add_node` [[3.4. Operation - Add Node](3.operation.md)]
 

```javascript
let data = {'width': 400, 'leading-line-color': '#33ff33'}
jm.add_node(....., data)
```

* set on data define (data file): add the settings to `node`, e.g.

```javascript

var mind = {
    ...
    format: 'node_tree',
    data: {
        id: 'root',
        topic: 'jsMind',
        children: [
        {
            'id': 'image-node',
            'background-image': 'ant.png',
            'width': '100',
            'height': '100',
        }
    ],
    ...
}
```
copyright notice
===

Reproduction and deduction are prohibited.

The jsMind project is still being updated and the corresponding documentation is updated at the same time as the version is updated. In order to avoid confusion to the user, it is forbidden to reprint this document without written permission and to make changes of any kind to this document.

