import req from "@/request.js";
const portal = window.context.portal;
export default {
    // 地图设备信息
    queryDeviceList(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/deviceList`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 事件统计
    queryEventCount(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/eventStatistics`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 事件来源
    queryEventSource(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/eventSourceStatistics`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 事件分类
    queryEventType(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/eventTypeStatistics`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 高频地点
    queryEventPlace(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/highAddressAnalyse`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 存续事件更新统计
    queryEventUpdate(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/updateStatusStatistics`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 重点关注对象统计
    queryEventObject(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/orgTypeStatistics`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 查询智能监测设备数据
    queryEquipmentVolumn(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/base/device/data/query`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 获取监控视频流
    queryVideoByCode(apeid,type) {
        return new Promise((resolve, reject) => {
            req.get(portal + `/biz/device/getStreamUrl?apeId=${apeid}&type=${type}`).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 获取预警信息列表
    queryWarningListByCode(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/base/event/center/eventManagerQuery`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 根据图片相对路径获取图片地址
    getImgByUrl(url) {
        return new Promise((resolve, reject) => {
            req.get(portal + `/biz/device/getImgUrls?imgUrl=${url}`).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 根据事件状态
    getListByEventStatus(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/base/event/center/findByPage`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 今日事件
    getEventAllView(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/eventAllView`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 重点关注位置
    getFollowLocation(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/eventAddressAnalysis`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 重点关注团体
    getConcernGroup(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/eventMainAnalysis`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 事件处置效率分析
    getDurationAnalysis(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/biz/big/Screen/eventDurationAnalysis`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
}
