import req from "@/request.js";

const portal = window.context.portal;
export default {
	//分页
	dataQuery(data, cb) {
		req.post(portal + `/base/team/filling/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 新增
	addSave(data, cb) {
		req.post(portal + `/base/team/filling/`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailId(id, cb) {
		req.get(portal + `/base/team/filling/${id}`).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upData(data, cb) {
		req.put(portal + `/base/team/filling/`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	remove(id, cb) {
		req.remove(portal + `/base/team/filling/${id}`).then(rep => {
			cb(rep.data);
		});
	},
	//批量删除
	batchRemove(ids, cb) {
		req.remove(portal + `/base/team/filling/?ids=` + ids).then(rep => {
			cb(rep.data);
		});
	},
	//获取行政区域
	townTree(data, cb) {
		req.post(portal + `/sys/sysAreas/v1/tree`, data).then(rep => {
			cb(rep.data);
		});
	},
	//拼音
	getPinyin(data, cb) {
		req.get(portal + `/base/tools/v1/getPinyin?chinese=${data}&type=0`).then(rep => {
			cb(rep.data);
		});
	},
	// 导出
	exportFile(data, cb) {
		req.post(portal + `/base/team/filling/export`, data, 'blob').then(res => {
			cb(res.data)
		})
	},
}