import 'babel-polyfill'
import Vue from 'vue'
import App from './App.vue'
import store from './store'
import router from './router'
import '@/assets/css/element-custom.scss'
import ElementUI from 'element-ui'
import i18n from '@/lang/index.js'
import moment from 'moment' //日期格式化插件

import '@/directive.js'
import req from '@/request.js'
import deepmerge from 'deepmerge'
import validate from '@/validate.js'
import dict from '@/lang/dict.js'

import utils from '@/utils.js'

//引入字典
import DictSelect from '@/components/dict/DictSelect.vue'
import dictUtils from '@/components/dict/DictSelectUtils'

// 引入状态颜色组件
import StatusByColor from '@/components/common/StatusByColor.vue'
//侧边导航事件
import eventBus from './api/bus.js'
Vue.use(eventBus)
//菜单图标
import svgIcon from '@/components/global/svgIcon.vue'

Vue.config.debug = true

Vue.prototype.$http = req

// 字符串解析和序列化字符串
import qs from 'qs'
Vue.prototype.qs = qs

Vue.use(ElementUI, {
  i18n: (key, value) => i18n.t(key, value)
  // size: 'small'
})

// 列头自适应
ElementUI.TableColumn.props.minWidth = {
  default: function() {
    if (this.label) {
      //将双字节字符替换为两个a，14为当前font-size 一个a为7.8px 一个汉字为14px 单元格左右padding为20px
      return this.label.replace(/[^\x00-\xff]/g, 'aa').length * 7.8 + 20 + 'px'
    }
  }
}

// 拖拽指令
import '@/dialog'

// 注册全局组件
Vue.component('svgIcon', svgIcon)
Vue.component('DictSelect', DictSelect)
Vue.component('StatusByColor', StatusByColor)

window.app = new Vue({
  store,
  router,
  i18n,
  render: function(createElement) {
    if (
      '-ms-scroll-limit' in document.documentElement.style &&
      '-ms-ime-align' in document.documentElement.style
    ) {
      window.addEventListener(
        'hashchange',
        () => {
          var currentPath = window.location.hash.slice(1)
          if (this.$route.path !== currentPath) {
            this.$router.push(currentPath)
          }
        },
        false
      )
    }
    return createElement(App)
  }
}).$mount('#root')

let validateLocal = localStorage.getItem('lang')
let currentLocal = validateLocal || 'zh-CN'
// app.$validator.locale = currentLocal

if (app.$validator) {
  for (let rule in validate) {
    app.$validator.rules[rule] = validate[rule]
  }
  app.$validator.dictionary.container = deepmerge(
    dict,
    app.$validator.dictionary.container,
    {clone: true}
  )
}

// 日期控件格式化
if ('zh-CN' == currentLocal) {
  moment.locale('zh-cn')
} else {
  moment.locale('en')
}
moment.locale('zh-cn')

// el-tooltip 默认显示
Vue.prototype.$tooltipplacement = 'bottom'

// 默认获取当前时间并格式化为yyyy-MM-dd
Vue.prototype.getDate = () => {
  const nowDate = new Date()
  let date = {
    year: nowDate.getFullYear(),
    month: nowDate.getMonth() + 1,
    date: nowDate.getDate()
  }
  const newmonth = date.month >= 10 ? date.month : '0' + date.month
  const day = date.date >= 10 ? date.date : '0' + date.date
  date = date.year + '-' + newmonth + '-' + day
  return date
}
