import req from "@/request.js";
const portal = window.context.portal;
export default {
    //分页
    queryEventsList(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/base/event/center/query`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    //新增
    add(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/base/event/center/`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 编辑
    update(data, cb) {
        return new Promise((resolve, reject) => {
            req.put(portal + `/base/event/center/`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    },
    //批量删除
    batchDelete(ids, cb) {
        return new Promise((resolve, reject) => {
            req.remove(portal + `/base/event/center/?ids=` + ids).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    },
    //批量提交
    batchSubmit(ids, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/base/event/center/submitEvent?ids=` + ids).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 行政区划树
    getbaseAreaTree(data, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal + '/sys/sysAreas/v1/tree').then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    },

}