/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.scada.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.cssc.scada.dao.PlanElectricDao;
import com.artfess.cssc.scada.manager.PlanElectricManager;
import com.artfess.cssc.scada.model.PlanElectric;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlanElectricManagerImpl
extends BaseManagerImpl<PlanElectricDao, PlanElectric>
implements PlanElectricManager {
    @Override
    @Transactional
    public boolean insertPlanElectric(PlanElectric planElectric) {
        if (BeanUtils.isNotEmpty((Object)((Object)planElectric))) {
            if (planElectric.getPlanYear() == null) {
                throw new RequiredException("\u6dfb\u52a0\u8ba1\u5212\u7535\u91cf\u5931\u8d25\uff0c\u8ba1\u5212\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (planElectric.getPlanElectric() == null) {
                throw new RequiredException("\u6dfb\u52a0\u8ba1\u5212\u7535\u91cf\u5931\u8d25\uff0c\u8ba1\u5212\u7535\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSamePlan(planElectric)) {
                throw new RequiredException("\u6dfb\u52a0\u8ba1\u5212\u7535\u91cf\u5931\u8d25\uff0c\u3010" + planElectric.getPlanYear() + "\u5e74" + planElectric.getPlanMonth() + "\u6708\u3011\u7684\u8ba1\u5212\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((PlanElectricDao)this.baseMapper).insert((Object)planElectric);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updatePlanElectric(PlanElectric planElectric) {
        if (BeanUtils.isNotEmpty((Object)((Object)planElectric))) {
            if (planElectric.getPlanYear() == null) {
                throw new RequiredException("\u4fee\u6539\u8ba1\u5212\u7535\u91cf\u5931\u8d25\uff0c\u8ba1\u5212\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (planElectric.getPlanElectric() == null) {
                throw new RequiredException("\u4fee\u6539\u8ba1\u5212\u7535\u91cf\u5931\u8d25\uff0c\u8ba1\u5212\u7535\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSamePlan(planElectric)) {
                throw new RequiredException("\u4fee\u6539\u8ba1\u5212\u7535\u91cf\u5931\u8d25\uff0c\u3010" + planElectric.getPlanYear() + "\u5e74" + planElectric.getPlanMonth() + "\u6708\u3011\u7684\u8ba1\u5212\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((PlanElectricDao)this.baseMapper).updateById((Object)planElectric);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    public Map<Object, Object> queryByYear(Integer year) {
        if (year == null || year == 0) {
            year = DateUtils.getYear();
        }
        PlanElectric planElectric = ((PlanElectricDao)this.baseMapper).queryByYear(year);
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (BeanUtils.isNotEmpty((Object)((Object)planElectric))) {
            result.put(year, planElectric.getPlanElectric());
        } else {
            result.put(year, 0);
        }
        return result;
    }

    private boolean checkSamePlan(PlanElectric planElectric) {
        if (BeanUtils.isNotEmpty((Object)((Object)planElectric))) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"plan_year_", (Object)planElectric.getPlanYear());
            queryWrapper.ne(StringUtils.isNotBlank((CharSequence)planElectric.getId()), (Object)"ID_", (Object)planElectric.getId());
            int num = ((PlanElectricDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
            return num != 0;
        }
        throw new RequiredException("\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }
}

