/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.model.dao.ModelFanDao;
import com.artfess.cssc.model.manager.ModelFanManager;
import com.artfess.cssc.model.model.ModelFan;
import com.artfess.cssc.model.params.ModelFanVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModelFanManagerImpl
extends BaseManagerImpl<ModelFanDao, ModelFan>
implements ModelFanManager {
    @Override
    public List<ModelFanVo> queryModelByFan(String fanCode, String fanId, Integer modelCategory) {
        if (StringUtil.isEmpty((String)fanCode) && StringUtil.isEmpty((String)fanId)) {
            throw new RequiredException("\u8bf7\u9009\u62e9\u673a\u7ec4\uff01");
        }
        List<ModelFanVo> list = ((ModelFanDao)this.baseMapper).queryModelByFan(fanCode, fanId, modelCategory);
        return list;
    }

    @Override
    public List<ModelFanVo> queryFanByModel(String modelId) {
        if (StringUtil.isEmpty((String)modelId)) {
            throw new RequiredException("\u8bf7\u9009\u62e9\u6a21\u578b\uff01");
        }
        List<ModelFanVo> list = ((ModelFanDao)this.baseMapper).queryFanByModel(modelId);
        return list;
    }

    @Override
    public PageList<ModelFanVo> sliceQueryFanByModel(QueryFilter<ModelFan> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ModelFanVo> result = ((ModelFanDao)this.baseMapper).sliceQueryFanByModel((IPage<ModelFan>)this.convert2IPage(pageBean), (Wrapper<ModelFan>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public CommonResult<String> saveModelFans(List<ModelFan> list) throws Exception {
        if (BeanUtils.isNotEmpty(list)) {
            for (ModelFan modelFan : list) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"model_id_", (Object)modelFan.getModelId());
                queryWrapper.eq((Object)"fan_id_", (Object)modelFan.getFanId());
                ((ModelFanDao)this.baseMapper).delete((Wrapper)queryWrapper);
                modelFan.setModelStatus(1);
            }
            this.saveBatch(list);
            return new CommonResult(true, "\u6a21\u578b\u5173\u8054\u673a\u7ec4\u6210\u529f\uff01", (Object)"");
        }
        return new CommonResult(false, "\u6a21\u578b\u5173\u8054\u673a\u7ec4\u5931\u8d25\uff01", (Object)"");
    }

    @Override
    @Transactional
    public void deleteByModel(String modelId) {
        if (StringUtil.isEmpty((String)modelId)) {
            throw new RequiredException("\u5220\u9664\u5173\u8054\u4e2d\u7684\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"model_id_", (Object)modelId);
        ((ModelFanDao)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public void deleteByFan(String fanId) {
        if (StringUtil.isEmpty((String)fanId)) {
            throw new RequiredException("\u5220\u9664\u5173\u8054\u4e2d\u7684\u7684\u673a\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fan_id_", (Object)fanId);
        ((ModelFanDao)this.baseMapper).delete((Wrapper)queryWrapper);
    }
}

