/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.cssc.base.dao.WfParamsDao;
import com.artfess.cssc.base.dao.WindFactoryDao;
import com.artfess.cssc.base.manager.ParamsConfManager;
import com.artfess.cssc.base.manager.WfParamsManager;
import com.artfess.cssc.base.model.ParamsConf;
import com.artfess.cssc.base.model.WfParams;
import com.artfess.cssc.base.model.WindFactory;
import com.artfess.cssc.base.params.ParamsConfObject;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WfParamsManagerImpl
extends BaseManagerImpl<WfParamsDao, WfParams>
implements WfParamsManager {
    @Resource
    WindFactoryDao windFactoryDao;
    @Resource
    ParamsConfManager paramsConfManager;

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((WfParamsDao)this.baseMapper).removePhysical();
    }

    @Override
    public List<WfParams> getByWfId(String wfId) {
        if (StringUtil.isEmpty((String)wfId)) {
            throw new ApplicationException("\u98ce\u573aid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return ((WfParamsDao)this.baseMapper).getByWfId(wfId);
    }

    @Override
    @Transactional
    public CommonResult<String> saveWfParams(String wfId, List<ParamsConfObject> paramsList) throws Exception {
        if (StringUtil.isEmpty((String)wfId)) {
            return new CommonResult(false, "\u98ce\u573aid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder pcodes = new StringBuilder();
        WindFactory windFactory = (WindFactory)((Object)this.windFactoryDao.selectById((Serializable)((Object)wfId)));
        boolean isTrue = false;
        if (BeanUtils.isEmpty((Object)((Object)windFactory))) {
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u98ce\u573aid\u4e3a\u3010" + wfId + "\u3011\u7684\u98ce\u573a\uff01");
        }
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        if (BeanUtils.isNotEmpty(paramsList)) {
            for (ParamsConfObject paramObject : paramsList) {
                ParamsConf param = null;
                try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                    param = this.paramsConfManager.getByCode(paramObject.getAlias());
                }
                if (BeanUtils.isNotEmpty((Object)((Object)param)) && "1".equals(param.getType())) {
                    list.add((ObjectNode)JsonUtil.toJsonNode((String)paramObject.toString()));
                    isTrue = true;
                    continue;
                }
                pcodes.append(paramObject.getAlias() + "\uff0c");
            }
        }
        if (BeanUtils.isNotEmpty(list)) {
            for (ObjectNode ObjectNode2 : list) {
                WfParams params = this.getByWfIdAndCode(wfId, ObjectNode2.get("alias").asText());
                if (BeanUtils.isNotEmpty((Object)((Object)params))) {
                    if (ObjectNode2.hasNonNull("value") && !"null".equals(ObjectNode2.get("value").asText())) {
                        params.setValue(ObjectNode2.get("value").asText());
                    } else {
                        params.setValue("");
                    }
                    this.update((Model)params);
                    continue;
                }
                WfParams wfParams = new WfParams();
                wfParams.setCode(ObjectNode2.get("alias").asText());
                if (!"null".equals(ObjectNode2.get("value"))) {
                    wfParams.setValue(ObjectNode2.get("value").asText());
                }
                wfParams.setWfId(wfId);
                wfParams.setId(UniqueIdUtil.getSuid());
                this.create((Model)wfParams);
            }
            return new CommonResult(true, isTrue && StringUtil.isEmpty((String)pcodes.toString()) ? "\u4fdd\u5b58\u6210\u529f" : "\u90e8\u5206\u4fdd\u5b58\u6210\u529f\uff0c\u98ce\u573a\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01", (Object)"");
        }
        return new CommonResult(false, "\u672a\u4fdd\u5b58\u4efb\u4f55\u53c2\u6570\uff0c\u98ce\u573a\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01");
    }

    @Override
    public WfParams getByWfIdAndCode(String wfId, String code) {
        return ((WfParamsDao)this.baseMapper).getByWfIdAndCode(wfId, code);
    }
}

