/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.base.dao.FanInfoDao;
import com.artfess.cssc.base.manager.FanInfoManager;
import com.artfess.cssc.base.model.FanInfo;
import com.artfess.cssc.base.params.FanInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class FanInfoManagerImpl
extends BaseManagerImpl<FanInfoDao, FanInfo>
implements FanInfoManager {
    @Override
    public PageList<FanInfoVo> queryFanInfo(QueryFilter<FanInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<FanInfoVo> result = ((FanInfoDao)this.baseMapper).queryPage((IPage<FanInfo>)this.convert2IPage(pageBean), (Wrapper<FanInfo>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public boolean insertFanInfo(FanInfo fanInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)fanInfo))) {
            if (StringUtil.isEmpty((String)fanInfo.getFanCode())) {
                throw new RequiredException("\u6dfb\u52a0\u673a\u7ec4\u4fe1\u606f\u5931\u8d25\uff0c\u673a\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)fanInfo.getLineCode())) {
                throw new RequiredException("\u6dfb\u52a0\u673a\u7ec4\u4fe1\u606f\u5931\u8d25\uff0c\u673a\u7ec4\u6240\u5728\u73af\u7ebf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameCode(fanInfo.getFanCode(), fanInfo.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u673a\u7ec4\u4fe1\u606f\u5931\u8d25\uff0c\u673a\u7ec4\u7f16\u7801\u3010" + fanInfo.getFanCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            fanInfo.setSn(this.getNextSequence(null));
            fanInfo.setSnLine(this.getNextLineSequence(fanInfo.getLineCode()));
            Integer result = ((FanInfoDao)this.baseMapper).insert((Object)fanInfo);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateFanInfo(FanInfo fanInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)fanInfo))) {
            if (this.checkSameCode(fanInfo.getFanCode(), fanInfo.getId())) {
                throw new RequiredException("\u4fee\u6539\u673a\u7ec4\u4fe1\u606f\u5931\u8d25\uff0c\u673a\u7ec4\u7f16\u7801\u3010" + fanInfo.getFanCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((FanInfoDao)this.baseMapper).updateById((Object)fanInfo);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public void updateFanLineSequence(Map<String, Integer> params) {
        Assert.notEmpty(params, (String)"\u53c2\u6570params\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        for (String key : params.keySet()) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.set((Object)"SN_LINE_", (Object)params.get(key))).eq((Object)"ID_", (Object)key);
            ((FanInfoDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
        }
    }

    @Override
    public List<FanInfo> queryFanByLine(String lineCode, String LineId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq(StringUtil.isNotEmpty((String)lineCode), (Object)"line_code_", (Object)lineCode)).or()).eq(StringUtil.isNotEmpty((String)lineCode), (Object)"line_code_", (Object)LineId);
        List list = ((FanInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public FanInfo getByFanCode(String code) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fan_code_", (Object)code);
        return (FanInfo)((Object)((FanInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    private boolean checkSameCode(String code, String id) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fan_code_", (Object)code);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"ID_", (Object)id);
        int num = ((FanInfoDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }

    public Integer getNextLineSequence(String lineCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"COALESCE(max(sn_line_),0) snLine"});
        queryWrapper.eq((Object)"line_code_", (Object)lineCode);
        List resultList = ((FanInfoDao)this.baseMapper).selectMaps((Wrapper)queryWrapper);
        if (resultList != null && resultList.size() > 0) {
            int n;
            Map resultMap = (Map)resultList.get(0);
            Integer result = Integer.valueOf(resultMap.get("snline").toString());
            if (result == null) {
                n = 1;
            } else {
                result = result + 1;
                n = result;
            }
            return n;
        }
        return 1;
    }
}

