/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.UpdateMethod;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cssc.base.manager.FanParamsManager;
import com.artfess.cssc.base.manager.ParamsConfManager;
import com.artfess.cssc.base.manager.WfParamsManager;
import com.artfess.cssc.base.model.FanParams;
import com.artfess.cssc.base.model.ParamsConf;
import com.artfess.cssc.base.model.WfParams;
import com.artfess.cssc.base.params.ParamsConfVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/base/params/v1/"})
@Api(tags={"\u4e1a\u52a1\u53c2\u6570\u914d\u7f6e"})
@ApiGroup(group={"group_biz"})
public class ParamsConfController
extends BaseController<ParamsConfManager, ParamsConf> {
    @Resource
    ParamsConfManager paramsConfService;
    @Resource
    WfParamsManager wfParamsService;
    @Resource
    FanParamsManager fanParamsService;

    @RequestMapping(value={"paramsConf/getParamsConfPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u53c2\u6570\u914d\u7f6e\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u53c2\u6570\u914d\u7f6e\u5217\u8868")
    public PageList<ParamsConf> getParamsConfPage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        filter.addFilter("is_dele_", (Object)"1", QueryOP.NOT_EQUAL);
        PageList query = this.paramsConfService.query(filter);
        return query;
    }

    @RequestMapping(value={"wfParamsConf/getWfParamsConf"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u98ce\u573a\u7684\u53c2\u6570\u914d\u7f6e\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u98ce\u573a\u7684\u53c2\u6570\u914d\u7f6e\u5217\u8868")
    public List<ParamsConf> getWfParamsConf() throws Exception {
        return this.paramsConfService.getByType("1");
    }

    @RequestMapping(value={"fanParamsConf/getFanParamsConf"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u673a\u7ec4\u53c2\u6570\u914d\u7f6e\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u673a\u7ec4\u53c2\u6570\u914d\u7f6e\u5217\u8868")
    public List<ParamsConf> getFanParamsConf() throws Exception {
        return this.paramsConfService.getByType("2");
    }

    @RequestMapping(value={"paramsConf/addParamsConf"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e", httpMethod="POST", notes="\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e")
    public CommonResult<String> addParamsConf(@ApiParam(name="param", value="\u53c2\u6570\u914d\u7f6e\u5bf9\u8c61", required=true) @RequestBody ParamsConfVo param) throws Exception {
        CommonResult rtn = null;
        try {
            rtn = this.paramsConfService.addParamsConf(param);
        }
        catch (Exception e) {
            rtn = new CommonResult(false, e.getMessage(), (Object)"");
        }
        return rtn;
    }

    @RequestMapping(value={"paramsConf/deleteParamsConfByCodes"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u5220\u9664\u53c2\u6570\u914d\u7f6e", httpMethod="POST", notes="\u6839\u636e\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u5220\u9664\u53c2\u6570\u914d\u7f6e")
    public CommonResult<String> deleteParamsConfByCodes(@ApiParam(name="codes", value="\u53c2\u6570\u914d\u7f6e\u7f16\u7801\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestBody String codes) throws Exception {
        return this.paramsConfService.deleteParamsConfByCodes(codes);
    }

    @RequestMapping(value={"paramsConf/deleteParamsConfByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u914d\u7f6eid\u5220\u9664\u53c2\u6570\u914d\u7f6e", httpMethod="DELETE", notes="\u6839\u636eid\u5220\u9664\u53c2\u6570\u914d\u7f6e")
    public CommonResult<String> deleteParamsConfByIds(@ApiParam(name="ids", value="\u53c2\u6570\u914d\u7f6eid\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestParam String ids) throws Exception {
        return this.paramsConfService.deleteParamsConfByIds(ids);
    }

    @RequestMapping(value={"paramsConf/updateParamsConf"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u53c2\u6570\u914d\u7f6e\uff0c\u53c2\u6570\u914d\u7f6e\u7c7b\u578b\u4e0d\u4e88\u66f4\u65b0", httpMethod="PUT", notes="\u66f4\u65b0\u53c2\u6570\u914d\u7f6e\uff0c\u53c2\u6570\u914d\u7f6e\u7c7b\u578b\u4e0d\u4e88\u66f4\u65b0")
    @UpdateMethod(type=ParamsConfVo.class)
    public CommonResult<String> updateParamsConf(@ApiParam(name="param", value="\u53c2\u6570\u914d\u7f6e\u5bf9\u8c61", required=true) @RequestBody ParamsConfVo param) throws Exception {
        return this.paramsConfService.updateParamsConf(param);
    }

    @RequestMapping(value={"paramsConf/getByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u83b7\u53d6\u53c2\u6570\u914d\u7f6e\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u83b7\u53d6\u53c2\u6570\u914d\u7f6e\u4fe1\u606f")
    public ParamsConf getByCode(@ApiParam(name="code", value="\u53c2\u6570\u914d\u7f6e\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.paramsConfService.getByCode(code);
    }

    @RequestMapping(value={"paramsConf/deleteParamPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u53c2\u6570\u914d\u7f6e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u53c2\u6570\u914d\u7f6e")
    public CommonResult<Integer> deleteParamPhysical() throws Exception {
        Integer num = this.paramsConfService.removePhysical();
        return new CommonResult(true, String.format("\u6210\u529f\u5220\u9664%s\u6761\u8bb0\u5f55", (int)num), (Object)num);
    }

    @RequestMapping(value={"paramsConf/updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u53c2\u6570\u914d\u7f6e\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u4fee\u6539\u53c2\u6570\u914d\u7f6e\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="map", value="key:\u70b9\u4f4did,value:\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> map) throws Exception {
        ((ParamsConfManager)this.baseService).updateSequence(map);
        return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"paramsConf/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u53c2\u6570\u914d\u7f6e\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.paramsConfService.isCodeExist(code);
    }

    @RequestMapping(value={"wfParam/getWfParamsById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u98ce\u573a\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u98ce\u573a\u6307\u5b9a\u53c2\u6570")
    public WfParams getWfParamsById(@ApiParam(name="wfId", value="\u98ce\u573aID", required=true) @RequestParam String wfId, @ApiParam(name="code", value="\u53c2\u6570\u914d\u7f6e\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.paramsConfService.getWfParamsById(wfId, code);
    }

    @RequestMapping(value={"wfParam/deleteWfParamPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u98ce\u573a\u53c2\u6570\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u98ce\u573a\u53c2\u6570\u6570\u636e")
    public CommonResult<Integer> deleteWfParamPhysical() throws Exception {
        Integer num = this.wfParamsService.removePhysical();
        return new CommonResult(true, String.format("\u6210\u529f\u5220\u9664%s\u6761\u8bb0\u5f55", (int)num), (Object)num);
    }

    @RequestMapping(value={"fanParam/getFanParamsById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u673a\u7ec4\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u673a\u7ec4\u6307\u5b9a\u53c2\u6570")
    public FanParams getFanParamsById(@ApiParam(name="fanId", value="\u673a\u7ec4ID", required=true) @RequestParam String fanId, @ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.paramsConfService.getFanParamsById(fanId, code);
    }

    @RequestMapping(value={"fanParam/deleteFanParamPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u673a\u7ec4\u53c2\u6570\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u673a\u7ec4\u53c2\u6570\u6570\u636e")
    public CommonResult<Integer> deleteFanParamPhysical() throws Exception {
        Integer num = this.fanParamsService.removePhysical();
        return new CommonResult(true, String.format("\u6210\u529f\u5220\u9664%s\u6761\u8bb0\u5f55", (int)num), (Object)num);
    }
}

