/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.model.manager.ModelFanManager;
import com.artfess.cssc.model.manager.ModelInfoManager;
import com.artfess.cssc.model.manager.ModelParamsManager;
import com.artfess.cssc.model.model.ModelFan;
import com.artfess.cssc.model.model.ModelInfo;
import com.artfess.cssc.model.model.ModelParams;
import com.artfess.cssc.model.params.ModelFanVo;
import com.artfess.cssc.scada.manager.PointSystemManager;
import com.artfess.cssc.util.SshUtil;
import com.artfess.job.persistence.manager.SchedulerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/biz/model/modelInfo/v1/"})
@Api(tags={"\u6a21\u578b\u57fa\u7840\u4fe1\u606f"})
@ApiGroup(group={"group_biz"})
public class ModelInfoController
extends BaseController<ModelInfoManager, ModelInfo> {
    @Resource
    ModelFanManager modelFanManager;
    @Resource
    ModelParamsManager modelParamsManager;
    @Resource
    PointSystemManager pointSystemManager;
    @Resource
    SchedulerService schedulerService;
    @Resource
    CacheManager cacheManager;
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"\u6a21\u578b\u53c2\u6570\u91c7\u96c6\u7f13\u5b58");

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<ModelInfo> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ModelInfo> queryFilter) {
        try {
            PageList pageList = ((ModelInfoManager)this.baseService).query(queryFilter);
            return pageList;
        }
        catch (Exception e) {
            return null;
        }
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u6a21\u578b\u4fe1\u606f\u5217\u8868", httpMethod="POST", notes="\u6a21\u578b\u4fe1\u606f\u5217\u8868")
    public List<ModelInfo> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<ModelInfo> queryFilter) throws Exception {
        List list = ((ModelInfoManager)this.baseService).queryNoPage(queryFilter);
        return list;
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u6a21\u578b\u4fe1\u606f\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u6a21\u578b\u4fe1\u606f") @RequestBody ModelInfo modelInfo) {
        modelInfo.setResultIsCreate(0);
        modelInfo.setTaosIsCreate(0);
        modelInfo.setFileIsUpload(0);
        String id = ((ModelInfoManager)this.baseService).insertModelInfo(modelInfo);
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01", (Object)id);
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u6a21\u578b\u4fe1\u606f")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u6a21\u578b\u4fe1\u606f") @RequestBody ModelInfo modelInfo) {
        try {
            boolean result = ((ModelInfoManager)this.baseService).updateModelInfo(modelInfo);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u6a21\u578b\u4fe1\u606f\u5931\u8d25");
            }
            return new CommonResult();
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((ModelInfoManager)this.baseService).deleteModelById(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        cache.delByKey("BIZ:SCADA:MODEL:PARAMS");
        return new CommonResult();
    }

    @PostMapping(value={"/updateSequence"})
    @ApiOperation(value="\u4fee\u6539\u6a21\u578b\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u4fee\u6539\u6a21\u578b\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="map", value="key:\u673a\u7ec4id,value:\u6392\u5e8f\u53f7", required=true) @RequestBody HashMap<String, Integer> map) throws Exception {
        ((ModelInfoManager)this.baseService).updateSequence(map);
        return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
    }

    @PostMapping(value={"/sshIsConnected"})
    @ApiOperation(value="\u6d4b\u8bd5\u8fdc\u7a0b\u8fde\u63a5", httpMethod="POST", notes="\u6d4b\u8bd5\u8fdc\u7a0b\u8fde\u63a5")
    public CommonResult<String> sshIsConnected(@ApiParam(name="host", value="\u8fdc\u7a0b\u670d\u52a1\u5668IP", required=true) @RequestParam String host, @ApiParam(name="port", value="\u8fdc\u7a0b\u670d\u52a1\u5668\u7aef\u53e3", required=true) @RequestParam int port, @ApiParam(name="username", value="\u8fdc\u7a0b\u670d\u52a1\u5668\u767b\u5f55\u8d26\u53f7", required=true) @RequestParam String username, @ApiParam(name="password", value="\u8fdc\u7a0b\u670d\u52a1\u5668\u767b\u5f55\u5bc6\u7801", required=true) @RequestParam String password) throws Exception {
        boolean result = SshUtil.isConnected(host, port, username, password);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u8fde\u63a5\u5931\u8d25\uff01");
        }
        return new CommonResult("\u8fde\u63a5\u6210\u529f\uff01");
    }

    @PostMapping(value={"/creatTaosTable"})
    @ApiOperation(value="\u521b\u5efa\u6d9b\u601d\u6570\u636e\u7684\u6a21\u578b\u8d85\u7ea7\u8868", httpMethod="POST", notes="\u521b\u5efa\u6d9b\u601d\u6570\u636e\u7684\u6a21\u578b\u8d85\u7ea7\u8868")
    public CommonResult<String> creatTaosTable(@ApiParam(name="id", value="\u6a21\u578bid", required=true) @RequestParam String id) throws Exception {
        boolean result = ((ModelInfoManager)this.baseService).creatTaosTable(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u521b\u5efa\u5931\u8d25\uff01");
        }
        return new CommonResult("\u521b\u5efa\u6210\u529f\uff01");
    }

    @PostMapping(value={"/creatResultTable"})
    @ApiOperation(value="\u521b\u5efa\u6a21\u578b\u8ba1\u7b97\u7ed3\u679c\u8868", httpMethod="POST", notes="\u521b\u5efa\u6a21\u578b\u8ba1\u7b97\u7ed3\u679c\u8868")
    public CommonResult<String> creatResultTable(@ApiParam(name="id", value="\u6a21\u578bid", required=true) @RequestParam String id) throws Exception {
        boolean result = ((ModelInfoManager)this.baseService).creatResultTable(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u521b\u5efa\u5931\u8d25\uff01");
        }
        return new CommonResult("\u521b\u5efa\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/importModel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0a\u4f20\u6a21\u578b", httpMethod="POST", notes="\u4e0a\u4f20\u6a21\u578b")
    public CommonResult<String> importModel(@ApiParam(name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody MultipartFile file, @ApiParam(name="modelId", value="\u6a21\u578bID", required=true) @RequestParam String modelId) throws Exception {
        try {
            boolean flag = ((ModelInfoManager)this.baseService).uploadForSSH(file, modelId);
            if (flag) {
                return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            }
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"modelFan/queryModelByFan"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u673a\u7ec4\u83b7\u53d6\u6a21\u578b\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u673a\u7ec4\u83b7\u53d6\u6a21\u578b\u4fe1\u606f")
    public List<ModelFanVo> queryModelByFan(@ApiParam(name="fanCode", value="\u673a\u7ec4\u7f16\u7801") @RequestParam String fanCode, @ApiParam(name="fanId", value="\u673a\u7ec4ID") @RequestParam String fanId, @ApiParam(name="modelCategory", value="\u6a21\u578b\u7c7b\u522b\uff081\uff1a\u673a\u7ec4\u8fd0\u7b97\u6a21\u578b\uff0c2\uff1a\u98ce\u573a\u8fd0\u7528\u6a21\u578b\uff09") @RequestParam(required=false) Integer modelCategory) throws Exception {
        return this.modelFanManager.queryModelByFan(fanCode, fanId, modelCategory);
    }

    @RequestMapping(value={"modelFan/queryFanByModel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6a21\u578b\u83b7\u53d6\u673a\u7ec4\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u6a21\u578b\u83b7\u53d6\u673a\u7ec4\u4fe1\u606f")
    public List<ModelFanVo> queryFanByModel(@ApiParam(name="modelId", value="\u6a21\u578bID") @RequestParam String modelId) throws Exception {
        return this.modelFanManager.queryFanByModel(modelId);
    }

    @RequestMapping(value={"modelFan/sliceQueryFanByModel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6a21\u578b\u83b7\u53d6\u5173\u8054\u7684\u673a\u7ec4\u5217\u8868", httpMethod="POST", notes="\u6839\u636e\u6a21\u578b\u83b7\u53d6\u5173\u8054\u7684\u673a\u7ec4\u5217\u8868")
    public PageList<ModelFanVo> sliceQueryFanByModel(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ModelFan> queryFilter) {
        queryFilter.addFilter("f.is_dele_", (Object)"1", QueryOP.NOT_EQUAL);
        return this.modelFanManager.sliceQueryFanByModel(queryFilter);
    }

    @RequestMapping(value={"modelFan/saveModelFans"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u673a\u7ec4\u5173\u8054\u6a21\u578b", httpMethod="POST", notes="\u4fdd\u5b58\u673a\u7ec4\u5173\u8054\u6a21\u578b")
    public CommonResult<String> saveModelFans(@ApiParam(name="modelFans", value="\u673a\u7ec4\u5173\u8054\u6a21\u578b", required=true) @RequestBody List<ModelFan> modelFans) throws Exception {
        CommonResult<String> result = this.modelFanManager.saveModelFans(modelFans);
        this.pointSystemManager.saveScadaPointCache();
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        cache.delByKey("BIZ:SCADA:MODEL:PARAMS");
        return result;
    }

    @DeleteMapping(value={"modelFan/deleteModelFans"})
    @ApiOperation(value="\u5220\u9664\u6a21\u578b\u4e0e\u673a\u7ec4\u5173\u8054", httpMethod="POST", notes="\u5220\u9664\u6a21\u578b\u4e0e\u673a\u7ec4\u5173\u8054")
    public CommonResult<String> deleteModelFans(String ... ids) throws Exception {
        boolean result = this.modelFanManager.removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        this.pointSystemManager.saveScadaPointCache();
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        cache.delByKey("BIZ:SCADA:MODEL:PARAMS");
        return new CommonResult();
    }

    @RequestMapping(value={"modelParams/sliceQueryParamByModel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5217\u8868", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5217\u8868")
    public PageList<ModelParams> sliceQueryParamByModel(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ModelParams> queryFilter) {
        return this.modelParamsManager.query(queryFilter);
    }

    @RequestMapping(value={"modelParams/queryParamByModel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5217\u8868")
    public List<ModelParams> queryParamByModel(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ModelParams> queryFilter) {
        return this.modelParamsManager.queryNoPage(queryFilter);
    }

    @PostMapping(value={"modelParams/"})
    @ApiOperation(value="\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u4fe1\u606f")
    public CommonResult<String> insertModelParams(@ApiParam(name="model", value="\u6a21\u578b\u53c2\u6570\u914d\u7f6e") @RequestBody ModelParams modelParams) {
        boolean result = this.modelParamsManager.insertModelParams(modelParams);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        if (modelParams.getParamClass().equals("Scada")) {
            this.pointSystemManager.saveScadaPointCache();
            ICache cache = this.cacheManager.getCache("", cacheSetting);
            cache.delByKey("BIZ:SCADA:MODEL:PARAMS");
        }
        return new CommonResult();
    }

    @PostMapping(value={"modelParams/insertBatch"})
    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u4fe1\u606f")
    public CommonResult<String> insertBatchModelParams(@ApiParam(name="modelParamsList", value="\u6a21\u578b\u53c2\u6570\u96c6\u5408", required=true) @RequestBody List<ModelParams> modelParamsList) {
        boolean result = this.modelParamsManager.insertBatchModelParams(modelParamsList);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        this.pointSystemManager.saveScadaPointCache();
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        cache.delByKey("BIZ:SCADA:MODEL:PARAMS");
        return new CommonResult();
    }

    @PutMapping(value={"modelParams/"})
    @ApiOperation(value="\u66f4\u65b0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u4fe1\u606f")
    public CommonResult<String> updateModelParams(@ApiParam(name="model", value="\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u4fe1\u606f") @RequestBody ModelParams modelParams) {
        boolean result = this.modelParamsManager.updateModelParams(modelParams);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25");
        }
        if (modelParams.getParamClass().equals("Scada")) {
            this.pointSystemManager.saveScadaPointCache();
            ICache cache = this.cacheManager.getCache("", cacheSetting);
            cache.delByKey("BIZ:SCADA:MODEL:PARAMS");
        }
        return new CommonResult();
    }

    @GetMapping(value={"modelParams/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u4fe1\u606f")
    public ModelParams getModelParamsById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return (ModelParams)((Object)this.modelParamsManager.getById((Serializable)((Object)id)));
    }

    @DeleteMapping(value={"modelParams/deleteModelParams"})
    @ApiOperation(value="\u5220\u9664\u6a21\u578b\u53c2\u6570\u914d\u7f6e", httpMethod="POST", notes="\u5220\u9664\u6a21\u578b\u53c2\u6570\u914d\u7f6e")
    public CommonResult<String> deleteModelParams(String ... ids) throws Exception {
        boolean result = this.modelParamsManager.removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        this.pointSystemManager.saveScadaPointCache();
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        cache.delByKey("BIZ:SCADA:MODEL:PARAMS");
        return new CommonResult();
    }

    @PostMapping(value={"modelParams/updateSequence"})
    @ApiOperation(value="\u4fee\u6539\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateFanSequence(@ApiParam(name="map", value="key:\u673a\u7ec4id,value:\u6392\u5e8f\u53f7", required=true) @RequestBody HashMap<String, Integer> map) throws Exception {
        this.modelParamsManager.updateSequence(map);
        return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"modelResult/sliceQueryModelResult"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6a21\u578b\u8ba1\u7b97\u7ed3\u679c", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2\u6a21\u578b\u8ba1\u7b97\u7ed3\u679c")
    public Object sliceQueryModelResult(@ApiParam(name="modelId", value="\u6a21\u578bID") @RequestParam String modelId, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((ModelInfoManager)this.baseService).sliceQueryModelResult(modelId, queryFilter);
    }
}

