/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.base.dao.SystemInfoDao;
import com.artfess.cssc.base.manager.SystemInfoManager;
import com.artfess.cssc.base.model.SystemInfo;
import com.artfess.cssc.scada.manager.PointSystemManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SystemInfoManagerImpl
extends BaseManagerImpl<SystemInfoDao, SystemInfo>
implements SystemInfoManager {
    @Resource
    PointSystemManager pointSystemManager;
    @Autowired
    RabbitTemplate rabbitTemplate;

    @Override
    @Transactional
    public boolean insertSystemInfo(SystemInfo systemInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)systemInfo))) {
            if (this.checkSameCode(systemInfo.getSysCode(), systemInfo.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u5916\u63a5\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25\uff0c\u53d8\u91cf\u7f16\u7801\u3010" + systemInfo.getSysCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            systemInfo.setIsQueue(0);
            systemInfo.setSn(this.getNextSequence(null));
            Integer result = ((SystemInfoDao)this.baseMapper).insert((Object)systemInfo);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateSystemInfo(SystemInfo systemInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)systemInfo))) {
            if (this.checkSameCode(systemInfo.getSysCode(), systemInfo.getId())) {
                throw new RequiredException("\u4fee\u6539\u5916\u63a5\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25\uff0c\u53d8\u91cf\u7f16\u7801\u3010" + systemInfo.getSysCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((SystemInfoDao)this.baseMapper).updateById((Object)systemInfo);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean deleteById(String id) {
        Assert.hasText((String)id, (String)"\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        boolean flag = this.pointSystemManager.deletePointSystemBySysID(id);
        if (flag) {
            return this.removeById((Serializable)((Object)id));
        }
        return false;
    }

    @Override
    @Transactional
    public boolean deleteByIds(List<String> idList) {
        if (BeanUtils.isNotEmpty(idList)) {
            for (String id : idList) {
                this.pointSystemManager.deletePointSystemBySysID(id);
            }
            return this.removeByIds(idList);
        }
        throw new RequiredException("\u5220\u9664\u5916\u63a5\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25\uff0cid\u4e3a\u7a7a\uff01");
    }

    @Override
    @Transactional
    public boolean updateSendData(String id, Integer isSendData) {
        if (StringUtil.isEmpty((String)id)) {
            throw new RequiredException("\u4e1a\u52a1\u7cfb\u7edfid\u4e3a\u7a7a\uff01\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u4e1a\u52a1\u7cfb\u7edf\u6570\u636e\uff01");
        }
        if (BeanUtils.isEmpty((Object)isSendData)) {
            throw new RequiredException("\u4fee\u6539\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SystemInfo systemInfo = (SystemInfo)((Object)((SystemInfoDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (BeanUtils.isEmpty((Object)((Object)systemInfo))) {
            throw new RequiredException("\u7cfb\u7edf\u6ca1\u6709\u627e\u5230\u6b64\u7cfb\u7edf\u4fe1\u606f\uff01");
        }
        if (isSendData == 1 && systemInfo.getIsQueue() == 0) {
            String queueName = "hz." + systemInfo.getSysCode() + ".scada";
            Queue queue = null;
            if (systemInfo.getOutTimes() > 0L) {
                HashMap<String, Long> args = new HashMap<String, Long>();
                args.put("x-message-ttl", systemInfo.getOutTimes());
                queue = new Queue(queueName, true, false, false, args);
            } else {
                queue = new Queue(queueName, true, false, false);
            }
            Binding bind = new Binding(queueName, Binding.DestinationType.QUEUE, "exchange.hz", queueName, null);
            RabbitAdmin rabbitAdmin = new RabbitAdmin(this.rabbitTemplate.getConnectionFactory());
            rabbitAdmin.declareQueue(queue);
            rabbitAdmin.declareBinding(bind);
            systemInfo.setIsQueue(1);
        }
        systemInfo.setIsSendData(isSendData);
        Integer result = ((SystemInfoDao)this.baseMapper).updateById((Object)systemInfo);
        this.pointSystemManager.saveScadaPointCache();
        return null != result && result >= 1;
    }

    @Override
    public SystemInfo getByCode(String code) {
        Assert.hasText((String)code, (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SYS_CODE_", (Object)code);
        return (SystemInfo)((Object)((SystemInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    private boolean checkSameCode(String sysCode, String id) {
        Assert.hasText((String)sysCode, (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SYS_CODE_", (Object)sysCode);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"ID_", (Object)id);
        int num = ((SystemInfoDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

