const websock = null;
const global_callback = null;
const serverPort = '5000'; //webSocket连接端口


function getWebIP() {
    var curIP = window.location.hostname;
    return curIP;
}

function initWebSocket() { //初始化weosocket
    var url =
        window.context.WebSocket
        .replace('https://', 'wss://')
        .replace('http://', 'ws://') +
        '/websocket'

    websock = new WebSocket(url)
    websock.onopen = websocketOnopen
    websock.onerror = websocketOnerror
    websock.onmessage = websocketOnmessage
    websock.onclose = websocketOnclose
}

function websocketOnopen() {
    console.log('WebSocket连接成功')
    this.heartCheck.reset().start();
};

function websocketOnerror(e) {
    console.log(e, 'WebSocket连接发生错误')
    this.reconnect()
};

function websocketOnmessage(e) {
    console.log('-----接收消息-------', e.data)
    var data = eval('(' + e.data + ')') //解析对象
    if (data.cmd == 'dict') {
        // 重载字典
        this.getSysDict()
    }
};

function websocketOnclose(e) {
    console.log('connection closed (' + e.code + ')')
    this.reconnect();
};




// 实际调用的方法
function sendSock(agentData, callback) {
    global_callback = callback;
    if (websock.readyState === websock.OPEN) {
        //若是ws开启状态
        websocketsend(agentData)
    } else if (websock.readyState === websock.CONNECTING) {
        // 若是 正在开启状态，则等待1s后重新调用
        setTimeout(function () {
            sendSock(agentData, callback);
        }, 1000);
    } else {
        // 若未开启 ，则等待1s后重新调用
        setTimeout(function () {
            sendSock(agentData, callback);
        }, 1000);
    }
}

//数据接收
function websocketonmessage(e) {
    global_callback(JSON.parse(e.data));
}

//数据发送
function websocketsend(agentData) {
    websock.send(JSON.stringify(agentData));
}

//关闭
function websocketclose(e) {
    console.log("connection closed (" + e.code + ")");
}

function websocketOpen(e) {
    console.log("连接成功");
}

function reconnect() {
    if (this.lockReconnect) return
    this.lockReconnect = true
    //没连接上会一直重连，设置延迟避免请求过多
    setTimeout(() => {
        console.info('尝试重连...')
        this.initWebSocket()
        this.lockReconnect = false
    }, 5000)
};

initWebSocket();

export {
    sendSock
}