import req from '@/request.js'

const cssc = window.context.cssc
export default {
    loadBizSystemInfo(data) {
        return new Promise((resolve, reject) => {
            req.post(cssc + `/biz/base/systemInfo/v1/query`, data).then(
                resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    getBizSystemInfoById(id) {
        return new Promise((resolve, reject) => {
            req.get(cssc + `biz/base/bizSystemInfo/v1/` + id).then(
                resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 
    loadBizParamsInfo(data) {
        return new Promise((resolve, reject) => {
            req.post(cssc + `/biz/base/params/v1/paramsConf/getParamsConfPage`, data).then(
                resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 获取风场扩展参数
    getWindfieldExtend(){
        return new Promise((resolve, reject) => {
            req.get(cssc + `/biz/base/params/v1/wfParamsConf/getWfParamsConf`).then(
                resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 获取机组扩展参数
    getCrewExtend(){
        return new Promise((resolve, reject) => {
            req.get(cssc + `/biz/base/params/v1/fanParamsConf/getFanParamsConf`).then(
                resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 获取风场线路list
    getLineList(){
        return new Promise((resolve, reject) => {
            req.post(cssc + `/biz/base/wfLine/v1/list`, {}).then(
                resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                }
            ).catch(error=>{
                reject(error)
            })
        })
    }
    
}