import req from '@/request.js'
const cssc = window.context.cssc
export default {
  // 获取健康监测机组状态
  getCrewList(data) {
    return new Promise((resolve, reject) => {
      req.post(cssc + `/biz/jkjc/health/v1/queryPage`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 获取健康监测总览
  getHealthOverview(data) {
    return new Promise((resolve, reject) => {
      req.get(cssc + `/biz/jkjc/health/v1/getJsonRemoteOverview`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 健康状态统计
  getHealthStatus(data) {
    return new Promise((resolve, reject) => {
      req.get(cssc + `/biz/jkjc/health/v1/getJsonHealth?time=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
}
