package com.artfess.security.controller;

import com.artfess.security.manager.SecurityMachineManager;
import com.artfess.security.manager.SecurityPersonloginlimitManager;
import com.artfess.security.model.SecurityMachine;
import com.artfess.security.vo.PersonloginlimitVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 安全中心  ---  涉密计算机维护表 前端控制器
 *
 * @author cs
 * @company 阿特菲斯
 * @since 2021-03-04
 */
@RestController
@RequestMapping("/uc/Machine/v1/")
@Api(tags = "涉密计算机维护")
@ApiGroup(group = {ApiGroupConsts.GROUP_UC})
public class SecurityMachineController extends BaseController<SecurityMachineManager, SecurityMachine> {

    @Resource
    SecurityPersonloginlimitManager personloginlimitService;

    @RequestMapping(value = "saveMachine", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存或修改涉密计算机", httpMethod = "POST", notes = "保存或修改涉密计算机")
    public CommonResult<String> saveMachine(@ApiParam(name="model", value="涉密计算机信息") @RequestBody SecurityMachine machine) throws Exception {
        this.baseService.saveMachine(machine);
        return new CommonResult<>("保存成功！");
    }

    @RequestMapping(value = "deleteBatchMachine", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量删涉密计算机", httpMethod = "DELETE", notes = "批量删涉密计算机（id多个用,号隔开）")
    public CommonResult<String> deleteBatchMachine(@ApiParam(name = "ids", value = "关联表ID") @RequestParam(required = true) String ids) throws Exception {
        List<String> idList = Arrays.asList(ids.split(","));
        if(idList!=null && idList.size()>0){
            for(String machineId : idList) {
                personloginlimitService.deleteByMachineId(machineId);
            }
            boolean result = this.baseService.removeByIds(idList);
            if (!result) {
                return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除失败");
            }
            return new CommonResult<>("删除成功！");
        }else {
            return new CommonResult<>("没有删除的数据！");
        }
    }
    @RequestMapping(value="updateMachineSn",method=RequestMethod.PUT, produces = {"application/json; charset=utf-8" })
    @ApiOperation(value = "根据ID批量修改排序号", httpMethod = "PUT", notes = "根据ID批量修改排序号")
    @ApiImplicitParam(name = "map", value = "key:功能id,value:排序号", required = true)
    public  CommonResult<String> updateMachineSn(@RequestBody HashMap<String,Integer> map) throws Exception  {
        this.baseService.updateSequence(map);
        return new CommonResult<>("修改成功！");
    }

    @RequestMapping(value = "queryPersonloginlimitPage", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "人员关联设备 -- 分页查询人员关联涉密设备", httpMethod = "POST", notes = "分页查询人员关联涉密设备")
    public PageList<PersonloginlimitVo> queryPersonloginlimitPage(@ApiParam(name = "filter", value = "查询参数", required = true) @RequestBody QueryFilter filter) throws Exception {
        IPage<PersonloginlimitVo> list = personloginlimitService.queryPersonloginlimitPage(filter);
        return new PageList<PersonloginlimitVo>(list);
    }

    @RequestMapping(value = "insertPersonloginlimit", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "人员关联设备 -- 绑定人员涉密计算机", httpMethod = "POST", notes = "人员关联设备 -- 绑定人员涉密计算机, 用户id（多个用,号隔开）")
    public CommonResult<String> insertPersonloginlimit(@ApiParam("设备_ID") @RequestParam(required = true) String machineId,
                                                       @ApiParam("所选用户的Id,多个以“,”隔开") @RequestParam(required = true) String userIds) throws Exception {
        return personloginlimitService.insertPersonloginlimit(machineId, userIds);
    }

    @RequestMapping(value = "deletePersonloginlimis", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "人员关联设备 -- 根据关联id删除人员与涉密计算机关联", httpMethod = "DELETE", notes = "人员关联设备 -- 根据关联id删除人员与涉密计算机关联（多个用,号隔开）")
    public CommonResult<String> deletePersonloginlimis(@ApiParam(name = "ids", value = "关联表ID") @RequestParam(required = true) String ids) throws Exception {
        boolean result = personloginlimitService.removeByIds(Arrays.asList(ids.split(",")));
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除失败");
        }
        return new CommonResult<>("删除成功！");
    }
}
