/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.entity.CqltTreeModel;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.SubjectTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqlt.dao.QfSubjectInfoDao;
import com.artfess.cqlt.manager.QfSubjectInfoManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.manager.QfSubjectRelationManager;
import com.artfess.cqlt.model.QfSubjectInfo;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class QfSubjectInfoManagerImpl
extends BaseManagerImpl<QfSubjectInfoDao, QfSubjectInfo>
implements QfSubjectInfoManager {
    @Resource
    private QfSubjectRelationManager qfSubjectRelationService;
    @Resource
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Resource
    private SysDictionaryManager sdm;

    @Override
    public List<QfSubjectInfo> getTree(QfSubjectInfo entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)entity.getCode())) {
            queryWrapper.like((Object)"code_", (Object)entity.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
            queryWrapper.like((Object)"name_", (Object)entity.getName());
        }
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        queryWrapper.orderByAsc((Object)"sn_");
        List sysList = ((QfSubjectInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        List tree = BeanUtils.listToTree((List)sysList);
        return tree;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void associatedSubject(QfSubjectInfo t) {
        if (CollectionUtils.isEmpty(t.getList())) {
            return;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sub_id_", (Object)t.getId());
        this.qfSubjectRelationService.getBaseMapper().delete((Wrapper)queryWrapper);
        this.qfSubjectRelationService.saveBatch(t.getList());
    }

    @Override
    public QfSubjectInfo findById(String id) {
        QfSubjectInfo qfSubjectInfo = (QfSubjectInfo)((Object)((QfSubjectInfoDao)this.baseMapper).selectById((Serializable)((Object)id)));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sub_id_", (Object)id);
        List qfSubjectRelations = this.qfSubjectRelationService.getBaseMapper().selectList((Wrapper)queryWrapper);
        qfSubjectRelations.forEach(qfSubjectRelation -> {
            QfSubjectInternationalInfo qfSubjectInternationalInfos = (QfSubjectInternationalInfo)((Object)((Object)this.subjectInternationalInfoManager.getBaseMapper().selectById((Serializable)((Object)qfSubjectRelation.getInterId()))));
            if (null != qfSubjectInternationalInfos) {
                qfSubjectRelation.setInternationalName(qfSubjectInternationalInfos.getName());
            }
        });
        qfSubjectInfo.setList(qfSubjectRelations);
        return qfSubjectInfo;
    }

    @Override
    @Transactional
    public boolean importExcel(List<QfSubjectInfo> list) {
        ArrayList relationData = Lists.newArrayList();
        List internationalInfos = this.subjectInternationalInfoManager.list();
        list.stream().sorted(Comparator.comparing(QfSubjectInfo::getLevel)).forEach(subject -> {
            boolean isExpression;
            subject.setType(SubjectTypeEnum.getType((String)subject.getType()));
            if (subject.getLevel() == 1) {
                subject.setParentId("0");
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"code_", (Object)subject.getParentCode());
            QfSubjectInfo qfSubjectInfo = (QfSubjectInfo)((Object)((Object)((QfSubjectInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper)));
            if (null != qfSubjectInfo) {
                subject.setParentId(qfSubjectInfo.getId());
            }
            subject.setName(subject.getSubjectName());
            subject.setCode(subject.getSubjectCode());
            subject.setSn(subject.getLevel());
            String relation = subject.getRelation();
            if (null == relation) {
                return;
            }
            subject.setRelation(subject.getRelation().replace("\u65e0", ""));
            boolean bl = isExpression = relation.contains("+") || relation.contains("-");
            if (isExpression) {
                subject.setExpression(relation);
            }
            this.newInsertTree((CqltTreeModel)subject);
        });
        return true;
    }

    @Transactional
    public String newSaveTree(CqltTreeModel e, boolean useDefaultCheck) {
        QfSubjectInfo entity = (QfSubjectInfo)e;
        QfSubjectInfoDao m = (QfSubjectInfoDao)super.getBaseMapper();
        if (useDefaultCheck) {
            List duplicateEntities = this.findDuplicateEntities(entity.getId(), entity.getParentId(), entity.getCode(), entity.getName());
            QfSubjectInfo other = null;
            if (duplicateEntities.size() > 0) {
                other = (QfSubjectInfo)((Object)duplicateEntities.get(0));
            }
            entity.checkConstraints(other);
        }
        if (entity.isNew()) {
            entity.setHasChildren(0);
            m.insert((Object)entity);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code_", (Object)entity.getParentCode());
        QfSubjectInfo parent = (QfSubjectInfo)((Object)((QfSubjectInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        e.buildFullIdAndName((CqltTreeModel)parent);
        if (e.getSn() == null) {
            e.setSn(Integer.valueOf(parent == null ? 1 : parent.getHasChildren() + 1));
        }
        m.updateById((Object)entity);
        if (parent != null) {
            QueryWrapper queryWrappe = new QueryWrapper();
            queryWrappe.eq(StringUtils.isNotEmpty((CharSequence)entity.getParentCode()), (Object)"parent_code_", (Object)entity.getParentCode());
            Integer childrenCount = ((QfSubjectInfoDao)this.baseMapper).selectCount((Wrapper)queryWrappe);
            parent.setHasChildren(childrenCount);
            m.updateById((Object)parent);
        }
        return entity.getId();
    }
}

