/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.manager.QfFinanceLeaseDManager;
import com.artfess.cqlt.manager.QfFinanceLiquidityDetailManager;
import com.artfess.cqlt.manager.QfFinanceLoanDManager;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5927\u5c4f\u7edf\u8ba1--\u8d44\u91d1\u4e3b\u9898"})
@RequestMapping(value={"/qf/money/statistical/"})
@ApiGroup(group={"group_biz"})
public class QfWeeklyCashStatisticalController {
    private static final Logger log = LoggerFactory.getLogger(QfWeeklyCashStatisticalController.class);
    @Autowired
    private QfFinanceLiquidityDetailManager financeLiquidityDetailManager;
    @Autowired
    private QfFinanceLoanDManager financeLoanDManager;
    @Autowired
    private QfFinanceLeaseDManager financeLeaseDManager;
    @Autowired
    private QfFinancialStatisticalManager financialStatisticalManager;

    @PostMapping(value={"/poolPlanData"})
    @ApiOperation(value="\u8d44\u91d1\u6c60\u516c\u53f8\u94f6\u884c\u5b9e\u65f6\u4f59\u989d", response=FaTargetRespVo.class)
    public CommonResult<String> poolPlanData(@ApiParam(name="model", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody ReportReqVo t) {
        List<FaReportRespVo> data = this.financeLiquidityDetailManager.poolPlanData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping(value={"/groupPlanData"})
    @ApiOperation(value="\u96c6\u56e2\u94f6\u884c\u5b9e\u65f6\u4f59\u989d", response=FaTargetRespVo.class)
    public CommonResult<String> groupPlanData(@ApiParam(name="model", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody ReportReqVo t) {
        List<FaReportRespVo> data = this.financeLiquidityDetailManager.groupPlanData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping(value={"/companyPlanData"})
    @ApiOperation(value="\u975e\u8d44\u91d1\u6c60\u516c\u53f8\u94f6\u884c\u5b9e\u65f6\u4f59\u989d", response=FaTargetRespVo.class)
    public CommonResult<String> companyPlanData(@ApiParam(name="model", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody ReportReqVo t) {
        List<FaReportRespVo> data = this.financeLiquidityDetailManager.companyPlanData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping(value={"/chinaCompanyData"})
    @ApiOperation(value="\u4e2d\u56fd\u533a\u516c\u53f8\u94f6\u884c\u5b9e\u65f6\u4f59\u989d", response=FaTargetRespVo.class)
    public CommonResult<String> chinaCompanyData(@ApiParam(name="model", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody ReportReqVo t) {
        List<FaReportRespVo> data = this.financeLiquidityDetailManager.chinaCompanyData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping(value={"/oneLevelData"})
    @ApiOperation(value="\u8d44\u91d1\u5927\u5c4f\u4e00\u7ea7\u6307\u6807\u7edf\u8ba1\u63a5\u53e3", response=FaTargetRespVo.class)
    public CommonResult<String> oneLevelData(@ApiParam(name="model", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = this.financialStatisticalManager.moneyData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping(value={"/fromUnderData"})
    @ApiOperation(value="\u8d44\u91d1\u5927\u5c4f\u5f53\u524d\u4ee5\u53ca\u4e0b\u64b0\u6307\u6807\u7edf\u8ba1\u63a5\u53e3")
    public CommonResult<String> fromUnderData(@ApiParam(name="model", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = this.financialStatisticalManager.fromUnderData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping(value={"/dataAnalysis"})
    @ApiOperation(value="\u6570\u636e\u5206\u6790\u63a5\u53e3")
    public CommonResult<String> dataAnalysis(@ApiParam(name="model", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = this.financialStatisticalManager.dataAnalysis(t);
        return CommonResult.success(data, null);
    }
}

