package com.artfess.report.bigScreen.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 可视化分类表
 *
 * @company 阿特菲斯
 * @author 向贞好
 * @since 2021-07-12
 */
@ApiModel(value="BladeVisualCategory对象", description="可视化分类表")
public class BladeVisualCategory extends BaseModel<BladeVisualCategory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "分类键值")
    @TableField("category_key_")
    private String categoryKey;

    @ApiModelProperty(value = "分类名称")
    @TableField("category_value_")
    private String categoryValue;

    @ApiModelProperty(value = "是否已删除  0:未删除 1:已删除")
    @TableField("is_dele_")
    private String isDele;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getCategoryKey() {
        return categoryKey;
    }

    public void setCategoryKey(String categoryKey) {
        this.categoryKey = categoryKey;
    }
    public String getCategoryValue() {
        return categoryValue;
    }

    public void setCategoryValue(String categoryValue) {
        this.categoryValue = categoryValue;
    }
    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BladeVisualCategory{" +
            "id=" + id +
            ", categoryKey=" + categoryKey +
            ", categoryValue=" + categoryValue +
            ", isDele=" + isDele +
        "}";
    }
}
