package com.artfess.workflow.runtime.params;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import com.artfess.base.model.CommonResult;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;

/**
 * 启动流程的结果
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author zhangxianwen
 * @email zhangxw@jee-soft.cn
 * @date 2018年6月28日
 */
@ApiModel(value="启动流程的结果",parent=CommonResult.class)
public class StartResult extends CommonResult<String>{
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(name="message",notes="流程实例ID",example="10000000000001",required=true)
	private String instId;
	
	@ApiModelProperty(name="curBoPkVal",notes="当前表单主表数据id",example="10000000000001",required=true)
	private String curBoPkVal;
	
	@ApiModelProperty(name="tasks",notes="自己可以审批的任务",required=true)
	private List<DefaultBpmTask> tasks;
	
	@ApiModelProperty(name="inst",notes="实例对象",required=true)
	private DefaultBpmProcessInstance inst;
	
	
	public DefaultBpmProcessInstance getInst() {
		return inst;
	}

	public void setInst(DefaultBpmProcessInstance inst) {
		this.inst = inst;
	}

	public List<DefaultBpmTask> getTasks() {
		return tasks;
	}

	public void setTasks(List<DefaultBpmTask> tasks) {
		this.tasks = tasks;
	}

	public StartResult(String instId){
		this.instId = instId;
	}
	
	public StartResult(String message, String instId){
		super(message);
		this.instId = instId;
	}
	public StartResult(String message, String instId, String curBoPkVal) {
		super(message);
		this.instId = instId;
		this.curBoPkVal = curBoPkVal;
	}
	
	public StartResult(String message, String instId, String curBoPkVal,List<DefaultBpmTask> tasks,DefaultBpmProcessInstance inst) {
		super(message);
		this.inst=inst;
		this.tasks=tasks;
		this.instId = instId;
		this.curBoPkVal = curBoPkVal;
	}

	public String getInstId() {
		return instId;
	}
	public void setInstId(String instId) {
		this.instId = instId;
	}

	public String getCurBoPkVal() {
		return curBoPkVal;
	}

	public void setCurBoPkVal(String curBoPkVal) {
		this.curBoPkVal = curBoPkVal;
	}
	
}
