package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 区域
 */
@Getter
public enum ContinentEnum {
    /**
     * 亚洲
     */
    Asia("0", "Asia"),

    Europe("1", "Europe"),

    America("2", "America"),

    Group("4", "CIGR"),

    ;

    ContinentEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        ContinentEnum[] values = values();
        for (ContinentEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
