/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.CachePut;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.cache.annotation.FirstCache;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.SystemException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.template.impl.FreeMarkerEngine;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FilterJsonStructUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bo.bodef.BoDefService;
import com.artfess.bo.context.FormContextThreadUtil;
import com.artfess.bo.instance.BoDataHandler;
import com.artfess.bo.instance.BoDataImportHandler;
import com.artfess.bo.instance.BoInstanceFactory;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.model.BoResult;
import com.artfess.bo.model.ValidateResult;
import com.artfess.bo.persistence.manager.BoAttributeManager;
import com.artfess.bo.persistence.manager.BoEntManager;
import com.artfess.bo.util.BoUtil;
import com.artfess.form.manager.FormDataTemplateExtendManager;
import com.artfess.form.manager.FormRemindDataManager;
import com.artfess.form.model.DisplayField;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormDataImportLog;
import com.artfess.form.model.FormDataTemplate;
import com.artfess.form.model.FormDataTemplateDraft;
import com.artfess.form.model.FormDataTemplateExtend;
import com.artfess.form.model.FormDataTemplateXml;
import com.artfess.form.model.FormDataTemplateXmlList;
import com.artfess.form.model.FormField;
import com.artfess.form.model.FormMeta;
import com.artfess.form.model.FormRemindData;
import com.artfess.form.model.FormTemplate;
import com.artfess.form.param.DataTemplateQueryVo;
import com.artfess.form.param.SelectParam;
import com.artfess.form.persistence.dao.FormDataTemplateDao;
import com.artfess.form.persistence.manager.FormDataImportLogManager;
import com.artfess.form.persistence.manager.FormDataTemplateDraftManager;
import com.artfess.form.persistence.manager.FormDataTemplateManager;
import com.artfess.form.persistence.manager.FormFieldManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.persistence.manager.FormRightManager;
import com.artfess.form.persistence.manager.FormTemplateManager;
import com.artfess.form.service.FormService;
import com.artfess.form.util.FormUtil;
import com.artfess.form.util.FreeMakerUtil;
import com.artfess.form.vo.ExportSubVo;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.table.datasource.DataSourceUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.impl.util.PermissionCalc;
import com.artfess.uc.api.impl.util.PermissionUtil;
import com.artfess.uc.api.impl.var.IContextVar;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service(value="bpmDataTemplateManager")
public class FormDataTemplateManagerImpl
extends BaseManagerImpl<FormDataTemplateDao, FormDataTemplate>
implements FormDataTemplateManager {
    private static final String LOGIN_USER = "loginUser";
    private static final String LOGIN_USER_ORGS = "loginUserOrgs";
    private static final String LOGIN_USER_SUB_ORGS = "loginUserSubOrgs";
    private static final String CUSTOM_ORGS = "customOrgs";
    private static final String[] flowField = new String[]{"F_bpm_proc_inst_id_", "F_bpm_subject_", "F_bpm_proc_def_name_", "F_bpm_status_", "F_bpm_create_time_", "F_bpm_end_time_", "F_bpm_is_forbidden_", "F_bpm_creator_", "F_bpm_is_dele_"};
    @Resource
    FormTemplateManager formTemplateManager;
    @Resource
    FormManager formManager;
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    BoDataHandler boDataHandler;
    @Resource
    BoInstanceFactory boInstanceFactory;
    @Resource
    BoDefService boDefService;
    @Resource(name="formPermissionCalc")
    PermissionCalc permssionCalc;
    @Resource
    FreeMarkerEngine freemarkEngine;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    FormMetaManager formMetaManager;
    @Autowired
    UserDetailsService userDetailsService;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoAttributeManager boAttributeManager;
    @Resource
    FormRightManager bpmFormRightManager;
    @Resource
    FormService formService;
    @Resource
    WorkflowFeignService workflowFeignService;
    @Resource
    CommonManager commonManager;
    @Resource
    FormDataTemplateDraftManager dataTemplateDraftManager;
    @Resource
    FormDataImportLogManager formDataImportLogManager;
    @Resource
    FormDataTemplateExtendManager formDataTemplateExtendManager;
    @Resource
    FormRemindDataManager formRemindDataManager;

    @Override
    public ObjectNode getByFormKey(String formKey, String boId) throws IOException {
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        jsonObject.put("status", 1);
        jsonObject.put("msg", "\u652f\u6301\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6a21\u677f");
        List<Object> templates = new ArrayList();
        FormDataTemplate bpmDataTemplate = new FormDataTemplate();
        List<Object> fields = new ArrayList();
        ArrayList<FormField> formField = new ArrayList<FormField>();
        BoDef baseBoDef = null;
        String boDefId = "";
        String colPrefix = "";
        String displaySettingFields = "";
        Boolean flag = true;
        List subEnt = new ArrayList();
        Form bpmForm = this.formManager.getMainByFormKey(formKey);
        String formId = bpmForm.getDefId();
        List<String> boDefIds = this.formMetaManager.getBODefIdByFormId(formId);
        if (BeanUtils.isEmpty(boDefIds)) {
            ThreadMsgUtil.addMsg((String)"\u8be5\u4e1a\u52a1\u8868\u5355BO\u4e3a\u7a7a");
            jsonObject.put("status", 0);
            jsonObject.put("msg", ThreadMsgUtil.getMessage().trim());
            flag = false;
        }
        if (flag.booleanValue()) {
            boDefId = boDefIds.get(0);
            if (StringUtil.isNotEmpty((String)boId)) {
                for (int i = 0; i < boDefIds.size(); ++i) {
                    if (!boDefIds.get(i).equals(boId)) continue;
                    boDefId = boDefIds.get(i);
                }
            }
            String string = colPrefix = (baseBoDef = this.boDefService.getByDefId(boDefId)).getBoEnt().isExternal() ? "" : "F_";
            if (!baseBoDef.isSupportDb()) {
                jsonObject.put("status", 0);
                jsonObject.put("msg", "\u8be5\u8868\u5355\u4e0d\u652f\u6301\u6570\u636e\u5e93\uff0c\u4e0d\u80fd\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6a21\u677f");
                flag = false;
            }
        }
        if (flag.booleanValue()) {
            BoDef boDef = this.boDefService.getByAlias(baseBoDef.getAlias());
            BoEnt boEnt = boDef.getBoEnt();
            fields = this.getFormFields(boEnt.getId());
            for (FormField formField2 : fields) {
                formField.add(formField2);
            }
            displaySettingFields = this.getDisplayField(fields, "");
            bpmDataTemplate = new FormDataTemplate();
            bpmDataTemplate.setFormKey(formKey);
            bpmDataTemplate.setDisplayField(displaySettingFields);
            bpmDataTemplate.setBoDefId(boDefId);
            bpmDataTemplate.setBoDefAlias(baseBoDef.getAlias());
            bpmDataTemplate.setName(bpmForm.getName());
            bpmDataTemplate.setTypeId(bpmForm.getTypeId());
            bpmDataTemplate.setTypeName(bpmForm.getTypeName());
            if (StringUtil.isNotEmpty((String)bpmDataTemplate.getDefId())) {
                this.addFieldList(fields);
            }
            subEnt = boEnt.getChildEntList();
        }
        templates = this.formTemplateManager.getTemplateType("dataTemplate");
        jsonObject.set("templates", JsonUtil.toJsonNode(templates));
        jsonObject.set("bpmDataTemplate", JsonUtil.toJsonNode((Object)((Object)bpmDataTemplate)));
        jsonObject.set("fields", JsonUtil.toJsonNode(fields));
        jsonObject.put("displaySettingFields", displaySettingFields);
        jsonObject.set("data", (JsonNode)this.tidyJson(bpmDataTemplate));
        jsonObject.put("colPrefix", colPrefix);
        jsonObject.put("formId", formId);
        jsonObject.set("formField", JsonUtil.toJsonNode(formField));
        jsonObject.set("subFormField", JsonUtil.toJsonNode(subEnt));
        jsonObject.set("permissionList", PermissionUtil.getPermissionList((String)"formPermissionCalcList"));
        return jsonObject;
    }

    @Override
    public ObjectNode getByTemplateId(String id, String boId) throws IOException {
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        jsonObject.put("status", 1);
        jsonObject.put("msg", "\u652f\u6301\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6a21\u677f");
        List<Object> templates = new ArrayList();
        FormDataTemplate bpmDataTemplate = (FormDataTemplate)this.get((Serializable)((Object)id));
        bpmDataTemplate.setRemindSettingList(this.formDataTemplateExtendManager.getJsonByFormDataTemplateId(id));
        ArrayList<FormField> fields = new ArrayList();
        ArrayList<FormField> formField = new ArrayList<FormField>();
        BoDef baseBoDef = null;
        String boDefId = "";
        String colPrefix = "";
        String displaySettingFields = "";
        Boolean flag = true;
        String formKey = bpmDataTemplate.getFormKey();
        List subEnt = new ArrayList();
        Form bpmForm = this.formManager.getMainByFormKey(formKey);
        String formId = bpmForm.getDefId();
        List<String> boDefIds = this.formMetaManager.getBODefIdByFormId(formId);
        if (BeanUtils.isEmpty(boDefIds)) {
            ThreadMsgUtil.addMsg((String)"\u8be5\u4e1a\u52a1\u8868\u5355BO\u4e3a\u7a7a");
            jsonObject.put("status", 0);
            jsonObject.put("msg", ThreadMsgUtil.getMessage().trim());
            flag = false;
        }
        if (flag.booleanValue()) {
            boDefId = boDefIds.get(0);
            if (StringUtil.isNotEmpty((String)boId)) {
                for (int i = 0; i < boDefIds.size(); ++i) {
                    if (!boDefIds.get(i).equals(boId)) continue;
                    boDefId = boDefIds.get(i);
                }
            }
            String string = colPrefix = (baseBoDef = this.boDefService.getByDefId(boDefId)).getBoEnt().isExternal() ? "" : "F_";
            if (!baseBoDef.isSupportDb()) {
                jsonObject.put("status", 0);
                jsonObject.put("msg", "\u8be5\u8868\u5355\u4e0d\u652f\u6301\u6570\u636e\u5e93\uff0c\u4e0d\u80fd\u751f\u6210\u4e1a\u52a1\u6570\u636e\u6a21\u677f");
                flag = false;
            }
        }
        if (flag.booleanValue()) {
            BoDef boDef = this.boDefService.getByAlias(baseBoDef.getAlias());
            BoEnt boEnt = boDef.getBoEnt();
            fields = this.getFormFields(boEnt.getId());
            List<FormField> initFields = this.formFieldManager.getByFormIdAndBoDefId(formId, boDefId);
            for (FormField bpmFormField : initFields) {
                if (bpmFormField.getEntId() == null || !bpmFormField.getEntId().equals(boEnt.getId()) || "sub".equals(bpmFormField.getCtrlType()) || "tabs".equals(bpmFormField.getCtrlType())) continue;
                formField.add(bpmFormField);
            }
            if (StringUtil.isNotEmpty((String)bpmDataTemplate.getDefId())) {
                this.addFieldList(fields);
            }
            displaySettingFields = this.getDisplayField(fields, "");
            bpmDataTemplate.setDisplayField(bpmDataTemplate.getDisplayField());
            subEnt = boEnt.getChildEntList();
        }
        templates = this.formTemplateManager.getTemplateType("dataTemplate");
        jsonObject.set("templates", JsonUtil.toJsonNode(templates));
        jsonObject.set("bpmDataTemplate", JsonUtil.toJsonNode((Object)((Object)bpmDataTemplate)));
        jsonObject.set("fields", JsonUtil.toJsonNode(fields));
        jsonObject.put("displaySettingFields", displaySettingFields);
        jsonObject.set("data", (JsonNode)this.tidyJson(bpmDataTemplate));
        jsonObject.put("colPrefix", colPrefix);
        jsonObject.put("formId", formId);
        jsonObject.set("formField", JsonUtil.toJsonNode(formField));
        jsonObject.set("subFormField", JsonUtil.toJsonNode(subEnt));
        jsonObject.set("permissionList", PermissionUtil.getPermissionList((String)"formPermissionCalcList"));
        return jsonObject;
    }

    private List<FormField> getFormFields(String boEntId) {
        ArrayList<FormField> fields = new ArrayList<FormField>();
        List attributes = this.boAttributeManager.getByEntId(boEntId);
        fields.addAll(this.convertAttr2Field(attributes));
        return fields;
    }

    private List<FormField> convertAttr2Field(List<BoAttribute> attributes) {
        ArrayList<FormField> fields = new ArrayList<FormField>();
        for (BoAttribute attribute : attributes) {
            FormField field = new FormField();
            field.setName(attribute.getName());
            field.setDesc(attribute.getDesc());
            field.setType(attribute.getDataType());
            field.setShowFlowField(true);
            field.setStatus(attribute.getStatus());
            fields.add(field);
        }
        return fields;
    }

    private ObjectNode tidyJson(FormDataTemplate template) throws IOException {
        template.setTemplateHtml("");
        ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)template));
        jsonObject.remove("pageBean");
        jsonObject.remove("createBy");
        jsonObject.remove("createtime");
        jsonObject.remove("updateBy");
        jsonObject.remove("updatetime");
        return jsonObject;
    }

    private String getDisplayField(List<FormField> fields, String displayField) throws IOException {
        Map<String, String> map = this.getDisplayFieldRight(displayField);
        Map<String, String> descMap = this.getDisplayFieldDesc(displayField);
        if (BeanUtils.isNotEmpty(fields)) {
            ArrayNode jsonAry = JsonUtil.getMapper().createArrayNode();
            for (FormField bpmFormField : fields) {
                ObjectNode json = JsonUtil.getMapper().createObjectNode();
                json.put("name", bpmFormField.getName());
                String desc = bpmFormField.getDesc();
                if (BeanUtils.isNotEmpty(map) && map.containsKey(bpmFormField.getName())) {
                    desc = descMap.get(bpmFormField.getName());
                }
                json.put("desc", desc);
                json.put("type", bpmFormField.getType());
                json.put("status", bpmFormField.getStatus());
                String right = "";
                if (BeanUtils.isNotEmpty(map)) {
                    right = map.get(bpmFormField.getName());
                }
                if (StringUtil.isEmpty((String)right)) {
                    right = this.getDefaultDisplayFieldRight();
                }
                json.put("right", right);
                if (bpmFormField.isShowFlowField()) {
                    json.put("showFlowField", true);
                }
                json.put("isFlowField", bpmFormField.getFlowField());
                jsonAry.add((JsonNode)json);
            }
            displayField = jsonAry.toString();
        }
        return displayField;
    }

    private Map<String, String> getDisplayFieldDesc(String displayField) throws IOException {
        if (StringUtil.isEmpty((String)displayField)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)displayField);
        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode)obj;
            String name = json.get("name").asText();
            String desc = json.get("desc").asText();
            map.put(name, desc);
        }
        return map;
    }

    private Map<String, String> getDisplayFieldRight(String displayField) throws IOException {
        if (StringUtil.isEmpty((String)displayField)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)displayField);
        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode)obj;
            String name = json.get("name").asText();
            ArrayNode right = (ArrayNode)json.get("right");
            map.put(name, right.toString());
        }
        return map;
    }

    private String getDefaultDisplayFieldRight() {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        json.put("type", "everyone");
        json.put("id", "");
        json.put("name", "");
        json.put("script", "");
        array.add((JsonNode)json);
        return array.toString();
    }

    @Override
    @Transactional
    public void save(FormDataTemplate bpmDataTemplate, boolean resetTemp) throws Exception {
        Integer bpmDataTemplateNum = this.getCountByAlias(bpmDataTemplate.getAlias());
        boolean flag1 = bpmDataTemplateNum > 0;
        boolean flag2 = StringUtil.isEmpty((String)bpmDataTemplate.getId());
        String templateHtml = this.generateTemplate(bpmDataTemplate);
        if (!flag1 && flag2) {
            bpmDataTemplate.setId(UniqueIdUtil.getSuid());
            bpmDataTemplate.setTemplateHtml(templateHtml);
            bpmDataTemplate.setCreateTime(LocalDateTime.now());
            this.create((Model)bpmDataTemplate);
        } else {
            FormDataTemplate temp = this.getByAlias(bpmDataTemplate.getAlias());
            if (temp != null && !bpmDataTemplate.getId().equals(temp.getId())) {
                throw new BaseException("\u62a5\u8868\u522b\u540d\uff1a" + bpmDataTemplate.getAlias() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u522b\u540d\uff01");
            }
            if (resetTemp) {
                bpmDataTemplate.setTemplateHtml(templateHtml);
            } else {
                FormDataTemplate old = ((FormDataTemplateDao)this.baseMapper).getByAlias(bpmDataTemplate.getAlias());
                bpmDataTemplate.setTemplateHtml(old.getTemplateHtml());
            }
            bpmDataTemplate.setUpdateTime(LocalDateTime.now());
            this.update((Model)bpmDataTemplate);
        }
        if (StringUtil.isNotEmpty((String)bpmDataTemplate.getRemindSettingList())) {
            this.formDataTemplateExtendManager.save(bpmDataTemplate.getRemindSettingList(), bpmDataTemplate.getId());
        }
    }

    private String generateTemplate(FormDataTemplate bpmDataTemplate) throws Exception {
        FormTemplate bpmFormTemplate = this.formTemplateManager.getByTemplateAlias(bpmDataTemplate.getTemplateAlias());
        List<FormField> fileds = this.formFieldManager.getByboDefId(bpmDataTemplate.getBoDefId());
        String conditionField = bpmDataTemplate.getConditionField();
        boolean hasCondition = this.hasCondition(conditionField);
        boolean hasManage = this.hasManage(bpmDataTemplate.getManageField());
        String isIndistinct = bpmDataTemplate.getIsIndistinct();
        String conditionAllName = "";
        String conditionAllDesc = "\u8bf7\u8f93\u5165\u5173\u952e\u5b57  " + bpmDataTemplate.getConditionAllDesc();
        BoDef boDef = this.boDefService.getByAlias(bpmDataTemplate.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        if (hasCondition) {
            ArrayNode conditions = (ArrayNode)JsonUtil.toJsonNode((String)conditionField);
            for (JsonNode jsonNode : conditions) {
                ObjectNode condition = (ObjectNode)jsonNode;
                String qt = condition.get("qt").asText();
                String type = "";
                if (condition.hasNonNull("ty") && "date".equals(condition.get("ty").asText())) {
                    String field = ((boEnt.isExternal() ? "" : BoEnt.FIELD_PREFIX) + condition.get("name").asText()).toLowerCase();
                    BoAttribute attribute = boEnt.getAttrByField(field);
                    if (BeanUtils.isNotEmpty((Object)attribute)) {
                        condition.put("format", attribute.getFormat());
                        type = "between".equals(qt) ? ("yyyy-MM-dd HH:mm:ss".equals(attribute.getFormat()) ? "datetimerange" : "daterange") : ("yyyy-MM-dd HH:mm:ss".equals(attribute.getFormat()) ? "datetime" : "date");
                    }
                } else if (condition.hasNonNull("ct") && "date".equals(condition.get("ct").asText())) {
                    condition.put("format", "yyyy-MM-dd HH:mm:ss");
                    type = "between".equals(qt) ? "datetimerange" : "datetime";
                }
                condition.put("ctrlType", type);
            }
            bpmDataTemplate.setConditionField(JsonUtil.toJson((Object)conditions));
        }
        String[] conditionArr = bpmDataTemplate.getConditionAllName().split(",");
        for (int i = 0; i < conditionArr.length; ++i) {
            conditionAllName = boEnt.isExternal() ? conditionAllName + conditionArr[i] + "," : conditionAllName + "F_" + conditionArr[i] + ",";
        }
        if (!"".equals(conditionAllName)) {
            conditionAllName = conditionAllName.substring(0, conditionAllName.length() - 1);
        }
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bpmDataTemplate", (Object)bpmDataTemplate);
        map.put("hasCondition", hasCondition);
        map.put("hasManage", hasManage);
        map.put("pkField", boEnt.getPkKey().toLowerCase());
        map.put("colPrefix", boEnt.isExternal() ? "" : "F_");
        ArrayList<FormField> list = new ArrayList<FormField>();
        for (int i = 0; i < fileds.size(); ++i) {
            if ("textFixed".equals(fileds.get(i).getCtrlType())) {
                fileds.get(i).setDesc(fileds.get(i).getDesc().replaceAll("\"", "'"));
            }
            list.add(fileds.get(i));
        }
        map.put("formatData", list);
        map.put("util", freeMakerUtil);
        map.put("isIndistinct", isIndistinct);
        map.put("conditionAllName", conditionAllName);
        map.put("conditionAllDesc", conditionAllDesc);
        HashMap<String, JsonNode> filteringFieldMap = new HashMap<String, JsonNode>();
        if (StringUtil.isNotEmpty((String)bpmDataTemplate.getFilteringField())) {
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)bpmDataTemplate.getFilteringField());
            for (JsonNode jsonNode : arrayNode) {
                filteringFieldMap.put(jsonNode.get("name").asText(), jsonNode.get("formatterData"));
            }
        }
        map.put("filteringFieldMap", filteringFieldMap);
        HashMap<String, String> sortFieldMap = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)bpmDataTemplate.getSortField())) {
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)bpmDataTemplate.getSortField());
            for (JsonNode jsonNode : arrayNode) {
                sortFieldMap.put(jsonNode.get("name").asText(), jsonNode.get("sort").asText());
            }
        }
        map.put("sortFieldMap", sortFieldMap);
        if (BeanUtils.isEmpty(sortFieldMap)) {
            map.put("defaultAllSort", true);
        }
        String templateHtml = this.freemarkEngine.parseByStringTemplate(bpmFormTemplate.getHtml(), map);
        return templateHtml;
    }

    private boolean hasManage(String manageField) throws IOException {
        if (StringUtil.isEmpty((String)manageField)) {
            return false;
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)manageField);
        return jsonAry.size() > 0;
    }

    private boolean hasCondition(String conditionField) throws IOException {
        if (StringUtil.isEmpty((String)conditionField)) {
            return false;
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)conditionField);
        return jsonAry.size() > 0;
    }

    private List<Map<String, Object>> dataFormatProcessing(List<Map<String, Object>> list, List<BoAttribute> columnList) throws Exception, Exception {
        ArrayList<Map<String, Object>> newlist = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : list) {
            for (BoAttribute column : columnList) {
                Object object = map.get(column.getFieldName().toLowerCase());
                if (BeanUtils.isNotEmpty((Object)object) && object instanceof Clob) {
                    Clob clob = (Clob)object;
                    String string = SQLUtil.ClobToString((Clob)clob);
                    map.put(column.getFieldName(), string);
                    map.remove(column.getFieldName().toLowerCase());
                    continue;
                }
                if ("date".equals(column.getDataType())) {
                    if (!BeanUtils.isNotEmpty((Object)map.get(column.getFieldName().toLowerCase()))) continue;
                    map.put(column.getFieldName(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(column.getFieldName().toLowerCase())));
                    map.remove(column.getFieldName().toLowerCase());
                    continue;
                }
                map.put(column.getFieldName(), map.get(column.getFieldName().toLowerCase()));
                map.remove(column.getFieldName().toLowerCase());
            }
            newlist.add(map);
        }
        return newlist;
    }

    public Integer getCountByAlias(FormDataTemplate bpmDataTemplate) {
        return ((FormDataTemplateDao)this.baseMapper).getCountByAlias(bpmDataTemplate.getAlias());
    }

    public Integer getCountByAlias(String alias) {
        return ((FormDataTemplateDao)this.baseMapper).getCountByAlias(alias);
    }

    @Override
    public String getDisplay(String alias, Map<String, Object> params, Map<String, Object> queryParams) throws Exception {
        Map curProfiles = this.permssionCalc.getCurrentProfiles();
        HashMap<String, Object> model = new HashMap<String, Object>();
        FormDataTemplate bpmDataTemplate = ((FormDataTemplateDao)this.baseMapper).getByAlias(alias);
        params.put("boAlias", bpmDataTemplate.getBoDefAlias());
        params.put("formKey", bpmDataTemplate.getFormKey());
        params.put("defId", BeanUtils.isEmpty((Object)bpmDataTemplate.getDefId()) ? "" : bpmDataTemplate.getDefId());
        Map<String, Boolean> managePermission = this.getManagePermission(bpmDataTemplate.getManageField(), curProfiles);
        if (StringUtil.isEmpty((String)bpmDataTemplate.getDefId())) {
            managePermission.put("startFlow", false);
        }
        List<Map<String, String>> filters = this.getFilterPermission(bpmDataTemplate.getFilterField(), curProfiles);
        model.put("ctx", params.get("__ctx"));
        model.put("bpmDataTemplate", (Object)bpmDataTemplate);
        model.put("permission", this.getPermission(bpmDataTemplate.getDisplayField(), curProfiles));
        model.put("managePermission", managePermission);
        model.put("hasSub", StringUtil.isNotEmpty((String)this.getSubEntIds(bpmDataTemplate.getFormKey())));
        BoDef boDef = this.boDefService.getByAlias(bpmDataTemplate.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        model.put("pkField", boEnt.getPkKey().toLowerCase());
        model.put("colPrefix", boEnt.isExternal() ? "" : "F_");
        model.put("filters", filters);
        JsonUtil jsonUtil = new JsonUtil();
        model.put("JsonUtil", jsonUtil);
        String templateHtml = bpmDataTemplate.getTemplateHtml();
        String html = this.freemarkEngine.parseByStringTemplate(templateHtml, model);
        return html;
    }

    private String getSubEntIds(String formKey) {
        try {
            List<BoEnt> list = this.formMetaManager.getChildrenByFormKey(formKey);
            if (BeanUtils.isNotEmpty(list)) {
                StringBuilder sql = new StringBuilder();
                boolean isInit = false;
                for (BoEnt boEnt : list) {
                    if (!isInit) {
                        isInit = true;
                    } else {
                        sql.append(",");
                    }
                    sql.append(boEnt.getId());
                }
                return sql.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    private List<Map<String, String>> getFilterPermission(String filterField, Map<String, Set<String>> curProfiles) throws IOException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (StringUtil.isEmpty((String)filterField)) {
            return list;
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        for (Object obj : jsonAry) {
            JsonNode permission;
            ObjectNode json = (ObjectNode)obj;
            ArrayNode rights = json.get("right").isArray() ? (ArrayNode)json.get("right") : (ArrayNode)JsonUtil.toJsonNode((String)json.get("right").asText());
            boolean hasRight = false;
            Iterator iterator = rights.iterator();
            while (iterator.hasNext() && !(hasRight = this.permssionCalc.hasRight((permission = (JsonNode)iterator.next()).toString(), curProfiles))) {
            }
            if (!hasRight) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", JsonUtil.getString((JsonNode)json, (String)"name", (String)""));
            map.put("filterKey", JsonUtil.getString((JsonNode)json, (String)"key", (String)""));
            list.add(map);
        }
        return list;
    }

    private Map<String, Boolean> getManagePermission(String manageField, Map<String, Set<String>> currentMap) throws IOException {
        if (StringUtil.isEmpty((String)manageField)) {
            return null;
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)manageField);
        return this.getPermissionMap(jsonAry, currentMap);
    }

    private Map<String, Boolean> getPermissionMap(ArrayNode jsonAry, Map<String, Set<String>> currentMap) throws IOException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (BeanUtils.isEmpty((Object)jsonAry) || jsonAry.size() < 1) {
            return map;
        }
        for (Object obj : jsonAry) {
            ObjectNode json = (ObjectNode)JsonUtil.toJsonNode(obj);
            String name = json.get("name").asText();
            String rightStr = json.get("right").textValue();
            ArrayNode rights = StringUtil.isEmpty((String)rightStr) ? (ArrayNode)json.get("right") : (ArrayNode)JsonUtil.toJsonNode((String)rightStr);
            boolean hasRight = false;
            for (JsonNode permission : rights) {
                hasRight = this.permssionCalc.hasRight(permission.toString(), currentMap);
                if (!hasRight) continue;
                map.put(name, hasRight);
                break;
            }
            map.put(name, hasRight);
        }
        return map;
    }

    private Map<String, Boolean> getPermission(String displayField, Map<String, Set<String>> rightMap) throws IOException {
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)displayField);
        return this.getPermissionMap(jsonAry, rightMap);
    }

    @Override
    public Map<String, Object> getFormByFormKey(String formKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Form formModel = this.formManager.getMainByFormKey(formKey);
        if (formModel == null || StringUtil.isEmpty((String)formModel.getFormHtml())) {
            map.put("result", "formEmpty");
            return map;
        }
        map.put("form", (Object)formModel);
        map.put("result", true);
        return map;
    }

    @Override
    @Transactional
    public void boSave(ObjectNode jsonObject, String boAlias, String delDraftId) throws Exception {
        String pk;
        List resultList;
        String templateKey;
        JsonNode jsonData = JsonUtil.toJsonNode((String)jsonObject.get(boAlias).toString());
        jsonData = this.transJSON(jsonData);
        BoData boData = BoUtil.transJSON((JsonNode)jsonData);
        BoDataHandler handler = this.boInstanceFactory.getBySaveType("database");
        BoDef boDef = this.boDefService.getByAlias(boAlias);
        BoEnt boEnt = boDef.getBoEnt();
        boData.setBoEnt(boEnt);
        boData.setBoDef(boDef);
        if (BeanUtils.isNotEmpty((Object)jsonData.get("subMap"))) {
            this.handlerSubMap(boData, (ObjectNode)jsonData);
        }
        HashMap<String, BoData> param = new HashMap<String, BoData>();
        param.put("boData", boData);
        FormDataTemplate template = null;
        if (jsonObject.has("templateKey") && BeanUtils.isNotEmpty((Object)(template = this.getByAlias(templateKey = jsonObject.get("templateKey").asText())).getBeforeScript())) {
            this.groovyScriptEngine.execute(template.getBeforeScript(), param);
        }
        if (BeanUtils.isNotEmpty((Object)(resultList = handler.save("", "", boData)))) {
            this.handleBoResult(resultList, jsonObject);
        }
        String string = pk = StringUtil.isEmpty((String)boEnt.getPk()) ? "id_" : boEnt.getPk();
        if (jsonObject.has("formKey")) {
            String formKey = jsonObject.get("formKey").asText();
            String boDataId = "";
            if (jsonData.has(pk)) {
                boDataId = jsonData.get(pk).asText();
            } else {
                BoResult a = resultList.stream().filter(b -> "add".equals(b.getAction())).findAny().orElse(null);
                if (a != null) {
                    boDataId = a.getPk();
                }
            }
            List<FormDataTemplateExtend> list = this.formDataTemplateExtendManager.getDataTemplateExtendByFormKey(formKey);
            this.formRemindDataManager.deleteFormRemindDataByBoDataId((QueryWrapper)new QueryWrapper().eq((Object)"OPEM_ID", (Object)boDataId));
            ArrayList<FormRemindData> insertList = new ArrayList<FormRemindData>();
            for (int i = 0; i < list.size(); ++i) {
                JsonNode node;
                String script;
                boolean res;
                FormDataTemplateExtend formDataTemplateExtend = list.get(i);
                String scriptJson = formDataTemplateExtend.getRule();
                if (StringUtil.isEmpty((String)scriptJson) || !(res = this.groovyScriptEngine.executeBoolean(Base64.getFromBase64((String)(script = (node = JsonUtil.toJsonNode((String)scriptJson)).get("scriptStr").asText())), boData.getData()))) continue;
                String typeObj = formDataTemplateExtend.getTypeObj();
                String objId = formDataTemplateExtend.getObjId();
                String content = formDataTemplateExtend.getContent();
                String count = formDataTemplateExtend.getCount();
                String refId = formDataTemplateExtend.getId();
                if (typeObj.equals("script")) {
                    objId = boData.getData().get(objId) + "";
                    FormRemindData formRemindData = new FormRemindData();
                    formRemindData.setContent(content);
                    formRemindData.setCount(count);
                    formRemindData.setObjId(objId);
                    formRemindData.setTypeObj("user");
                    formRemindData.setOpemId(boDataId);
                    formRemindData.setSubject(formDataTemplateExtend.getSubject());
                    formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                    formRemindData.setRefId(refId);
                    insertList.add(formRemindData);
                    continue;
                }
                String[] objIds = objId.split(",");
                for (int j = 0; j < objIds.length; ++j) {
                    FormRemindData formRemindData = new FormRemindData();
                    formRemindData.setContent(content);
                    formRemindData.setCount(count);
                    formRemindData.setObjId(objIds[j]);
                    formRemindData.setSubject(formDataTemplateExtend.getSubject());
                    formRemindData.setTypeObj(typeObj);
                    formRemindData.setOpemId(boDataId);
                    formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                    formRemindData.setRefId(refId);
                    insertList.add(formRemindData);
                }
            }
            this.formRemindDataManager.saveBatch(insertList);
        }
        if (BeanUtils.isNotEmpty((Object)delDraftId)) {
            this.dataTemplateDraftManager.remove((Serializable)((Object)delDraftId));
        }
        if (BeanUtils.isNotEmpty((Object)((Object)template)) && BeanUtils.isNotEmpty((Object)template.getAfterScript())) {
            this.groovyScriptEngine.execute(template.getAfterScript(), param);
        }
    }

    public JsonNode transJSON(JsonNode jsonNode) {
        ObjectNode data = JsonUtil.getMapper().createObjectNode();
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            JsonNode jNode = (JsonNode)next.getValue();
            if (jNode.isArray()) {
                boolean isCheck = false;
                if (BeanUtils.isNotEmpty((Object)jNode)) {
                    for (JsonNode fxk : jNode) {
                        if (fxk.isObject()) continue;
                        isCheck = true;
                        break;
                    }
                }
                if (!isCheck && key.toString().indexOf("sub_") > -1) {
                    String tmp = key.toString().replaceFirst("sub_", "");
                    ObjectNode subNode = (ObjectNode)data.get("subMap");
                    if (BeanUtils.isEmpty((Object)subNode)) {
                        subNode = JsonUtil.getMapper().createObjectNode();
                    }
                    subNode.set(tmp, jNode);
                    data.set("subMap", (JsonNode)subNode);
                    continue;
                }
                data.set(key, jNode);
                continue;
            }
            data.set(key, jNode);
        }
        return data;
    }

    private void handlerSubMap(BoData curData, ObjectNode boData) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode subMapNode = (ObjectNode)boData.get("subMap");
        Iterator fields = subMapNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            JsonNode jNode = (JsonNode)next.getValue();
            if (!jNode.isArray()) continue;
            ArrayList<BoData> datas = new ArrayList<BoData>();
            for (JsonNode jsonNode : jNode) {
                Iterator subFields = jsonNode.fields();
                BoData data = new BoData();
                HashMap sunBoDataMap = new HashMap();
                while (subFields.hasNext()) {
                    Map.Entry subNext = (Map.Entry)subFields.next();
                    String subkey = (String)subNext.getKey();
                    data.set(subkey, subNext.getValue());
                    if (!subkey.startsWith("sub_") || !BeanUtils.isNotEmpty(subNext.getValue())) continue;
                    JsonNode sunNode = (JsonNode)subNext.getValue();
                    ArrayList<BoData> sunBoDatas = new ArrayList<BoData>();
                    for (JsonNode itemNode : sunNode) {
                        BoData sunData = new BoData();
                        Iterator sunFields = itemNode.fields();
                        while (sunFields.hasNext()) {
                            Map.Entry sunNext = (Map.Entry)sunFields.next();
                            String sunkey = (String)sunNext.getKey();
                            sunData.set(sunkey, sunNext.getValue());
                        }
                        BoData bb = (BoData)JsonUtil.toBean((String)JsonUtil.toJson((Object)sunData), BoData.class);
                        sunBoDatas.add(bb);
                    }
                    sunBoDataMap.put(subkey, sunBoDatas);
                }
                BoData aa = (BoData)JsonUtil.toBean((String)JsonUtil.toJson((Object)data), BoData.class);
                if (!sunBoDataMap.isEmpty()) {
                    for (String sunKey : sunBoDataMap.keySet()) {
                        aa.setSubList(sunKey, (List)sunBoDataMap.get(sunKey));
                    }
                }
                datas.add(aa);
            }
            curData.setSubList(key, datas);
        }
    }

    @Override
    @Transactional
    public void boSaveDraft(FormDataTemplateDraft dataTemplateDraft) {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)dataTemplateDraft.getId())) {
            FormDataTemplate dataTemplate = this.getByAlias(dataTemplateDraft.getTempAlias());
            String currentTime = DateUtil.getCurrentTime();
            dataTemplateDraft.setTitle(dataTemplate.getName() + "_" + currentTime);
            dataTemplateDraft.setId(UniqueIdUtil.getSuid());
            dataTemplateDraft.setCreateBy(currentUser.getUserId());
            dataTemplateDraft.setCreateTime(LocalDateTime.now());
            this.dataTemplateDraftManager.create((Model)dataTemplateDraft);
        } else {
            this.dataTemplateDraftManager.update((Model)dataTemplateDraft);
        }
    }

    private void handleBoResult(List<BoResult> resultList, ObjectNode data) throws Exception {
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        for (BoResult result : resultList) {
            list.add((ObjectNode)JsonUtil.toJsonNode((Object)result));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayNode boResult = JsonUtil.listToArrayNode(list);
        params.put("boResult", boResult);
        params.put("data", data);
        this.workflowFeignService.handleBoDateModify(params);
    }

    @Override
    @Transactional
    public void boDel(String[] ids, String boAlias) {
        BoDataHandler handler = this.boInstanceFactory.getBySaveType("database");
        handler.removeBoData(boAlias, ids);
    }

    @Override
    public List<FormDataTemplate> getTemplateByFormKey(String formKey) {
        return ((FormDataTemplateDao)this.baseMapper).getByFormKey(formKey);
    }

    @Override
    public FormDataTemplate getExportDisplay(String alias) throws IOException {
        FormDataTemplate bpmDataTemplate = ((FormDataTemplateDao)this.baseMapper).getByAlias(alias);
        if (BeanUtils.isNotEmpty((Object)((Object)bpmDataTemplate))) {
            ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)bpmDataTemplate.getDisplayField());
            Map curProfiles = this.permssionCalc.getCurrentProfiles();
            if (BeanUtils.isNotEmpty((Object)jsonAry) && jsonAry.size() > 0) {
                ArrayNode newjsonAry = JsonUtil.getMapper().createArrayNode();
                for (Object obj : jsonAry) {
                    ObjectNode json = (ObjectNode)obj;
                    ArrayNode rights = (ArrayNode)JsonUtil.toJsonNode((String)json.get("right").asText());
                    boolean hasRight = false;
                    Iterator iterator = rights.iterator();
                    if (iterator.hasNext()) {
                        JsonNode permission = (JsonNode)iterator.next();
                        hasRight = this.permssionCalc.hasRight(permission.toString(), curProfiles);
                    }
                    json.put("permission", hasRight);
                    newjsonAry.add((JsonNode)json);
                }
                bpmDataTemplate.setDisplayField(newjsonAry.toString());
            }
        }
        return bpmDataTemplate;
    }

    @Override
    public String getFilterSql(String filterField, String dsName, Map<String, Object> param) throws IOException {
        StringBuffer sb = new StringBuffer();
        String sql = "";
        Map curProfiles = this.permssionCalc.getCurrentProfiles();
        List<Map<String, String>> filters = this.getFilterPermission(filterField, curProfiles);
        ArrayNode jsonArray = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        ObjectNode json = JsonUtil.arrayToObject((ArrayNode)jsonArray, (String)"key");
        if (BeanUtils.isEmpty(filters)) {
            return sb.toString();
        }
        for (Map<String, String> map : filters) {
            ObjectNode jsonObject = (ObjectNode)json.get(map.get("filterKey"));
            int type = JsonUtil.getInt((ObjectNode)jsonObject, (String)"type", (int)0);
            switch (type) {
                case 1: {
                    String dbType = this.databaseContext.getDbTypeByAlias(dsName);
                    sql = FilterJsonStructUtil.getSql((String)JsonUtil.getString((JsonNode)jsonObject, (String)"condition"), (String)dbType);
                    break;
                }
                case 3: {
                    String filterSql = jsonObject.get("condition").asText();
                    filterSql = filterSql.replaceAll("\\n", "");
                    sql = this.executeScript(filterSql, param);
                    break;
                }
                case 4: {
                    sql = this.getDataPermissionSql(jsonObject.get("condition").asText(), "");
                }
            }
            if (!StringUtil.isNotEmpty((String)sql)) continue;
            if (4 != type && !sql.trim().toUpperCase().startsWith("AND")) {
                sb.append(" AND ");
            }
            sb.append(sql);
        }
        return sb.toString();
    }

    @Override
    public String getFilterSql(String filterField, String dsName, Map<String, Object> param, BoEnt boEnt) throws IOException {
        StringBuffer sb = new StringBuffer();
        String sql = "";
        Map curProfiles = this.permssionCalc.getCurrentProfiles();
        List<Map<String, String>> filters = this.getFilterPermission(filterField, curProfiles);
        ArrayNode jsonArray = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        ObjectNode json = JsonUtil.arrayToObject((ArrayNode)jsonArray, (String)"key");
        if (BeanUtils.isEmpty(filters)) {
            return sb.toString();
        }
        for (Map<String, String> map : filters) {
            ObjectNode jsonObject = (ObjectNode)json.get(map.get("filterKey"));
            int type = JsonUtil.getInt((ObjectNode)jsonObject, (String)"type", (int)0);
            switch (type) {
                case 1: {
                    String dbType = this.databaseContext.getDbTypeByAlias(dsName);
                    if ("oracle".equals(dbType)) {
                        String condition = JsonUtil.getString((JsonNode)jsonObject, (String)"condition");
                        ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)condition);
                        for (int i = 0; i < array.size(); ++i) {
                            String flowvarKey = JsonUtil.getString((JsonNode)array.get(i), (String)"flowvarKey");
                            for (BoAttribute attribute : boEnt.getBoAttrList()) {
                                if (!attribute.getName().equals(flowvarKey.replace(BoEnt.FIELD_PREFIX, "")) || !"clob".equals(attribute.getDataType())) continue;
                                ObjectNode objectNode = (ObjectNode)array.get(i);
                                objectNode.put("flowvarKey", "TO_CHAR(" + flowvarKey + ")");
                                array.set(i, (JsonNode)objectNode);
                            }
                        }
                        sql = FilterJsonStructUtil.getSql((String)JsonUtil.toJson((Object)array), (String)dbType);
                        break;
                    }
                    sql = FilterJsonStructUtil.getSql((String)JsonUtil.getString((JsonNode)jsonObject, (String)"condition"), (String)dbType);
                    break;
                }
                case 3: {
                    String filterSql = jsonObject.get("condition").asText();
                    filterSql = filterSql.replaceAll("\\n", "  ");
                    sql = this.executeScript(filterSql, param);
                    break;
                }
                case 4: {
                    sql = this.getDataPermissionSql(jsonObject.get("condition").asText(), "");
                }
            }
            if (!StringUtil.isNotEmpty((String)sql)) continue;
            if (sb.length() == 0) {
                sb.append(" AND (( ");
            } else {
                sb.append(" OR (");
            }
            sb.append(sql);
            sb.append(" ) ");
        }
        if (sb.length() > 0) {
            sb.append(" ) ");
        }
        return sb.toString();
    }

    @Override
    public String getDataPermissionSql(String dataPermission, String fieldPre) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (StringUtil.isNotEmpty((String)dataPermission)) {
            ArrayNode permissionArrayJson = (ArrayNode)JsonUtil.toJsonNode((String)dataPermission);
            HashSet<String> orgIds = new HashSet<String>();
            IUser currentUser = ContextUtil.getCurrentUser();
            for (JsonNode node : permissionArrayJson) {
                if (!BeanUtils.isNotEmpty((Object)node.get("field"))) continue;
                if (LOGIN_USER.equals(node.get("type").asText())) {
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                    }
                    sb.append(fieldPre + node.get("field").asText() + "='" + currentUser.getUserId() + "'");
                    continue;
                }
                if (LOGIN_USER_ORGS.equals(node.get("type").asText())) {
                    String currentUserOrgIds = currentUser.getAttrbuite("CURRENT_USER_ORGIDS");
                    if (!StringUtil.isNotEmpty((String)currentUserOrgIds)) continue;
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                    }
                    String[] oids = currentUserOrgIds.split(",");
                    HashSet<String> oidSet = new HashSet<String>(Arrays.asList(oids));
                    String inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                    sb.append(fieldPre + node.get("field").asText() + " in (" + inSql + ")");
                    orgIds.addAll(oidSet);
                    continue;
                }
                if (LOGIN_USER_SUB_ORGS.equals(node.get("type").asText())) {
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                    }
                    String currentUserSubOrgIds = StringUtil.isNotEmpty((String)AuthenticationUtil.getCurrentUserSubOrgIds()) ? AuthenticationUtil.getCurrentUserSubOrgIds() : "";
                    String currentUserOrgIds = StringUtil.isNotEmpty((String)AuthenticationUtil.getCurrentUserOrgIds()) ? AuthenticationUtil.getCurrentUserOrgIds() : "";
                    currentUserSubOrgIds = currentUserSubOrgIds + "," + (String)currentUserOrgIds;
                    String[] oids = new String[]{};
                    if (StringUtil.isNotEmpty((String)currentUserSubOrgIds)) {
                        oids = currentUserSubOrgIds.split(",");
                    }
                    if (oids.length == 0) {
                        oids = new String[]{"-1"};
                    }
                    HashSet<String> oidSet = new HashSet<String>(Arrays.asList(oids));
                    String inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                    sb.append(fieldPre + node.get("field").asText() + " in (" + inSql + ")");
                    orgIds.addAll(oidSet);
                    continue;
                }
                if (!CUSTOM_ORGS.equals(node.get("type").asText())) continue;
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                ArrayNode tmpArray = (ArrayNode)node.get("orgs");
                for (JsonNode tmpJsonNode : tmpArray) {
                    orgIds.add(tmpJsonNode.get("id").asText());
                }
                String inSql = StringUtil.convertListToSingleQuotesString(orgIds);
                sb.append(fieldPre + node.get("field").asText() + " in (" + inSql + ")");
            }
        }
        return sb.toString();
    }

    private String executeScript(String script, Map<String, Object> param) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("param", param);
        vars.putAll(param);
        String str = this.groovyScriptEngine.executeString(this.replaceVar(script), vars);
        return str;
    }

    private String replaceVar(String str) {
        List comVarList = (List)AppUtil.getBean((String)"queryViewComVarList");
        for (IContextVar c : comVarList) {
            str = str.replace("[" + c.getAlias() + "]", c.getValue());
        }
        return "return \"" + str + "\" ;";
    }

    @Override
    public Set<String> getAllFormKeys() {
        HashSet<String> formSets = new HashSet<String>();
        List<String> formKeys = ((FormDataTemplateDao)this.baseMapper).getAllFormKeys();
        if (BeanUtils.isNotEmpty(formKeys)) {
            formSets = new HashSet<String>(formKeys);
        }
        return formSets;
    }

    @Override
    @Transactional
    public void importData(List<MultipartFile> files, String refId, String alias) throws Exception {
        for (MultipartFile file : files) {
            List rows = ExcelUtil.ImportDate((MultipartFile)file);
            BoEnt boEnt = this.boEntManager.getByName(alias);
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)(boEnt.getDsName() == null ? "LOCAL" : boEnt.getDsName()));
            String dbType = this.databaseContext.getDbType();
            boolean isPgSql = "postgresql".equals(dbType);
            boolean isOracle = "oracle".equals(dbType) || "dm".equals(dbType);
            for (Map row : rows) {
                int i = 0;
                StringBuilder excuteSql = this.preSql(boEnt);
                excuteSql.append(UniqueIdUtil.getSuid() + ",");
                excuteSql.append(refId);
                for (Map.Entry map : row.entrySet()) {
                    String dataType = ((BoAttribute)boEnt.getColumnList().get(i++)).getDataType();
                    if ("varchar".equals(dataType) || isOracle && "clob".equals(dataType)) {
                        excuteSql.append(",'" + (String)map.getValue() + "'");
                        continue;
                    }
                    if (isPgSql && "date".equals(dataType)) {
                        if (StringUtil.isNotEmpty((String)((String)map.getValue()))) {
                            excuteSql.append(",'" + (String)map.getValue() + "'");
                            continue;
                        }
                        excuteSql.append(",null");
                        continue;
                    }
                    if (isOracle && "date".equals(dataType)) {
                        excuteSql.append(",TO_DATE('" + (String)map.getValue() + "','yyyy-MM-dd HH24:mi:ss')");
                        continue;
                    }
                    if ("number".equals(dataType) || "int".equals(dataType)) {
                        excuteSql.append("," + (String)map.getValue());
                        continue;
                    }
                    if (StringUtil.isNotEmpty((String)((String)map.getValue()))) {
                        excuteSql.append(",'" + (String)map.getValue() + "'");
                        continue;
                    }
                    excuteSql.append(",null");
                }
                excuteSql.append(",0)");
                template.execute(excuteSql.toString());
            }
        }
    }

    @Override
    @Transactional
    public void importMain(List<MultipartFile> files, String alias) throws Exception {
        FormDataTemplate template = this.getByAlias(alias);
        BoDef boDef = this.boDefService.getByDefId(template.getBoDefId());
        BoEnt boEnt = boDef.getBoEnt();
        Iterator<MultipartFile> it = files.iterator();
        ArrayNode displays = (ArrayNode)JsonUtil.toJsonNode((String)template.getDisplayField());
        HashMap<String, String> nameFieldMap = new HashMap<String, String>();
        for (JsonNode field : displays) {
            nameFieldMap.put(field.get("desc").asText(), field.get("name").asText());
        }
        while (it.hasNext()) {
            MultipartFile file = it.next();
            List rows = ExcelUtil.ImportDate((MultipartFile)file);
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)(boEnt.getDsName() == null ? "LOCAL" : boEnt.getDsName()));
            for (Map row : rows) {
                StringBuffer sql = new StringBuffer("insert into ");
                ArrayList<String> fields = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                for (Map.Entry map : row.entrySet()) {
                    if ("\u4e3b\u952e".equals(map.getKey())) {
                        fields.add(boEnt.getPkKey());
                        if (BeanUtils.isNotEmpty(row.get("\u4e3b\u952e"))) {
                            values.add("'" + (String)row.get("\u4e3b\u952e") + "'");
                            continue;
                        }
                        values.add(UniqueIdUtil.getSuid());
                        continue;
                    }
                    if (!BeanUtils.isNotEmpty(map.getValue())) continue;
                    String key = (String)map.getKey();
                    String field = this.getFieldName(key, boEnt.getColumnList(), (String)nameFieldMap.get(key));
                    fields.add(field);
                    String dataType = this.getDataType(key, boEnt.getColumnList(), (String)nameFieldMap.get(key));
                    if ("number".equals(dataType)) {
                        values.add((String)map.getValue());
                        continue;
                    }
                    values.add("'" + (String)map.getValue() + "'");
                }
                if (!fields.contains(boEnt.getPkKey())) {
                    fields.add(boEnt.getPkKey());
                    values.add(UniqueIdUtil.getSuid());
                }
                fields.add(BoEnt.FK_NAME);
                values.add("0");
                fields.add("F_form_data_rev_");
                values.add("0");
                sql.append(boEnt.getTableName());
                sql.append("(" + String.join((CharSequence)",", fields) + ")");
                sql.append(" values ");
                sql.append("(" + String.join((CharSequence)",", values) + ")");
                jdbcTemplate.execute(sql.toString());
            }
        }
    }

    private String getFieldName(String key, List<BoAttribute> columnList, String fieldName) {
        for (BoAttribute boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getFieldName();
        }
        return "";
    }

    private String getDataType(String key, List<BoAttribute> columnList, String fieldName) {
        for (BoAttribute boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getDataType();
        }
        return "";
    }

    @Override
    public Map<String, Object> getFormData(String formKey, String boAlias, String id, String action, String recordId, String dataKey) throws Exception {
        int type = this.convert2Type(action);
        Map<String, Object> map = this.getFormByFormKey(formKey);
        if ("formEmpty".equals(map.get("result"))) {
            return map;
        }
        JsonNode permission = this.bpmFormRightManager.getPermission(formKey, dataKey, type);
        map.put("permission", permission);
        List<Object> boDatas = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            BoData boData;
            String data;
            ObjectNode record;
            if (StringUtil.isNotEmpty((String)recordId) && BeanUtils.isNotEmpty((Object)(record = this.workflowFeignService.getModifyById(recordId))) && BeanUtils.isNotEmpty((Object)record.get("data")) && StringUtil.isNotEmpty((String)(data = record.get("data").asText()))) {
                JsonNode formData = JsonUtil.toJsonNode((String)data);
                map.put("permission", permission);
                map.put("data", formData);
                return map;
            }
            if (permission.hasNonNull("subRowAuth")) {
                FormContextThreadUtil.putCommonVars((String)"subRowAuthJosn", (Object)JsonUtil.toJson((Object)permission.get("subRowAuth")));
            }
            if (StringUtil.isEmpty((String)(boData = this.boDataHandler.getById((Object)id, boAlias)).getBoDefAlias())) {
                boData.setBoDefAlias(boData.getBoDef().getAlias());
            }
            boDatas = Arrays.asList(boData);
        } else {
            for (String code : Arrays.asList(boAlias)) {
                BoData boData = this.formService.getBodataByDefCode("database", code);
                if (StringUtil.isEmpty((String)boData.getBoDefAlias())) {
                    boData.setBoDefAlias(boData.getBoDef().getAlias());
                }
                if (!BeanUtils.isNotEmpty((Object)boData)) continue;
                boDatas.add(boData);
            }
        }
        HashSet set = new HashSet();
        boDatas.forEach(item -> {
            for (String subKey : item.getSubMap().keySet()) {
                set.add(subKey);
                Map sunInitData = (Map)item.getInitDataMap().get(subKey);
                Object initData = sunInitData.get("initData");
                if (!BeanUtils.isNotEmpty(initData) || !(initData instanceof HashMap)) continue;
                for (String o : ((HashMap)initData).keySet()) {
                    set.add(o);
                }
            }
        });
        ObjectNode object = BoUtil.hanlerData(boDatas);
        map.put("data", object);
        ObjectNode table = (ObjectNode)permission.get("table");
        if (BeanUtils.isNotEmpty((Object)table)) {
            Iterator keyIterator = table.fieldNames();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                if (set.contains(key)) continue;
                ((ObjectNode)table.get(key)).put("hidden", true);
            }
        }
        map.put("permission", permission);
        return map;
    }

    public Integer convert2Type(String action) {
        if ("add".equals(action)) {
            return 3;
        }
        if ("edit".equals(action)) {
            return 4;
        }
        if ("get".equals(action)) {
            return 5;
        }
        return 0;
    }

    @Override
    public Map<String, Object> getTempDraftData(String draftId) throws IOException {
        FormDataTemplateDraft formDataTemplateDraft = (FormDataTemplateDraft)this.dataTemplateDraftManager.get((Serializable)((Object)draftId));
        FormDataTemplate formDataTemplate = this.getByAlias(formDataTemplateDraft.getTempAlias());
        Map<String, Object> map = this.getFormByFormKey(formDataTemplate.getFormKey());
        if ("formEmpty".equals(map.get("result"))) {
            return map;
        }
        map.put("permission", this.bpmFormRightManager.getPermission(formDataTemplate.getFormKey(), "", "", "", 1));
        JsonNode object = JsonUtil.toJsonNode((String)formDataTemplateDraft.getDataJson());
        map.put("data", object);
        map.put("draft", (Object)formDataTemplateDraft);
        return map;
    }

    @Override
    public void exportData(HttpServletResponse response, String formKey, String getType, String filterKey, String expField, QueryFilter queryFilter) throws Exception {
        FormDataTemplate template = this.getByAlias(formKey);
        getType = StringUtil.isEmpty((String)getType) ? "getType" : getType;
        PageBean page = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE);
        if ("page".equals(getType) && BeanUtils.isNotEmpty((Object)queryFilter.getPageBean())) {
            page.setPage(queryFilter.getPageBean().getPage().intValue());
            page.setPageSize(queryFilter.getPageBean().getPageSize().intValue());
        }
        expField = Base64.getFromBase64((String)expField);
        queryFilter.setPageBean(page);
        filterKey = StringUtil.isNotEmpty((String)filterKey) ? filterKey : "";
        DataTemplateQueryVo vo = new DataTemplateQueryVo();
        vo.setTemplateId(template.getId());
        vo.setQueryFilter(queryFilter);
        PageList pageList = this.getList(template, vo);
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        ArrayNode formField = (ArrayNode)JsonUtil.toJsonNode((String)template.getFormField());
        ObjectNode showJO = JsonUtil.getMapper().createObjectNode();
        ArrayNode displayField = (ArrayNode)JsonUtil.toJsonNode((String)template.getDisplayField());
        displayField.forEach(obj -> showJO.put(obj.get("name").asText(), obj.get("desc").asText()));
        formField.forEach(obj -> showJO.put(obj.get("name").asText(), obj.get("desc").asText()));
        for (String str : expField.split(",")) {
            exportMaps.put(str, showJO.get(str).asText());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)template.getName(), (int)24, exportMaps, (List)pageList.getRows());
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)template.getName(), (HttpServletResponse)response);
    }

    @Override
    public void downloadMainTempFile(HttpServletResponse response, String alias) throws Exception {
        FormDataTemplate template = this.getByAlias(alias);
        BoDef boDef = this.boDefService.getByDefId(template.getBoDefId());
        BoEnt boEnt = boDef.getBoEnt();
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        List boAttrList = boEnt.getColumnList();
        for (BoAttribute boAttr : boAttrList) {
            exportMaps.put(boAttr.getName(), boAttr.getDesc());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)template.getName(), (int)24, exportMaps, new ArrayList(), (int)1);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)(template.getName() + "_\u5bfc\u5165\u6a21\u677f"), (HttpServletResponse)response);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PageList getList(FormDataTemplate template, DataTemplateQueryVo dataTemplateQueryVo) throws Exception {
        returnData = new PageList();
        dbType = SQLUtil.getDbType();
        queryFilter = dataTemplateQueryVo.getQueryFilter();
        service = (WorkflowFeignService)AppUtil.getBean(WorkflowFeignService.class);
        flowBpmList = null;
        flowFields = new LinkedHashMap<String, Map>();
        flowQuery = "";
        if (template.getNeedPage() == 1 && BeanUtils.isEmpty((Object)queryFilter.getPageBean())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(30), Boolean.valueOf(true)));
        }
        returnData.setRows(new ArrayList<E>());
        boDef = this.boDefService.getByAlias(template.getBoDefAlias());
        boEnt = boDef.getBoEnt();
        if (BeanUtils.isNotEmpty(dataTemplateQueryVo.getSelectList())) {
            selectList = dataTemplateQueryVo.getSelectList();
            for (SelectParam param : selectList) {
                fieldName = boEnt.getFieldPrefix() + param.getBindSelectd();
                if (StringUtil.isEmpty((String)param.getSelectValue())) {
                    returnData.setPage(1L);
                    if (template.getNeedPage() == 1) {
                        returnData.setPageSize((long)template.getPageSize().shortValue());
                    } else {
                        returnData.setPageSize(-1L);
                    }
                    return returnData;
                }
                queryFilter.addFilter(fieldName, (Object)param.getSelectValue(), QueryOP.EQUAL);
            }
        }
        if ("postgresql".equals(dbType)) {
            boAttrList = boEnt.getBoAttrList();
            for (Object query : queryFilter.getQuerys()) {
                if (!query.getClass().isAssignableFrom(QueryField.class)) continue;
                queryField = (QueryField)query;
                property = queryField.getProperty();
                for (BoAttribute boAttribute : boAttrList) {
                    if ((boEnt.getFieldPrefix() + boAttribute.getName()).equals(property) && "date".equals(boAttribute.getDataType()) && QueryOP.BETWEEN.equals((Object)queryField.getOperation()) && queryField.getValue().getClass() == ArrayList.class) {
                        value = (ArrayList)queryField.getValue();
                        newVal = new ArrayList<E>();
                        for (i = 0; i < value.size(); ++i) {
                            if (StringUtil.isNotEmpty((String)((String)value.get(i)))) {
                                newVal.add(DateFormatUtil.parseDate((String)((String)value.get(i)), (String)"yyyy-MM-dd HH:mm:ss"));
                                continue;
                            }
                            newVal.add(null);
                        }
                        queryField.setValue((Object)newVal);
                        continue;
                    }
                    if (!(boEnt.getFieldPrefix() + boAttribute.getName()).equals(property) || !"date".equals(boAttribute.getDataType()) || queryField.getValue().getClass() == ArrayList.class || !StringUtil.isNotEmpty((String)((String)queryField.getValue()))) continue;
                    queryField.setValue((Object)DateFormatUtil.parseDate((String)((String)queryField.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
        }
        flowQueryFilter = QueryFilter.build();
        isFlowBpmField = false;
        if ("oracle".equals(dbType) || "dm".equals(dbType)) {
            for (BoAttribute boAttribute : boEnt.getBoAttrList()) {
                if ("clob".equals(boAttribute.getDataType()) && StringUtil.isNotEmpty((String)boAttribute.getName())) {
                    querys = queryFilter.getQuerys();
                    for (QueryField query : querys) {
                        if (!(boEnt.getFieldPrefix() + boAttribute.getName()).equals(query.getProperty())) continue;
                        query.setProperty("TO_CHAR(" + query.getProperty() + ")");
                    }
                    continue;
                }
                if (!"date".equals(boAttribute.getDataType()) || !StringUtil.isNotEmpty((String)boAttribute.getName())) continue;
                querys = queryFilter.getQuerys();
                for (QueryField query : querys) {
                    if (!(boEnt.getFieldPrefix() + boAttribute.getName()).equals(query.getProperty()) || String.class != query.getValue().getClass()) continue;
                    query.setValue((Object)DateFormatUtil.parse((String)((String)query.getValue()), (String)boAttribute.getFormat()));
                }
            }
        }
        it = queryFilter.getQuerys().iterator();
        while (it.hasNext()) {
            flowObj = (QueryField)it.next();
            if (ArrayUtils.contains((Object[])FormDataTemplateManagerImpl.flowField, (Object)flowObj.getProperty())) {
                if (flowObj.getValue() != null) {
                    isFlowBpmField = true;
                    flowProperty = flowObj.getProperty().substring(6);
                    flowQueryFilter.addFilter(flowProperty, flowObj.getValue(), flowObj.getOperation());
                    it.remove();
                } else {
                    it.remove();
                }
            }
            if (!(property = flowObj.getProperty()).startsWith("$TREE$")) continue;
            newproperty = property;
            newproperty = boEnt.getIsExternal() == 0 ? property.replaceFirst("\\$TREE\\$", "F_") : property.replaceFirst("\\$TREE\\$", "");
            flowObj.setProperty(newproperty);
        }
        if (StringUtil.isNotEmpty((String)template.getDefId())) {
            flowQueryFilter.addFilter("proc_def_key_", (Object)template.getDefId(), QueryOP.EQUAL);
        }
        pageBean = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE);
        if (!isFlowBpmField) ** GOTO lbl105
        flowQueryFilter.setPageBean(pageBean);
        flowBpmList = service.getFlowFieldList(flowQueryFilter);
        if (BeanUtils.isNotEmpty((Object)flowBpmList)) {
            for (Map oNode : flowBpmList) {
                id = oNode.get("id_").toString();
                flowQuery = flowQuery + id + ",";
                flowFields.put(id, oNode);
            }
            queryFilter.addFilter("ID_", (Object)flowQuery, QueryOP.IN);
        } else {
            returnData.setPage(1L);
            if (template.getNeedPage() == 1) {
                returnData.setPageSize((long)template.getPageSize().shortValue());
            } else {
                returnData.setPageSize((long)PageBean.WITHOUT_PAGE.intValue());
            }
            return returnData;
lbl105:
            // 1 sources

            flowQueryFilter.setPageBean(pageBean);
            flowBpmList = service.getFlowFieldList(flowQueryFilter);
            if (BeanUtils.isNotEmpty((Object)flowBpmList)) {
                for (Map oNode : flowBpmList) {
                    id = oNode.get("id_").toString();
                    flowFields.put(id, oNode);
                }
            }
        }
        params = queryFilter.getParams();
        dsName = boEnt.getDsName();
        if (StringUtil.isEmpty((String)dsName)) {
            dsName = "LOCAL";
        }
        showSql = new StringBuffer("select t.* ");
        jsonNode = JsonUtil.toJsonNode((String)template.getDisplayField());
        for (JsonNode node : jsonNode) {
            displayField = (DisplayField)JsonUtil.toBean((JsonNode)node, DisplayField.class);
            if (displayField.getCustomColumn() == null || !displayField.getCustomColumn().booleanValue()) continue;
            if (displayField.getSql() == null || displayField.getSql() == "") {
                throw new BaseException("\u5b58\u5728\u5b57\u6bb5\u672a\u914d\u7f6eSQL\uff0c\u8bf7\u5148\u914d\u7f6e\u5b8c\u6574");
            }
            showSql.append(displayField.getSql());
        }
        showSql.append(" from " + boEnt.getTableName() + " t");
        if (dataTemplateQueryVo.isJoinFlow()) {
            pk = "id_";
            if (StringUtil.isNotEmpty((String)boEnt.getPk())) {
                pk = boEnt.getPk();
            }
            nodes = JsonUtil.getMapper().createObjectNode();
            nodes.put("defKey", dataTemplateQueryVo.getDefKey());
            nodes.put("taskType", dataTemplateQueryVo.getTaskType());
            listIds = this.workflowFeignService.getBusLink(nodes);
            if (listIds.size() > 0) {
                queryFilter.addFilter(pk, (Object)listIds, QueryOP.IN);
            } else {
                return returnData;
            }
        }
        if (BeanUtils.isNotEmpty((Object)queryFilter.getSorter())) {
            colPrefix = boEnt.isExternal() != false ? "" : "F_";
            sorter = queryFilter.getSorter();
            if (sorter != null) {
                sorter.forEach((Consumer<FieldSort>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getList$20(java.lang.String com.artfess.base.query.FieldSort ), (Lcom/artfess/base/query/FieldSort;)V)((String)colPrefix));
            }
        }
        queryFilter = this.getTemplateQueryFilter(queryFilter, template, boEnt);
        filterSql = this.getFilterSql(template.getFilterField(), dsName, params, boEnt);
        list = null;
        try {
            result = this.databaseContext.setDataSource(dsName);
            var23_30 = null;
            try {
                list = this.query(showSql.toString(), queryFilter, filterSql);
            }
            catch (Throwable var24_32) {
                var23_30 = var24_32;
                throw var24_32;
            }
            finally {
                if (result != null) {
                    if (var23_30 != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable var24_31) {
                            var23_30.addSuppressed(var24_31);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        if (BeanUtils.isNotEmpty(list)) {
            returnData.setPage(list.getPage());
            returnData.setPageSize(list.getPageSize());
            for (Map rowMap : list.getRows()) {
                rtnMap = this.convertDbToData(boEnt, rowMap);
                rtnMap.put("isStartFlow", true);
                for (JsonNode node : jsonNode) {
                    displayField = (DisplayField)JsonUtil.toBean((JsonNode)node, DisplayField.class);
                    if (displayField.getCustomColumn() == null || !displayField.getCustomColumn().booleanValue()) continue;
                    rtnMap.put(displayField.getName(), rowMap.get(displayField.getName()));
                }
                returnData.getRows().add(rtnMap);
                returnData.setTotal(list.getTotal());
            }
        }
        return returnData;
    }

    @Override
    public PageList<Map<String, Object>> getSubDataPagination(QueryFilter queryFilter, String alias, String refId) throws Exception {
        if (StringUtil.isNotEmpty((String)refId) && StringUtil.isNotEmpty((String)alias)) {
            return this.getSubList(queryFilter, alias, refId);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getSubData(String alias, String refId) throws Exception {
        if (StringUtil.isNotEmpty((String)refId) && StringUtil.isNotEmpty((String)alias)) {
            return this.getSubList(alias, refId);
        }
        return null;
    }

    @Override
    public void exportSub(HttpServletResponse response, ExportSubVo exportVo) throws Exception {
        String getType = StringUtil.isEmpty((String)exportVo.getType()) ? "getType" : exportVo.getType();
        PageBean page = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE);
        if ("page".equals(getType)) {
            page.setPageSize(10);
        }
        QueryFilter queryFilter = exportVo.getQueryFilter();
        queryFilter.setPageBean(page);
        PageList<Map<String, Object>> pageList = this.getSubList(queryFilter, exportVo.getAlias(), exportVo.getRefId());
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        for (JsonNode str : (ArrayNode)JsonUtil.toJsonNode((String)exportVo.getExpField())) {
            exportMaps.put(str.get("key").asText(), str.get("value").asText());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)exportVo.getAlias(), (int)24, exportMaps, (List)pageList.getRows());
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)exportVo.getAlias(), (HttpServletResponse)response);
    }

    public StringBuilder preSql(BoEnt boEnt) {
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(boEnt.getTableName());
        sql.append(" (id_,ref_id_");
        List columnList = boEnt.getColumnList();
        if (columnList != null) {
            columnList.forEach(i -> sql.append("," + i.getFieldName()));
        }
        sql.append(",F_form_data_rev_");
        sql.append(") values (");
        return sql;
    }

    private void addFieldList(List<FormField> fields) {
        String[] fileArr = new String[]{"\u6d41\u7a0b\u7f16\u53f7", "\u6807\u9898", "\u6d41\u7a0b\u540d\u79f0", "\u5b9e\u4f8b\u72b6\u6001", "\u521b\u5efa\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4", "\u662f\u5426\u6302\u8d77", "\u53d1\u8d77\u4eba", "\u662f\u5426\u5220\u9664"};
        String[] nameArr = new String[]{"bpm_proc_inst_id_", "bpm_subject_", "bpm_proc_def_name_", "bpm_status_", "bpm_create_time_", "bpm_end_time_", "bpm_is_forbidden_", "bpm_creator_", "bpm_is_dele_"};
        String[] typeArr = new String[]{"varchar", "varchar", "varchar", "varchar", "date", "date", "varchar", "varchar", "varchar"};
        for (int i = 0; i < fileArr.length; ++i) {
            FormField field = new FormField();
            field.setFlowField(true);
            field.setName(nameArr[i]);
            field.setDesc(fileArr[i]);
            field.setType(typeArr[i]);
            field.setShowFlowField(true);
            fields.add(field);
        }
    }

    @Override
    public FormDataTemplate getByAlias(String alias) {
        return ((FormDataTemplateDao)this.baseMapper).getByAlias(alias);
    }

    @Override
    public void removeByFormKey(String formKey) {
        ((FormDataTemplateDao)this.baseMapper).removeByFormKey(formKey);
    }

    private Map<String, Object> convertDbToData(BoEnt boEnt, Map<String, Object> map) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> ent : map.entrySet()) {
            String field = ent.getKey().toLowerCase();
            BoAttribute attribute = boEnt.getAttrByField(field);
            if (!BeanUtils.isNotEmpty((Object)attribute)) continue;
            Object val = this.handValue(attribute, ent.getValue());
            rtnMap.put(attribute.getName(), val);
        }
        String pkKey = boEnt.getPkKey();
        if (boEnt.isPkNumber() && BeanUtils.isNotEmpty(rtnMap.get(pkKey))) {
            rtnMap.put(pkKey, rtnMap.get(pkKey).toString());
        }
        return rtnMap;
    }

    private Object handValue(BoAttribute attr, Object val) {
        if (BeanUtils.isEmpty((Object)val)) {
            return val;
        }
        String format = attr.getFormat();
        if (val instanceof Timestamp) {
            Timestamp times = (Timestamp)val;
            return TimeUtil.getDateTimeString((LocalDateTime)times.toLocalDateTime(), (String)format);
        }
        if (val instanceof Date) {
            return TimeUtil.getDateTimeString((LocalDateTime)DateFormatUtil.parse((Date)((Date)val)), (String)format);
        }
        return val;
    }

    private QueryFilter getTemplateQueryFilter(QueryFilter queryFilter, FormDataTemplate bpmDataTemplate, BoEnt boEnt) throws Exception {
        if (BeanUtils.isNotEmpty((Object)((Object)bpmDataTemplate))) {
            PageBean page = queryFilter.getPageBean();
            if (2 == bpmDataTemplate.getNeedPage()) {
                page.setPageSize(PageBean.WITHOUT_PAGE.intValue());
            } else {
                page.setPageSize(queryFilter.getPageBean().getPageSize().intValue());
            }
            queryFilter.setPageBean(page);
            String sortField = bpmDataTemplate.getSortField();
            if (StringUtil.isNotZeroEmpty((String)sortField)) {
                String colPrefix = boEnt.isExternal() ? "" : "F_";
                ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)sortField);
                for (int i = 0; i < array.size(); ++i) {
                    ObjectNode obj = (ObjectNode)array.get(i);
                    queryFilter.getSorter().add(new FieldSort(colPrefix + obj.get("name").asText(), Direction.fromString((String)obj.get("sort").asText())));
                }
            }
        }
        return queryFilter;
    }

    private PageList<?> query(String sql, QueryFilter queryFilter, String filterSql) throws SystemException {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull((Object)queryFilter, (String)"queryFilter can not be empty.");
        if (StringUtil.isNotEmpty((String)filterSql)) {
            queryFilter.addParams(filterSql, null);
        }
        queryFilter.withParam("filterSql", (Object)filterSql);
        return this.commonManager.queryByCustomSql(sql, queryFilter);
    }

    private PageList<Map<String, Object>> getSubList(QueryFilter queryFilter, String alias, String refId) throws Exception {
        PageList pageList = new PageList();
        BoEnt boEnt = this.boEntManager.getByName(alias);
        String dsName = boEnt.getDsName();
        if (StringUtil.isEmpty((String)dsName)) {
            dsName = "LOCAL";
        }
        String showSql = "select * from " + boEnt.getTableName();
        if (StringUtil.isNotEmpty((String)refId)) {
            queryFilter.addFilter(boEnt.getFk(), (Object)refId, QueryOP.EQUAL);
        }
        try (DatabaseSwitchResult result = this.databaseContext.setDataSource(dsName);){
            List boAttrList;
            List queryFields;
            if ("postgresql".equals(result.getDbType())) {
                queryFields = queryFilter.getQuerys();
                boAttrList = boEnt.getBoAttrList();
                block13: for (QueryField queryField : queryFields) {
                    for (BoAttribute boAttribute : boAttrList) {
                        if (!boAttribute.getFieldName().toUpperCase().equals(queryField.getProperty().toUpperCase())) continue;
                        if (!"number".equals(boAttribute.getDataType()) && !"date".equals(boAttribute.getDataType())) continue block13;
                        queryField.setProperty(queryField.getProperty() + "||''");
                    }
                }
            } else if ("oracle".equals(result.getDbType())) {
                queryFields = queryFilter.getQuerys();
                boAttrList = boEnt.getBoAttrList();
                block15: for (QueryField queryField : queryFields) {
                    for (BoAttribute boAttribute : boAttrList) {
                        if (!boAttribute.getFieldName().toUpperCase().equals(queryField.getProperty().toUpperCase())) continue;
                        if (!"date".equals(boAttribute.getDataType())) continue block15;
                        queryField.setProperty(" TO_CHAR(" + queryField.getProperty() + ",'yyyy-MM-dd') ");
                    }
                }
            }
            pageList = this.query(showSql, queryFilter, "");
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        List list = pageList.getRows();
        this.convertToDateTime(list, boEnt.getColumnList());
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            HashMap tm = new HashMap();
            for (String k : m.keySet()) {
                try {
                    tm.put(k.toLowerCase(), m.get(k));
                }
                catch (Exception e) {
                    tm.put(k.toLowerCase(), m.get(k));
                }
                list.set(i, tm);
            }
        }
        pageList.setRows(list);
        if (BeanUtils.isNotEmpty(pageList)) {
            return pageList;
        }
        return pageList;
    }

    private void convertToDateTime(List<Map<String, Object>> list, List<BoAttribute> columnList) {
        for (Map<String, Object> map : list) {
            for (BoAttribute column : columnList) {
                if (!"date".equals(column.getDataType())) continue;
                if (BeanUtils.isNotEmpty((Object)map.get(column.getFieldName().toLowerCase()))) {
                    map.put(column.getFieldName(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(column.getFieldName().toLowerCase())));
                    continue;
                }
                if (BeanUtils.isNotEmpty((Object)map.get(column.getFieldName()))) {
                    map.put(column.getFieldName(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(column.getFieldName())));
                    continue;
                }
                if (!BeanUtils.isNotEmpty((Object)map.get(column.getFieldName().toUpperCase()))) continue;
                map.put(column.getFieldName().toUpperCase(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(column.getFieldName().toUpperCase())));
            }
        }
    }

    private List<Map<String, Object>> getSubList(String alias, String refId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        PageList<Map<String, Object>> pageList = this.getSubList(queryFilter, alias, refId);
        return pageList.getRows();
    }

    @Override
    public Map<String, String> exportDef(List<String> list) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        FormDataTemplateXmlList formDataTemplateXmlList = new FormDataTemplateXmlList();
        for (String id : list) {
            FormDataTemplateXml formDataTemplateXml = this.getByTemplateId(id);
            formDataTemplateXmlList.addFormDataTemplateXml(formDataTemplateXml);
        }
        try {
            String xml = JAXBUtil.marshall((Object)formDataTemplateXmlList, FormDataTemplateXmlList.class);
            map.put("formDataTemplates.form.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @CachePut(value={"bpm:form:datatemplateImportFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"bpm:form:datatemplateImportFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"bpm:form:datatemplateImportFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    public CommonResult<String> importDef(ObjectNode objectNode, String typeId) {
        try {
            String formDataTemplatesXml = objectNode.get("formDataTemplatesXml").asText();
            FormDataTemplateXmlList formDataTemplateXmlList = (FormDataTemplateXmlList)JAXBUtil.unmarshall((String)formDataTemplatesXml, FormDataTemplateXmlList.class);
            List<FormDataTemplateXml> list = formDataTemplateXmlList.getFormDataTemplateXmlList();
            for (FormDataTemplateXml formDataTemplateXml : list) {
                this.importDef(formDataTemplateXml, typeId);
            }
            return new CommonResult("\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            throw new RuntimeException("XML\u8f6c\u6362\u4e3aPOJO\u7c7b\u578b\u9519\u8bef" + e.getMessage(), e);
        }
    }

    private void importDef(FormDataTemplateXml formDataTemplateXml, String typeId) {
        this.importDefinition(formDataTemplateXml, typeId);
    }

    private FormDataTemplate importDefinition(FormDataTemplateXml formDataTemplateXml, String typeId) {
        IUser user;
        FormDataTemplate formDataTemplate = formDataTemplateXml.getFormDataTemplate();
        SystemConfigFeignService systemConfigFeignService = (SystemConfigFeignService)AppUtil.getBean(SystemConfigFeignService.class);
        ObjectNode sysType = systemConfigFeignService.getSysTypeById(typeId);
        String typeName = "";
        if (BeanUtils.isNotEmpty((Object)sysType)) {
            typeName = sysType.get("name").asText();
        }
        if (StringUtil.isNotEmpty((String)typeId)) {
            formDataTemplate.setTypeId(typeId);
            formDataTemplate.setTypeName(typeName);
        }
        if (BeanUtils.isNotEmpty((Object)(user = ContextUtil.getCurrentUser()))) {
            formDataTemplate.setCreateBy(user.getUserId());
        }
        formDataTemplate.setCreateTime(LocalDateTime.now());
        FormDataTemplate entity = ((FormDataTemplateDao)this.baseMapper).getByAlias(formDataTemplate.getAlias());
        if (BeanUtils.isNotEmpty((Object)((Object)entity))) {
            if (BeanUtils.isNotEmpty((Object)user)) {
                formDataTemplate.setUpdateBy(user.getUserId());
                formDataTemplate.setUpdateTime(LocalDateTime.now());
            }
            ((FormDataTemplateDao)this.baseMapper).updateById((Object)formDataTemplate);
        } else {
            formDataTemplate.setId(UniqueIdUtil.getSuid());
            ((FormDataTemplateDao)this.baseMapper).insert((Object)formDataTemplate);
        }
        return formDataTemplate;
    }

    private FormDataTemplateXml getByTemplateId(String id) {
        FormDataTemplate formDataTemplate = (FormDataTemplate)((Object)((FormDataTemplateDao)this.baseMapper).selectById((Serializable)((Object)id)));
        FormDataTemplateXml formDataTemplateXml = new FormDataTemplateXml();
        formDataTemplateXml.setFormDataTemplate(formDataTemplate);
        return formDataTemplateXml;
    }

    @Override
    @Transactional
    public void checkAndImportData(List<Map<String, Object>> rows, BoEnt boEnt, Map<String, BoAttribute> columnMap, String bindFilld, String fillValue, String refIdValue, FormDataTemplate template, BoDataImportHandler boDataImportHandler, Map<String, String> nameFieldMap) throws Exception {
        String refValue = "undefined".equals(refIdValue) ? "0" : refIdValue;
        FormMeta formDef = this.formMetaManager.getByKey(template.getFormKey());
        HashMap<String, Map<String, JsonNode>> filedValidateMap = new HashMap<String, Map<String, JsonNode>>();
        ArrayNode filedsArray = FormUtil.resolutionFieldsByFormMeta(formDef);
        if (BeanUtils.isNotEmpty((Object)filedsArray)) {
            for (JsonNode filed : filedsArray) {
                if (BeanUtils.isEmpty((Object)filed.get("options")) || BeanUtils.isEmpty((Object)filed.get("options").get("validateList"))) continue;
                HashMap<String, JsonNode> validateMap = new HashMap<String, JsonNode>();
                for (JsonNode validat : filed.get("options").get("validateList")) {
                    validateMap.put(validat.get("key").asText(), validat);
                }
                filedValidateMap.put(filed.get("name").asText(), validateMap);
            }
        }
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)(boEnt.getDsName() == null ? "LOCAL" : boEnt.getDsName()));
        ArrayList<FormDataImportLog> validateList = new ArrayList<FormDataImportLog>();
        HashMap threadVarMap = new HashMap();
        HashMap<String, Set<Object>> uniqueValeMap = new HashMap<String, Set<Object>>();
        for (int i = 0; i < rows.size(); ++i) {
            StringBuffer sql = new StringBuffer("insert into ");
            Map row = rows.get(i);
            if (BeanUtils.isEmpty(row)) continue;
            List<ValidateResult> validateData = this.validateData(row, filedValidateMap, columnMap, uniqueValeMap);
            if (BeanUtils.isNotEmpty(validateData)) {
                for (ValidateResult validateResult : validateData) {
                    FormDataImportLog log = new FormDataImportLog(validateResult);
                    log.setId(UniqueIdUtil.getSuid());
                    log.setRowNumber(i + 3);
                    log.setPId(refValue);
                    log.setBoAlias(template.getBoDefAlias());
                    validateList.add(log);
                }
                continue;
            }
            if (boDataImportHandler != null) {
                List validateRes = boDataImportHandler.validateData(rows.get(i), boEnt, threadVarMap);
                if (BeanUtils.isNotEmpty((Object)validateRes)) {
                    for (ValidateResult validateResult2 : validateRes) {
                        FormDataImportLog log = new FormDataImportLog(validateResult2);
                        log.setId(UniqueIdUtil.getSuid());
                        log.setRowNumber(i + 3);
                        log.setPId(refValue);
                        log.setBoAlias(template.getBoDefAlias());
                        validateList.add(log);
                    }
                    continue;
                }
                row = boDataImportHandler.transData(rows.get(i), boEnt, threadVarMap);
            }
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            StringBuffer params = new StringBuffer();
            String dbType = SQLUtil.getDbType();
            for (Map.Entry<String, Object> map : row.entrySet()) {
                BoAttribute field;
                if ("\u4e3b\u952e".equals(map.getKey())) {
                    fields.add(boEnt.getPkKey());
                    if (BeanUtils.isNotEmpty(row.get("\u4e3b\u952e"))) {
                        arrayList.add("'" + row.get("\u4e3b\u952e") + "'");
                    } else {
                        arrayList.add(UniqueIdUtil.getSuid());
                    }
                    params.append("?,");
                    continue;
                }
                if (!BeanUtils.isNotEmpty((Object)map.getValue())) continue;
                String key = map.getKey();
                if (nameFieldMap.containsKey(key)) {
                    key = nameFieldMap.get(key);
                }
                if (BeanUtils.isEmpty((Object)(field = columnMap.get(key))) || field.getName().equals(bindFilld)) continue;
                fields.add(field.getFieldName());
                if (map.getValue() instanceof String) {
                    if (DateUtil.isRqSjFormat((String)map.getValue().toString()) && (dbType.equals("postgresql") || dbType.equals("oracle"))) {
                        arrayList.add(Timestamp.valueOf(map.getValue().toString()));
                    } else if (DateUtil.isRqFormat((String)map.getValue().toString()) && (dbType.equals("postgresql") || dbType.equals("oracle"))) {
                        arrayList.add(Timestamp.valueOf(map.getValue().toString() + " 00:00:00"));
                    } else if (map.getValue().toString().matches("\\d+(.\\d+)?") && dbType.equals("postgresql")) {
                        arrayList.add(Float.valueOf(Float.parseFloat(map.getValue().toString())));
                    } else {
                        arrayList.add(map.getValue());
                    }
                } else {
                    arrayList.add(map.getValue());
                }
                params.append("?,");
            }
            if (!fields.contains(boEnt.getPkKey())) {
                fields.add(boEnt.getPkKey());
                if (boEnt.isPkNumber()) {
                    arrayList.add(UniqueIdUtil.getUId());
                } else {
                    arrayList.add(UniqueIdUtil.getSuid());
                }
                params.append("?,");
            }
            if (StringUtil.isNotEmpty((String)bindFilld) && StringUtil.isNotEmpty((String)fillValue)) {
                fields.add(BoEnt.FIELD_PREFIX + bindFilld);
                arrayList.add(fillValue);
                params.append("?,");
            }
            if (StringUtil.isNotEmpty((String)boEnt.getFk())) {
                fields.add(boEnt.getFk());
                if (StringUtil.isNotEmpty((String)refValue)) {
                    arrayList.add(refValue);
                } else {
                    arrayList.add("0");
                }
                params.append("?,");
            }
            if (!boEnt.isExternal()) {
                fields.add("F_form_data_rev_");
                if (dbType.equals("postgresql")) {
                    arrayList.add(0);
                } else {
                    arrayList.add("0");
                }
                params.append("?,");
            }
            fields.add(BoEnt.FK_NAME);
            if (StringUtil.isNotEmpty((String)refValue)) {
                arrayList.add(refValue);
            } else {
                arrayList.add("0");
            }
            params.append("?,");
            fields.add("F_form_data_rev_");
            if (dbType.equals("postgresql")) {
                arrayList.add(0);
            } else {
                arrayList.add("0");
            }
            params.append("?");
            sql.append(boEnt.getTableName());
            sql.append("(" + String.join((CharSequence)",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + params.substring(0, params.length() - 1) + ")");
            try {
                jdbcTemplate.update(sql.toString(), arrayList.toArray());
                continue;
            }
            catch (Exception e) {
                FormDataImportLog log = new FormDataImportLog();
                log.setId(UniqueIdUtil.getSuid());
                log.setRowNumber(i + 3);
                log.setPId(refValue);
                log.setBoAlias(template.getBoDefAlias());
                log.setErrorMsg(e.getMessage());
                validateList.add(log);
            }
        }
        if (validateList.size() > 0) {
            ExecutorService executorService = Executors.newCachedThreadPool();
            executorService.execute(() -> {
                try {
                    this.formDataImportLogManager.deleteByPid(refValue, template.getBoDefAlias());
                    this.formDataImportLogManager.saveBatch(validateList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            throw new RuntimeException("\u5bfc\u5165\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u5bfc\u5165\u65e5\u5fd7");
        }
        this.formDataImportLogManager.deleteByPid(refValue, template.getBoDefAlias());
        if (StringUtil.isNotEmpty((String)bindFilld)) {
            String cleanSql = "delete from " + boEnt.getTableName() + " where " + BoEnt.FK_NAME + " < " + String.valueOf(System.currentTimeMillis() - 86400000L) + " and " + BoEnt.FIELD_PREFIX + bindFilld + " > " + String.valueOf(TimeUtil.getMillsByDateString((String)"2020-01-01"));
            jdbcTemplate.execute(cleanSql);
        }
    }

    private List<ValidateResult> validateData(Map<String, Object> data, Map<String, Map<String, JsonNode>> filedValidateMap, Map<String, BoAttribute> columnMap, Map<String, Set<Object>> uniqueValeMap) {
        ArrayList<ValidateResult> list = new ArrayList<ValidateResult>();
        HashMap<String, BoAttribute> filedNameMap = new HashMap<String, BoAttribute>();
        for (BoAttribute attr : columnMap.values()) {
            filedNameMap.put(attr.getName(), attr);
        }
        for (Map.Entry<String, Map<String, JsonNode>> next : filedValidateMap.entrySet()) {
            if (!filedNameMap.containsKey(next.getKey())) continue;
            BoAttribute attribute = (BoAttribute)filedNameMap.get(next.getKey());
            Object value = data.get(attribute.getDesc());
            for (Map.Entry<String, JsonNode> entity : next.getValue().entrySet()) {
                ValidateResult validateRes = this.validate(attribute, value, entity.getKey(), entity.getValue(), filedNameMap, data, uniqueValeMap);
                if (!BeanUtils.isNotEmpty((Object)validateRes)) continue;
                list.add(validateRes);
            }
        }
        return list;
    }

    private ValidateResult validate(BoAttribute attribute, Object value, String validateName, JsonNode validate, Map<String, BoAttribute> filedNameMap, Map<String, Object> data, Map<String, Set<Object>> uniqueValeMap) {
        String errorMsg = "";
        switch (validateName) {
            case "required": {
                if (!BeanUtils.isEmpty((Object)value)) break;
                errorMsg = "\u4e0d\u80fd\u4e3a\u7a7a";
                break;
            }
            case "max": {
                int maxLen = JsonUtil.getInt((ObjectNode)((ObjectNode)validate), (String)"value");
                if (BeanUtils.ObjectToString((Object)value).length() <= maxLen) break;
                errorMsg = "\u957f\u5ea6\u8d85\u51fa" + maxLen;
                break;
            }
            case "min": {
                int minLen = JsonUtil.getInt((ObjectNode)((ObjectNode)validate), (String)"value");
                if (BeanUtils.ObjectToString((Object)value).length() >= minLen) break;
                errorMsg = "\u957f\u5ea6\u4e0d\u591f" + minLen;
                break;
            }
            case "is": {
                HashSet<String> values;
                String valueScope = JsonUtil.getString((JsonNode)((ObjectNode)validate), (String)"value");
                if (!StringUtil.isNotEmpty((String)valueScope) || (values = new HashSet<String>(Arrays.asList(valueScope.split(",")))).contains(value)) break;
                errorMsg = "\u8f93\u5165\u503c\u4e0d\u5728\u3010" + StringUtil.join(values) + "\u3011\u8303\u56f4\u4e4b\u5185";
                break;
            }
            case "regex": {
                String regex = JsonUtil.getString((JsonNode)((ObjectNode)validate), (String)"value");
                if (!StringUtil.isNotEmpty((String)regex) || Pattern.matches(regex, BeanUtils.ObjectToString((Object)value))) break;
                errorMsg = "\u6b63\u5219\u4e0d\u5339\u914d";
                break;
            }
            case "row_unique": {
                Set<Object> valueSet;
                ArrayList<String> uniqueKeyList = new ArrayList<String>(Arrays.asList(JsonUtil.getString((JsonNode)((ObjectNode)validate), (String)"value").split(",")));
                if (!uniqueKeyList.contains(attribute.getName())) {
                    uniqueKeyList.add(attribute.getName());
                }
                ArrayList<String> uniqueValList = new ArrayList<String>();
                ArrayList<String> uniqueDescList = new ArrayList<String>();
                for (String key : uniqueKeyList) {
                    if (key.split("\\.").length == 3) {
                        key = key.split("\\.")[2];
                    }
                    if (!filedNameMap.containsKey(key)) continue;
                    uniqueValList.add(BeanUtils.ObjectToString((Object)data.get(filedNameMap.get(key).getDesc())));
                    uniqueDescList.add(filedNameMap.get(key).getDesc());
                }
                String uniqueKey = StringUtil.join(uniqueKeyList, (String)"");
                Set<Object> set = valueSet = BeanUtils.isNotEmpty(uniqueValeMap.get(uniqueKey)) ? uniqueValeMap.get(uniqueKey) : new HashSet();
                if (valueSet.contains(StringUtil.join(uniqueValList, (String)""))) {
                    errorMsg = "\u8fdd\u53cd\u3010" + StringUtil.join(uniqueDescList, (String)"+") + "\u3011\u552f\u4e00\u7ea6\u675f";
                } else {
                    valueSet.add(StringUtil.join(uniqueValList, (String)""));
                }
                uniqueValeMap.put(uniqueKey, valueSet);
                break;
            }
        }
        if (StringUtil.isEmpty((String)errorMsg)) {
            return null;
        }
        return new ValidateResult(attribute.getDesc(), errorMsg);
    }

    @Override
    public List<Map<String, Object>> resolutionExcel(MultipartFile firstFile, Map<String, BoAttribute> columnMap, String bindFilld) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Workbook wb = ExcelUtil.readExcel((MultipartFile)firstFile);
        if (wb == null) {
            return list;
        }
        List<Map> listMap = ExcelUtil.ImportDate((MultipartFile)firstFile).stream().filter(item -> !this.isEmptyRow((Map<String, String>)item)).collect(Collectors.toList());
        listMap.forEach(map -> {
            LinkedHashMap boData = new LinkedHashMap();
            map.forEach((key, value) -> {
                if (columnMap.containsKey(key)) {
                    BoAttribute boAttribute = (BoAttribute)columnMap.get(key);
                    boData.put(boAttribute.getDesc(), value);
                }
            });
            if (boData.size() > 0) {
                list.add(boData);
            }
        });
        return list;
    }

    private boolean isEmptyRow(Map<String, String> param) {
        boolean isEmpty = true;
        for (String key : param.keySet()) {
            if (!BeanUtils.isNotEmpty((Object)param.get(key))) continue;
            isEmpty = false;
        }
        return isEmpty;
    }

    public Object getCellFormatValue(BoAttribute boAttribute, Cell cell) {
        if (cell == null) {
            return "";
        }
        Object cellValue = null;
        switch (boAttribute.getDataType()) {
            case "number": {
                cellValue = cell.getNumericCellValue();
                break;
            }
            case "date": {
                if (CellType.STRING == cell.getCellType()) {
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
                cellValue = cell.getDateCellValue();
                break;
            }
            case "varchar": {
                if (CellType.NUMERIC == cell.getCellType()) {
                    cellValue = BeanUtils.ObjectToString((Object)cell.getNumericCellValue());
                    break;
                }
                cellValue = cell.getRichStringCellValue().getString();
                break;
            }
            default: {
                cellValue = "";
            }
        }
        return cellValue;
    }

    @Override
    public void downloadMainTempByFormKey(HttpServletResponse response, String alias) throws Exception {
        Form bpmForm = this.formManager.getMainByFormKey(alias);
        String formId = bpmForm.getDefId();
        List<String> boDefIds = this.formMetaManager.getBODefIdByFormId(formId);
        BoDef boDef = this.boDefService.getByDefId(boDefIds.get(0));
        BoEnt boEnt = boDef.getBoEnt();
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        List boAttrList = boEnt.getColumnList();
        for (BoAttribute boAttr : boAttrList) {
            exportMaps.put(boAttr.getName(), boAttr.getDesc());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)bpmForm.getName(), (int)24, exportMaps, new ArrayList());
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)(bpmForm.getName() + "_\u5bfc\u5165\u6a21\u677f"), (HttpServletResponse)response);
    }

    @Override
    public int updateTempRefId(ObjectNode objectNode) throws Exception {
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)"LOCAL");
        String tableName = objectNode.get("tabName").asText();
        String refFiled = BoEnt.FK_NAME;
        String oldValue = objectNode.get("oldValue").asText();
        String newValue = objectNode.get("newValue").asText();
        ArrayList<String> values = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tableName).append(" set ").append(refFiled).append("= ? ");
        values.add(newValue);
        sql.append(" where ");
        sql.append(refFiled);
        sql.append("=?");
        values.add(oldValue);
        int update = jdbcTemplate.update(sql.toString(), values.toArray());
        StringBuffer logUpdateSql = new StringBuffer();
        logUpdateSql.append(" update form_data_import_log  set  P_ID_").append("= ? ");
        logUpdateSql.append(" where P_ID_ =?");
        jdbcTemplate.update(logUpdateSql.toString(), values.toArray());
        return update;
    }

    @Override
    @Transactional
    public void boBatchUpdate(List<ObjectNode> listJson, String boAlias) throws Exception {
        BoDef boDef = this.boDefService.getByAlias(boAlias);
        BoDataHandler handler = this.boInstanceFactory.getBySaveType("database");
        BoEnt boEnt = boDef.getBoEnt();
        String pk = boEnt.getPk();
        if (StringUtil.isEmpty((String)pk)) {
            pk = BoEnt.PK_NAME;
        }
        for (int i = 0; i < listJson.size(); ++i) {
            List resultList;
            ObjectNode objectNode = listJson.get(i);
            if (!objectNode.has(pk)) {
                if (objectNode.has(pk.toUpperCase())) {
                    pk = pk.toUpperCase();
                } else {
                    if (!objectNode.has(pk.toLowerCase())) continue;
                    pk = pk.toLowerCase();
                }
            }
            String id = objectNode.get(pk).asText();
            BoData boData = handler.getResById((Object)id, boAlias);
            Map map = boData.getData();
            map.forEach((key, value) -> {
                if (objectNode.has(key)) {
                    if (value instanceof BigDecimal) {
                        map.put(key, new BigDecimal(objectNode.get(key).asText()));
                    } else if (value instanceof Integer) {
                        map.put(key, Integer.parseInt(objectNode.get(key).asText()));
                    } else {
                        map.put(key, objectNode.get(key).asText());
                    }
                }
            });
            if (BeanUtils.isEmpty((Object)boData.getBoEnt())) {
                boData.setBoEnt(boEnt);
            }
            if (BeanUtils.isNotEmpty((Object)(resultList = handler.save("", "", boData)))) {
                this.handleBoResult(resultList, (ObjectNode)JsonUtil.toJsonNode((Object)boData.getData()));
            }
            if (!objectNode.has("formKey")) continue;
            String formKey = objectNode.get("formKey").asText();
            this.saveBo(boData, id, formKey);
        }
    }

    private void saveBo(BoData boData, String boDataId, String formKey) throws Exception {
        List<FormDataTemplateExtend> list = this.formDataTemplateExtendManager.getDataTemplateExtendByFormKey(formKey);
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"ID_", (Object)boDataId);
        this.formRemindDataManager.deleteFormRemindDataByBoDataId(qw);
        ArrayList<FormRemindData> insertList = new ArrayList<FormRemindData>();
        for (int i = 0; i < list.size(); ++i) {
            JsonNode node;
            String script;
            boolean res;
            FormDataTemplateExtend formDataTemplateExtend = list.get(i);
            String scriptJson = formDataTemplateExtend.getRule();
            if (StringUtil.isEmpty((String)scriptJson) || !(res = this.groovyScriptEngine.executeBoolean(Base64.getFromBase64((String)(script = (node = JsonUtil.toJsonNode((String)scriptJson)).get("scriptStr").asText())), boData.getData()))) continue;
            String typeObj = formDataTemplateExtend.getTypeObj();
            String objId = formDataTemplateExtend.getObjId();
            String content = formDataTemplateExtend.getContent();
            String count = formDataTemplateExtend.getCount();
            if (typeObj.equals("script")) {
                objId = boData.getData().get(objId) + "";
                FormRemindData formRemindData = new FormRemindData();
                formRemindData.setSubject(formDataTemplateExtend.getSubject());
                formRemindData.setContent(content);
                formRemindData.setCount(count);
                formRemindData.setObjId(objId);
                formRemindData.setTypeObj("user");
                formRemindData.setOpemId(boDataId);
                formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                insertList.add(formRemindData);
                continue;
            }
            String[] objIds = objId.split(",");
            for (int j = 0; j < objIds.length; ++j) {
                FormRemindData formRemindData = new FormRemindData();
                formRemindData.setSubject(formDataTemplateExtend.getSubject());
                formRemindData.setContent(content);
                formRemindData.setCount(count);
                formRemindData.setObjId(objIds[j]);
                formRemindData.setTypeObj(typeObj);
                formRemindData.setOpemId(boDataId);
                formRemindData.setOpemType(formDataTemplateExtend.getAlias());
                insertList.add(formRemindData);
            }
        }
        this.formRemindDataManager.saveBatch(insertList);
    }

    @Override
    public List<FormDataTemplate> getExistsByFormKey(String formKey) {
        QueryFilter filter = QueryFilter.build();
        filter.addFilter("FORM_KEY_", (Object)formKey, QueryOP.EQUAL, FieldRelation.AND);
        PageList query = this.query(filter);
        if (BeanUtils.isEmpty((Object)query.getRows())) {
            return null;
        }
        return query.getRows();
    }

    private static /* synthetic */ void lambda$getList$20(String colPrefix, FieldSort i) {
        i.setProperty(colPrefix + i.getProperty());
    }
}

