package com.artfess.application.persistence.manager;

import com.artfess.application.model.MsgTemplate;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;

/**
 * 对象功能:消息模版 Manager
 * @author zhaoxy
 * @company 广州宏天软件股份有限公司
 * @email zhxy@jee-soft.cn
 * @date 2018-06-06 14:20
 */
public interface MsgTemplateManager extends BaseManager<MsgTemplate> {
	/**
	 * 通过模板key获取模板
	 * @param templateKey
	 * @return
	 */
	public MsgTemplate getByKey(String templateKey);
	/**
	 * 获取指定类型的默认模板
	 * @param typeKey
	 * @return
	 */
	public MsgTemplate getDefault(String typeKey);
	/**
	 * 设置模板为该类型的默认模板
	 * @param id
	 */
	void setDefault(String id);
	/**
	 * 判断指定类型、指定key的模板是否已经存在
	 * @param key
	 * @param typeKey
	 * @return
	 */
	Boolean isExistByKeyAndTypeKey(String key, String typeKey);

	/**
	 * 判断指定类型、指定key的模板是否已经存在
	 * @param key
	 * @param typeKey
	 * @return
	 */
	MsgTemplate queryMsgTemplateByKeyAndTypeKey(String key, String typeKey);

	/**
	 * 将模板设置为非默认
	 * @param id
	 */
	void setNotDefault(String id);
	/**
	 * 分页查询
	 */
	PageList<MsgTemplate> queryByType(QueryFilter queryFilter);


	MsgTemplate gettypeKey(String typeKey);

}
