/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.SubjectTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqlt.dao.QfFinancePlBudgetMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinancePlBudgetDManager;
import com.artfess.cqlt.manager.QfFinancePlBudgetMManager;
import com.artfess.cqlt.manager.QfFinancePlBudgetSManager;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinancePlBudgetD;
import com.artfess.cqlt.model.QfFinancePlBudgetM;
import com.artfess.cqlt.model.QfFinancePlBudgetS;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.FinancialVo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinancePlBudgetMManagerImpl
extends BaseManagerImpl<QfFinancePlBudgetMDao, QfFinancePlBudgetM>
implements QfFinancePlBudgetMManager {
    private static final Logger log = LoggerFactory.getLogger(QfFinancePlBudgetMManagerImpl.class);
    @Autowired
    private QfFinancePlBudgetDManager financePlBudgetDManager;
    @Autowired
    private QfFinancePlBudgetSManager financePlBudgetSManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;
    @Autowired
    private QfFinancialStatisticalManager qfFinancialStatisticalManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinancePlBudgetM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfFinancePlBudgetMS = ((QfFinancePlBudgetMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinancePlBudgetMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinancePlBudgetMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinancePlBudgetM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfFinancePlBudgetMS = ((QfFinancePlBudgetMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinancePlBudgetMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinancePlBudgetMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfFinancePlBudgetM t) {
        QfFinancePlBudgetM QfFinancePlBudgetM2 = (QfFinancePlBudgetM)((Object)((QfFinancePlBudgetMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfFinancePlBudgetM2) {
            return false;
        }
        QfFinancePlBudgetM2.setStatus(QfFinancePlBudgetM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinancePlBudgetMDao)this.baseMapper).updateById((Object)QfFinancePlBudgetM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<HeaderNode> list, String mainId) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        QfFinancePlBudgetM mainInfo = (QfFinancePlBudgetM)((Object)((QfFinancePlBudgetMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)mainInfo), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        this.removeInfo(mainId);
        Map<String, List<QfFinancePlBudgetD>> historyMap = this.historyList(mainInfo);
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInternationalInfoManager.getSubjectCodeMap("PL");
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        HashSet noexitSubjectCodes = Sets.newHashSet();
        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        HashMap headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }
        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> subjectCodes = detailMap.get(1);
        HashMap subjectCodeMap = Maps.newHashMap();
        for (HeaderNode headerNode : subjectCodes) {
            subjectCodeMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        HashSet subjectCodeList = Sets.newHashSet();
        int maxColumn = detailMap.size();
        ArrayList detailList = Lists.newArrayList();
        JSONObject totalInfo = new JSONObject();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            String enterpriseCode = (String)headerMap.get(column);
            List<Object> historyDetailList = Lists.newArrayList();
            if (historyMap.containsKey(enterpriseCode)) {
                historyDetailList = historyMap.get(enterpriseCode);
            }
            for (HeaderNode node : nodes) {
                if (0 == node.getRow()) continue;
                String subjectCode = (String)subjectCodeMap.get(node.getRow());
                subjectCodeList.add(subjectCode);
                if (node.getColumn() > 1 && node.getColumn() < maxColumn - 3 && !StringUtils.isEmpty((Object)node.getHeaderName())) {
                    this.createDetail(mainId, mainInfo, subjectMap, enterpriseInfoMap, noexitSubjectCodes, subjectCodeMap, detailList, enterpriseCode, historyDetailList, node);
                    continue;
                }
                if (node.getColumn() < maxColumn - 3 || StringUtils.isEmpty((Object)node.getHeaderName())) continue;
                if (node.getColumn() == maxColumn - 1) {
                    totalInfo.put(subjectCode + ":budgetConsolidated", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() == maxColumn - 2) {
                    totalInfo.put(subjectCode + ":budgetPosting", (Object)node.getHeaderName());
                    continue;
                }
                if (node.getColumn() != maxColumn - 3) continue;
                totalInfo.put(subjectCode + ":budgetTotal", (Object)node.getHeaderName());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)noexitSubjectCodes)) {
            throw new BaseException(((Object)noexitSubjectCodes).toString() + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        List<QfFinancePlBudgetS> totalList = this.getQfFinancePlBudgetS(mainInfo, subjectMap, new ArrayList<String>(subjectCodeList), totalInfo);
        this.financePlBudgetSManager.saveBatch(totalList);
        try {
            this.partitionSave(detailList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u4f8b\u5982\u62a5\u8868\u6570\u636e\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
        this.executorService.execute(() -> {
            try {
                this.saveFinancialVo(mainInfo, detailList);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u8d22\u52a1\u5927\u5c4f\u62a5\u8868\u9884\u7b97\u6570\u636e\u751f\u6210\u5931\u8d25:{}", (Object)e.getMessage());
            }
        });
        return true;
    }

    private void partitionSave(List<QfFinancePlBudgetD> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)(detailList.size() / 10));
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.financePlBudgetDManager.saveOrUpdateBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }

    private void saveFinancialVo(QfFinancePlBudgetM mainInfo, List<QfFinancePlBudgetD> detailList) {
        ArrayList financialVoList = Lists.newArrayList();
        DataInfoVo dataInfoVo = new DataInfoVo();
        dataInfoVo.setYear(mainInfo.getFillYear());
        dataInfoVo.setMonth(mainInfo.getFillMonth());
        dataInfoVo.setQuarter(mainInfo.getFillQuarter());
        detailList.forEach(detail -> {
            FinancialVo financialVo = new FinancialVo();
            financialVo.setEnterpriseCode(detail.getEnterpriseCode());
            financialVo.setBudget(detail.getBudget());
            financialVo.setSubjectCode(detail.getSubjectCode());
            financialVoList.add(financialVo);
        });
        this.qfFinancialStatisticalManager.saveData(financialVoList, dataInfoVo, 2);
    }

    private List<QfFinancePlBudgetS> getQfFinancePlBudgetS(QfFinancePlBudgetM mainInfo, Map<String, QfSubjectInternationalInfo> subjectMap, List<String> subjectCodeList, JSONObject totalInfo) {
        ArrayList totalList = Lists.newArrayList();
        subjectCodeList.forEach(subjectCode -> {
            QfFinancePlBudgetS plS = new QfFinancePlBudgetS();
            plS.setMainId(mainInfo.getId());
            QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(subjectCode)));
            if (null == subjectInternationalInfo) {
                return;
            }
            plS.setSubjectNameEn(subjectInternationalInfo.getNameEn());
            plS.setSubjectUnit(subjectInternationalInfo.getUnit());
            plS.setSubjectName(subjectInternationalInfo.getName());
            if (totalInfo.containsKey((Object)(subjectCode + ":budgetConsolidated"))) {
                plS.setBudgetConsolidated(totalInfo.getBigDecimal(subjectCode + ":budgetConsolidated"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":budgetPosting"))) {
                plS.setBudgetPosting(totalInfo.getBigDecimal(subjectCode + ":budgetPosting"));
            }
            if (totalInfo.containsKey((Object)(subjectCode + ":budgetTotal"))) {
                plS.setBudgetTotal(totalInfo.getBigDecimal(subjectCode + ":budgetTotal"));
            }
            plS.setFillYear(mainInfo.getFillYear());
            plS.setFillMonth(mainInfo.getFillMonth());
            plS.setFillDate(mainInfo.getFillDate());
            plS.setFillQuarter(mainInfo.getFillQuarter());
            plS.setSubjectCode((String)subjectCode);
            totalList.add(plS);
        });
        return totalList;
    }

    private void createDetail(String mainId, QfFinancePlBudgetM mainInfo, Map<String, QfSubjectInternationalInfo> subjectMap, Map<String, QfEnterpriseInfo> enterpriseInfoMap, Set<String> noexitSubjectCodes, Map<Integer, String> subjectCodeMap, List<QfFinancePlBudgetD> detailList, String enterpriseCode, List<QfFinancePlBudgetD> historyDetailList, HeaderNode node) {
        QfFinancePlBudgetD financePlBudgetD = new QfFinancePlBudgetD();
        financePlBudgetD.setMainId(mainId);
        financePlBudgetD.setFillDate(mainInfo.getFillDate());
        financePlBudgetD.setEnterpriseCode(enterpriseCode);
        financePlBudgetD.setSubjectCode(subjectCodeMap.get(node.getRow()));
        if (!subjectMap.containsKey(financePlBudgetD.getSubjectCode())) {
            noexitSubjectCodes.add(financePlBudgetD.getSubjectCode());
        } else {
            QfSubjectInternationalInfo subjectInternationalInfo = subjectMap.get(financePlBudgetD.getSubjectCode());
            financePlBudgetD.setSubjectNameEn(subjectInternationalInfo.getNameEn());
            financePlBudgetD.setSubjectUnit(subjectInternationalInfo.getUnit());
            financePlBudgetD.setSubjectName(subjectInternationalInfo.getName());
            if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                financePlBudgetD.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
            }
            if (subjectInternationalInfo.getType().equals(SubjectTypeEnum.CBFY.getType())) {
                financePlBudgetD.setBudgetYtd(new BigDecimal(node.getHeaderName()).multiply(new BigDecimal(-1)));
            } else {
                financePlBudgetD.setBudgetYtd(new BigDecimal(node.getHeaderName()));
            }
        }
        Map<String, QfFinancePlBudgetD> historyDetailMap = historyDetailList.stream().collect(Collectors.toMap(item -> item.getSubjectCode(), item -> item));
        if (historyDetailMap.containsKey(financePlBudgetD.getSubjectCode())) {
            QfFinancePlBudgetD historyDetail = historyDetailMap.get(financePlBudgetD.getSubjectCode());
            financePlBudgetD.setBudget(financePlBudgetD.getBudgetYtd().subtract(historyDetail.getBudgetYtd()));
        } else {
            financePlBudgetD.setBudget(financePlBudgetD.getBudgetYtd());
        }
        if (enterpriseInfoMap.containsKey(financePlBudgetD.getEnterpriseCode())) {
            QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(financePlBudgetD.getEnterpriseCode());
            financePlBudgetD.setEnterpriseName(qfEnterpriseInfo.getName());
            financePlBudgetD.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
        }
        detailList.add(financePlBudgetD);
    }

    private void removeInfo(String mainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.financePlBudgetDManager.remove((Wrapper)queryWrapper);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_id_", (Object)mainId);
        this.financePlBudgetSManager.remove((Wrapper)query);
    }

    private Map<String, List<QfFinancePlBudgetD>> historyList(QfFinancePlBudgetM QfFinancePlBudgetM2) {
        List<QfFinancePlBudgetD> historyList = ((QfFinancePlBudgetMDao)this.baseMapper).historyList(QfFinancePlBudgetM2.getFillMonth() - 1, QfFinancePlBudgetM2.getFillYear());
        if (CollectionUtils.isEmpty(historyList)) {
            return Maps.newHashMap();
        }
        return historyList.stream().collect(Collectors.groupingBy(QfFinancePlBudgetD::getEnterpriseCode));
    }
}

