/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.PinyinUtil;
import com.artfess.cqlt.manager.BizOrgManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.PwdStrategyManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.PwdStrategy;
import com.artfess.uc.model.User;
import com.google.api.client.util.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class BizOrgManagerImpl
implements BizOrgManager {
    @Resource
    private OrgManager orgManager;
    @Resource
    private UserManager userManager;
    @Resource
    private OrgUserManager relateManager;
    @Resource
    private PwdStrategyManager pwdStrategyManager;
    @Resource
    private PasswordEncoder passwordEncoder;

    @Override
    @Transactional
    public Boolean sync() {
        WebClient webClient = WebClient.builder().baseUrl("http://222.177.27.177:8889").defaultHeader("User-Agent", new String[]{"Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko)"}).build();
        JSONArray obtainOrg = JSONArray.parseArray((String)((String)((WebClient.RequestBodySpec)webClient.post().uri("/getzzdw", new Object[0])).retrieve().bodyToMono(String.class).block()));
        JSONArray obtainDept = JSONArray.parseArray((String)((String)((WebClient.RequestBodySpec)webClient.post().uri("/getzzbm", new Object[0])).retrieve().bodyToMono(String.class).block()));
        JSONArray obtainUser = JSONArray.parseArray((String)((String)((WebClient.RequestBodySpec)webClient.post().uri("/getQFServlet", new Object[0])).retrieve().bodyToMono(String.class).block()));
        Assert.notNull((Object)obtainOrg, (String)"\u8bf7\u6c42\u7ec4\u7ec7\u6570\u636e\u5931\u8d25");
        Assert.notNull((Object)obtainDept, (String)"\u8bf7\u6c42\u90e8\u95e8\u6570\u636e\u5931\u8d25");
        Assert.notNull((Object)obtainUser, (String)"\u8bf7\u6c42\u7528\u6237\u6570\u636e\u5931\u8d25");
        List<Org> orgTree = this.buildOrgTree(obtainOrg, obtainDept, obtainUser);
        ArrayList relateList = Lists.newArrayList();
        List allRelate = this.relateManager.list();
        if (BeanUtils.isNotEmpty(orgTree)) {
            orgTree.forEach(obj -> {
                if (obj.getId() != null && obj.getId().length() < 19) {
                    obj.setId(null);
                }
            });
            this.orgManager.saveOrUpdateBatch(orgTree);
            orgTree.forEach(ot -> {
                this.orgManager.backFill(orgTree, ot.getPathName());
                if (BeanUtils.isNotEmpty((Object)ot.getUserList())) {
                    this.userManager.saveOrUpdateBatch((Collection)ot.getUserList());
                    ot.getUserList().forEach(ul -> {
                        OrgUser relate = new OrgUser();
                        relate.setOrgId(ot.getId());
                        relate.setUserId(ul.getId());
                        relate.setIsMaster(Integer.valueOf(0));
                        for (OrgUser ar : allRelate) {
                            if (!ar.getUserId().equals(ul.getId()) || !ar.getOrgId().equals(ot.getId())) continue;
                            return;
                        }
                        relateList.add(relate);
                    });
                }
            });
            this.orgManager.saveOrUpdateBatch(orgTree);
        }
        this.relateManager.saveBatch((Collection)relateList);
        return true;
    }

    private List<Org> buildOrgTree(JSONArray obtainOrgJson, JSONArray obtainDeptJson, JSONArray obtainUserJson) {
        List allOrg = this.orgManager.list();
        HashMap<String, Org> orgMap = new HashMap<String, Org>(100);
        JSONArray orgArray = this.convertObtainData(obtainOrgJson);
        block0: for (Object obj : orgArray) {
            JSONObject orgJson = (JSONObject)obj;
            Org org = new Org();
            org.setId(orgJson.getString("id"));
            org.setName(orgJson.getString("subcompanyname"));
            org.setParentId(orgJson.getString("supsubcomid"));
            org.setCode(PinyinUtil.getPinYinHeadChar((String)org.getName()));
            org.setOrgKind("OGN");
            if (BeanUtils.isNotEmpty(orgMap.get(orgJson.getString("supsubcomid")))) {
                org.setPath(((Org)orgMap.get(orgJson.getString("supsubcomid"))).getPath() + "." + orgJson.getString("id"));
            }
            org.setPathName("/" + orgJson.getString("subcompanyname"));
            for (Object o : allOrg) {
                if (!o.getName().equals(org.getName())) continue;
                orgMap.put(o.getId(), (Org)o);
                continue block0;
            }
            orgMap.put(org.getId(), org);
        }
        JSONArray deptArray = this.convertObtainData(obtainDeptJson);
        block2: for (Object deptObj : deptArray) {
            JSONObject deptJson = (JSONObject)deptObj;
            Org dept = new Org();
            dept.setId(deptJson.getString("bmid"));
            dept.setName(deptJson.getString("departmentname"));
            dept.setParentId(deptJson.getString("supdepid"));
            dept.setCode(PinyinUtil.getPinYinHeadChar((String)dept.getName()));
            dept.setOrgKind("DEPT");
            if (!BeanUtils.isNotEmpty(orgMap.get(deptJson.getString("subcompanyid")))) continue;
            dept.setPath(((Org)orgMap.get(deptJson.getString("subcompanyid"))).getPath() + "." + deptJson.getString("bmid"));
            dept.setPathName("/" + ((Org)orgMap.get(deptJson.getString("subcompanyid"))).getPathName().replaceFirst("[/]", "") + "/" + deptJson.getString("departmentname"));
            ((Org)orgMap.get(deptJson.getString("subcompanyid"))).getDeptList().add(dept);
            for (Org o : allOrg) {
                if (!o.getName().equals(dept.getName())) continue;
                orgMap.put(o.getId(), o);
                continue block2;
            }
            orgMap.put(dept.getId(), dept);
        }
        List<User> userList = this.buildUserList(obtainUserJson);
        ArrayList<Org> orgList = new ArrayList<Org>();
        for (Map.Entry entry : orgMap.entrySet()) {
            Org org = (Org)entry.getValue();
            userList.forEach(ul -> {
                if (ul.getGroupId().equals(entry.getKey())) {
                    org.getUserList().add(ul);
                }
            });
            if (!org.getParentId().equals("0")) continue;
            this.buildOrgTree(org, orgMap);
            orgList.add(org);
        }
        return orgList;
    }

    private List<User> buildUserList(JSONArray obtainUserJson) {
        ArrayList<User> userList = new ArrayList<User>();
        List allUser = this.userManager.list();
        PwdStrategy pwdStrategy = this.pwdStrategyManager.getDefault();
        JSONArray userArray = this.convertObtainData(obtainUserJson);
        for (Object obj : userArray) {
            JSONObject userJson = (JSONObject)obj;
            User user = new User();
            user.setFullname(userJson.getString("lastname"));
            user.setAccount(userJson.getString("loginid"));
            if (StringUtils.isEmpty((Object)user.getAccount())) {
                user.setAccount(PinyinUtil.getPinyin((String)user.getFullname().substring(0, 1)) + PinyinUtil.getPinYinHeadChar((String)user.getFullname().substring(1)));
            }
            if (user.getAccount().equals("admin") || user.getAccount().equals("cqlt")) continue;
            String defaultPswd = "123456";
            if (pwdStrategy != null) {
                defaultPswd = pwdStrategy.getInitPwd();
            }
            user.setPassword(this.passwordEncoder.encode((CharSequence)defaultPswd));
            user.setEmail(userJson.getString("accounttype"));
            user.setMobile(userJson.getString("mobile"));
            user.setPhoto(userJson.getString("photo"));
            user.setStatus(userJson.getInteger("status"));
            user.setFrom("restful");
            user.setGroupId(userJson.getString("departmentid"));
            for (User u : allUser) {
                if (!u.getAccount().equals(user.getAccount())) continue;
                user.setId(u.getId());
            }
            userList.add(user);
        }
        return userList;
    }

    private JSONArray convertObtainData(JSONArray obtainData) {
        JSONArray converted = new JSONArray();
        for (Object userStirng : obtainData) {
            JSONObject userJson = JSON.parseObject((String)String.valueOf(userStirng));
            converted.add((Object)userJson);
        }
        return converted;
    }

    private void buildOrgTree(Org org, Map<String, Org> orgMap) {
        for (Org dept : org.getSubOrgs()) {
            Org subOrg = orgMap.get(dept.getId());
            if (!BeanUtils.isNotEmpty((Object)subOrg) || subOrg == org) continue;
            subOrg.setParent(org);
            org.getSubOrgs().add(subOrg);
            this.buildOrgTree(subOrg, orgMap);
        }
    }
}

