import req from '@/request.js'
const portal = window.context.portal
export default {
	// 添加
	addData(data, cb) {
		req.post(portal + `/qf/finance/reportSummary/`, data).then(res => {
			cb(res.data)
		})
	},
	//修改
	editData(data, cb) {
	    req.put(portal + `/qf/finance/reportSummary/detail/batchUpdate`, data).then(res => {
	        cb(res.data)
	    })
	},
	//删除
	delDate(ids,cb){
		req.remove(portal+`/qf/finance/reportSummary/?ids=`+ids).then(res=>{
			cb(res.data)
		})
	},
	//查询
	pageQuery(data, cb) {
	  req.post(portal + `/qf/finance/reportSummary/query`, data).then(res => {
	    cb(res.data)
	  })
	},

	// id查询
	detailId(id, cb) {
	    req.get(portal + `/qf/finance/reportSummary/` + id).then(rep => {
	        cb(rep.data)
	    })
	},
	//修改状态
	editStatus(data, cb) {
	    req.put(portal + `/qf/finance/reportSummary/updateStatus`, data).then(res => {
	        cb(res.data)
	    })
	},
	//导入
	importExcel(data, cb) {
	    req.post(portal + `/qf/finance/reportSummary/importExcel`, data).then(res => {
	        cb(res.data)
	    })
	},
	//导出
	export(data, cb){
		req.post(portal + `/qf/finance/reportSummary/export`, data,'blob').then(res => {
		    cb(res.data)
		})
	},
	/*二级页面*/
	//批量添加
	saveData(data, cb) {
	    req.post(portal + `/qf/finance/reportSummary/detail/batchSave`, data).then(res => {
	        cb(res.data)
	    })
	},
	//表格查询
	detailQuery(data, cb) {
	  req.post(portal + `/qf/finance/reportSummary/detail/detailQuery`, data).then(res => {
	    cb(res.data)
	  })
	},
	//批量删除
	dleDetail(ids,cb){
		req.remove(portal+`/qf/finance/reportSummary/detail/?ids=`+ids).then(res=>{
			cb(res.data)
		})
	},
	
}
