import Vue from 'vue'
import Router from 'vue-router'
import store from '@/store'
import NotFound from '@/views/NotFound.vue'
import Login from '@/views/Login.vue'
import req from '@/request.js'
import uc from '@/api/uc.js'
import {
	Message
} from 'element-ui'
import {
	Loading
} from 'element-ui'
//路由
import mainRouter from '@/module_router.js'

import Layout from '@/components/layout/Layout.vue'
Vue.use(Router)

var router = new Router({
	mode: 'history',
	base: process.env.BASE_URL,
	routes: [{
			path: '/',
			redirect: {
				name: 'login'
			}
		},
		{
			path: '/login',
			name: 'login',
			component: Login,
			meta: {
				single: true,
				anonymous: true
			}
		},
		{
			path: '/resetPwdView',
			name: 'resetPwdView',
			props: true,
			component: () => import('@/views/ResetPwdView.vue'),
			meta: {
				single: true,
				anonymous: true
			}
		},
		{
			path: '*',
			component: NotFound,
			meta: {
				single: true
			}
		},
		/* 大屏看板 */
		//财务
		{
		    path: '/financialTheme',
		    name: 'financialTheme',
		    component: () => import('@/views/BigScrenn/financialTheme.vue')
		},
		/*集团*/
		{
		    path: '/group',
		    name: 'group',
		    component: () => import('@/views/BigScrenn/group.vue')
		},
		/*企业*/
		{
		    path: '/enterprise',
		    name: 'enterprise',
		    component: () => import('@/views/BigScrenn/enterprise.vue')
		},
		//一级下撰
		{
		    path: '/firstLevelPage',
		    name: 'firstLevelPage',
		    component: () => import('@/views/BigScrenn/components/firstLevelPage.vue')
		},
		//二级下撰
		{
		    path: '/secondLevelPage',
		    name: 'secondLevelPage',
		    component: () => import('@/views/BigScrenn/components/secondLevelPage.vue')
		},
		//三级下撰
		{
		    path: '/thirdLevelPage',
		    name: 'thirdLevelPage',
		    component: () => import('@/views/BigScrenn/components/thirdLevelPage.vue')
		},
		//四级下撰
		{
		    path: '/fourthLevelPage',
		    name: 'fourthLevelPage',
		    component: () => import('@/views/BigScrenn/components/fourthLevelPage.vue')
		},
		//数据分析
		{
		    path: '/moreDialog',
		    name: 'moreDialog',
		    component: () => import('@/views/BigScrenn/components/moreDialog.vue')
		},
		/*资金*/ 
		{
		    path: '/fundTheme',
		    name: 'fundTheme',
		    component: () => import('@/views/BigScrenn/fundTheme/index.vue')
		},
		//一级下撰
		{
		    path: '/fundFirstPage',
		    name: 'fundFirstPage',
		    component: () => import('@/views/BigScrenn/fundTheme/components/fundFirstPage.vue')
		},
		//二级下撰
		{
		    path: '/fundSecondPage',
		    name: 'fundSecondPage',
		    component: () => import('@/views/BigScrenn/fundTheme/components/fundSecondPage.vue')
		},
		//三级下撰
		{
		    path: '/fundThirdPage',
		    name: 'fundThirdPage',
		    component: () => import('@/views/BigScrenn/fundTheme/components/fundThirdPage.vue')
		},
		//四级下撰
		{
		    path: '/fundFourthPage',
		    name: 'fundFourthPage',
		    component: () => import('@/views/BigScrenn/fundTheme/components/fundFourthPage.vue')
		},
		//数据分析
		{
		    path: '/fundMoreDialog',
		    name: 'fundMoreDialog',
		    component: () => import('@/views/BigScrenn/fundTheme/components/fundMoreDialog.vue')
		},
		//周资金下撰
		{
		    path: '/weeklyfundSuPage',
		    name: 'weeklyfundSuPage',
		    component: () => import('@/views/BigScrenn/fundTheme/components/weeklyfundSuPage.vue')
		},
		/*运营*/
		{
		    path: '/operationTheme',
		    name: 'operationTheme',
		    component: () => import('@/views/BigScrenn/operationTheme/index.vue')
		},
		//下撰
		{
		    path: '/operationTheme/writeDownPage',
		    name: 'writeDownPage',
		    component: () => import('@/views/BigScrenn/operationTheme/components/writeDownPage.vue')
		},
		/*投资*/
		{
		    path: '/investmentTheme',
		    name: 'investmentTheme',
		    component: () => import('@/views/BigScrenn/investmentTheme/index.vue')
		},
		/*人资*/
		{
		    path: '/humanResourceTheme',
		    name: 'humanResourceTheme',
		    component: () => import('@/views/BigScrenn/humanResourceTheme/index.vue')
		},
		//下撰
		{
		    path: '/humanResourceTheme/writeDownPage',
		    name: 'writeDownPage',
		    component: () => import('@/views/BigScrenn/humanResourceTheme/components/writeDownPage.vue')
		},
		/*综合*/
		{
		    path: '/comprehensiveTheme',
		    name: 'comprehensiveTheme',
		    component: () => import('@/views/BigScrenn/comprehensiveTheme/index.vue')
		},
		{
			path: '/business',
			name: 'business',
			component: () => import('@/views/Business.vue')
		},
		{
			path: '/platLayout',
			name: 'platLayout',
			component: Layout,
			meta: {
				single: true,
				anonymous: true
			},
			children: [{
					path: 'PersonalInfo',
					name: 'PersonalInfoInner',
					props: true,
					component: () => import('@/views/PersonalInfo.vue'),
				},
				{
					path: 'resetPwdView',
					name: 'resetPwdViewInner',
					props: true,
					component: () => import('@/views/ResetPwdView.vue'),
				},
				...mainRouter
			]
		}
	]
})

const createRouter = () =>
	new Router({
		mode: 'history',
		routes: []
	})

//重写动态添加路由方法
router.$addRoutes = params => {
	const newRouter = createRouter()
	router.matcher = newRouter.matcher //重置路由规则
	router.addRoutes(params) // 添加路由
}

//动态新增二级路由
router.addList = (path, list) => {
	let isAddPath = false
	let isChildren = false

	return isChildren
}

let registerRouteFresh = true

const ssoRedirect = () => {
	if (window.ssoConfig.mode == 'cas') {
		let service = window.location.href
		localStorage.setItem('service', service)
		window.location.href = window.ssoConfig.url + '?service=' + service
	} else if (window.ssoConfig.mode == 'oauth') {
		if (!window.ssoConfig.clientId) {
			throw 'oauth模式下必须提供clientId'
		}
		const service = window.location.href
		localStorage.setItem('service', service)
		window.location.href =
			`${window.ssoConfig.url}?response_type=code&client_id=${window.ssoConfig.clientId}&redirect_uri=${service}`
	}
}

const handelShortUrl = (to, from, next) => {
	req
		.get(
			'${portal}/portal/shorturlManage/v1/getLongUrlByShortUrl?shortUrl=' +
			to.fullPath.substr(1),
			'',
			false
		)
		.then(resp => {
			if (resp && resp.data && resp.data.state) {
				store
					.dispatch(
						'login/validAndCompletedCurrent',
						resp.data.value.guestToken
					)
					.then(() => {
						next({
							path: resp.data.value.url
						})
					})
					.catch(() => {
						logoutAndCleanUp(to, from, next)
					})
			} else {
				next({
					path: '/messageFillPage/' + resp.data.message
				})
			}
		})
		.catch(() => {
			logoutAndCleanUp(to, from, next)
		})
}

const logoutAndCleanUp = (to, from, next) => {
	store.dispatch('login/logoutAndCleanUp').then(() => {
		if (window.ssoConfig.mode && window.ssoConfig.mode != 'jwt' && !ticket) {
			ssoRedirect()
		} else if (!window.ssoConfig.mode || window.ssoConfig.mode == 'jwt') {
			next({
				path: '/login',
				query: {
					redirect: to.fullPath
				}
			})
		} else {
			throw '登录失败'
		}
	})
}

// 移除url后面的指定参数
const removeUrlParams = param => {
	const query = window.location.search.substring(1)
	if (!query) {
		return
	}
	const vars = query.split('&')
	const newVars = []
	for (var i = 0; i < vars.length; i++) {
		var pair = vars[i].split('=')
		if (pair[0] != param) {
			newVars.push(vars[i])
		}
	}
	setTimeout(() => {
		const path = `${window.location.pathname}${newVars.length > 0 ? '?' : ''
            }${newVars.join('&')}`
		window.history.replaceState(null, null, path)
	}, 1000)
}
let loadingInstance
const tokenLogin = (userInfo, next) => {
	store.dispatch('login/loginByPrincipal', userInfo).then(loginStatus => {
		if (loginStatus && loginStatus == true) {
			store.dispatch('menu/actionFrontMenus').then(res => {
				next({
					path: `/frontPlat/${res[0].alias}`
					// path: `/newOpen/cockpit`
				})
				removeUrlParams('tokenKey')
				// loadingInstance.close()
			})
		}
	})
}
const accountLogin = (account, next) => {
	console.log(account);
	
	store.dispatch('login/loginByAccount', account).then(loginStatus => {
		console.log(loginStatus);
		if (loginStatus && loginStatus == true) {
			store.dispatch('menu/actionFrontMenus').then(res => {
				console.log(res)
				next({
					path: `/comprehensiveTheme`
					// path: `/business`
				})
				// removeUrlParams('tokenKey')
				// loadingInstance.close()
			})
		}
	})
}


router.beforeEach((to, from, next) => {
	// 用户中心登录到养护系统 携带tokenKey
	console.log(to.name == 'login'&& to.query.userName);
	if (to.name == 'login'&& to.query.userName ) { 
		// loadingInstance = Loading.service({ fullscreen: true ,background: 'rgba(0, 0, 0, 0.6)'});
		// let data = {
		//     key: to.query.tokenKey
		// }
		// let token = {
		//     token: ''
		// }
		let account = to.query.userName ///to.query.account
		// tokenLogin({
		//   account: "admin",
		//   password: "artfess"
		// }, next);
		// uc.accountLogin(account).then(res => {
		// 	if (res.loginStatus) {
				accountLogin(
					account,
					next
				)
		// 	} else {
		// 		Message.error(res.msg)
		// 	}
		// })
		// uc.authFormUserTokenKey(data).then(res => {
		//     // debugger;
		//     console.log(res)
		//     if (res.success) {
		//         token.token = res.data
		//         uc.authUserInfo(token).then(res => {
		//             console.log(res, 'resresresres')
		//             if (res.success) {
		//                 //同步后获取用户名密码登录
		//                 accountLogin(
		//                     {
		//                         account: 'admin',
		//                         password: 'artfess'
		//                     },
		//                     next
		//                 )
		//             } else {
		//                 Message.error(res.msg)
		//                 // loadingInstance.close()
		//             }
		//         })
		//     } else {
		//         Message.error(res.msg)
		//         // loadingInstance.close()
		//     }
		// })
	}

	store.dispatch('menu/getAllmenus', {}).then(menus => {
		//href菜单不进这段代码
		if (to.fullPath.indexOf('href') == -1) {
			let alias = to.fullPath.split('/')[1]
			for (let i = 0; i < menus.length; i++) {
				if (menus[i].alias === alias) {
					store.dispatch('menu/getCurrentMenu', {
						alias: menus[i].alias,
						name: menus[i].name
					})
					break
				}
			}
		}
	})
	if (to.fullPath.startsWith('/surl/')) {
		handelShortUrl(to, from, next)
		return
	}

	// 1.当前为单点登录模式，且要路由到login页面，则做单点登录重定向；
	if (
		to.name == 'login' &&
		window.ssoConfig.mode &&
		window.ssoConfig.mode != 'jwt'
	) {
		// 单点登录时如果已经携带了code或者ticket时，如果是/login路径需要跳转到默认页面（解决反复跳转的问题）
		if (
			(window.ssoConfig.mode == 'cas' || window.ssoConfig.mode == 'oauth') &&
			(to.query.code || to.query.ticket)
		) {
			window.location.href = window.location.href.replace('/login', '')
			return
		} else {
			ssoRedirect()
		}
	}

	if (from.name != 'defStart' || to.name != 'instStart') {
		sessionStorage.removeItem('formImportTempRefId')
		sessionStorage.removeItem('formImportTempJson')
	}

	if (
		sessionStorage.menu_alias &&
		to.fullPath &&
		to.fullPath.split('/')[1] == 'home'
	) {
		sessionStorage.menu_alias = ''
	}
	if (to.matched.some(record => !record.meta.anonymous)) {
		let ticket = to.query.token
		// 2.当前已经从单点页面重定向回来了，且在url地址中携带了ticket或code；
		if (window.ssoConfig.mode == 'cas') {
			ticket = to.query.ticket
		} else if (window.ssoConfig.mode == 'oauth') {
			ticket = to.query.code
		}
		store
			// 3.携带ticket做用户鉴权；
			.dispatch('login/validAndCompletedCurrent', ticket)
			.then(() => {
				store._vm.$root.$emit('login-completed')
				if (registerRouteFresh) {
					if (sessionStorage.menu_alias) {
						let path = '/' + sessionStorage.menu_alias
						let isChildren = router.addList(path, router.options.routes) //动态新增二级路由
						//当前点击菜单的路由别名不存在 router.js 里面
						// if (!isChildren) {
						//   let alias_new = {
						//     path: path,
						//     name: 'alias_new',
						//     component: resolve =>
						//       require(['@/views/menuContent.vue'], resolve),
						//     children: []
						//   }
						//   router.options.routes.push(alias_new)
						//   router.addList(path, router.options.routes) //动态新增二级路由
						// }
						router.replace({
							path: to.path,
							query: to.query
						})
					}
					registerRouteFresh = false
				}
				next()
				// url地址带token的方式认证成功后删除url中的token
				removeUrlParams('token')
			})
			.catch(() => {
				// 4.鉴权失败时根据当前模式重定向到对应页面。
				logoutAndCleanUp(to, from, next)
			})
	} else {
		next()
	}
})

export default router
