/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.operator.impl.db2;

import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.util.BeanUtils;
import com.artfess.table.colmap.DB2ColumnMap;
import com.artfess.table.model.Column;
import com.artfess.table.model.Table;
import com.artfess.table.model.impl.DefaultTable;
import com.artfess.table.operator.IViewOperator;
import com.artfess.table.operator.impl.BaseViewOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class DB2ViewOperator
extends BaseViewOperator
implements IViewOperator {
    private static final String SQL_GET_ALL_VIEW = "SELECT VIEWNAME FROM SYSCAT.VIEWS WHERE  VIEWSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) ";
    private final String SQL_GET_COLUMNS_BATCH = "SELECT TABNAME TAB_NAME, COLNAME COL_NAME, TYPENAME COL_TYPE, REMARKS COL_COMMENT, NULLS IS_NULLABLE, LENGTH LENGTH, SCALE SCALE, KEYSEQ  FROM  SYSCAT.COLUMNS WHERE  TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) ";
    private static final String SQL_GET_COLUMNS = "SELECT TABNAME TAB_NAME, COLNAME COL_NAME, TYPENAME COL_TYPE, REMARKS COL_COMMENT, NULLS IS_NULLABLE, LENGTH LENGTH, SCALE SCALE, KEYSEQ  FROM  SYSCAT.COLUMNS WHERE  TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABNAME) = UPPER('%s') ";
    RowMapper<Table> tableModelRowMapper = new RowMapper<Table>(){

        public Table mapRow(ResultSet rs, int row) throws SQLException {
            DefaultTable tableModel = new DefaultTable();
            String tabName = rs.getString("VIEWNAME");
            tableModel.setTableName(tabName);
            tableModel.setComment(tabName);
            return tableModel;
        }
    };

    @Override
    public void createOrRep(String viewName, String sql) throws Exception {
    }

    @Override
    public PageList<String> getViews(String viewName) throws Exception {
        return this.getViews(viewName, null);
    }

    @Override
    public PageList<String> getViews(String viewName, PageBean pageBean) throws Exception {
        String sql = SQL_GET_ALL_VIEW;
        if (StringUtils.isNotEmpty((String)viewName)) {
            sql = sql + " and UPPER(view_name) like '" + viewName.toUpperCase() + "%'";
        }
        RowMapper<String> rowMapper = new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("VIEWNAME");
            }
        };
        return super.getForList(sql, pageBean, rowMapper);
    }

    @Override
    public PageList<Table> getViewsByName(String viewName, PageBean pageBean) throws Exception {
        String sql = SQL_GET_ALL_VIEW;
        if (StringUtils.isNotEmpty((String)viewName)) {
            sql = sql + " AND UPPER(VIEWNAME) LIKE '%" + viewName.toUpperCase() + "%'";
        }
        PageList<Table> tableModels = this.getForList(sql, pageBean, this.tableModelRowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table model : tableModels.getRows()) {
            tableNames.add(model.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table model : tableModels.getRows()) {
                if (!model.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                model.setColumnList(entry.getValue());
            }
        }
        return tableModels;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        String sql = "SELECT TABNAME TAB_NAME, COLNAME COL_NAME, TYPENAME COL_TYPE, REMARKS COL_COMMENT, NULLS IS_NULLABLE, LENGTH LENGTH, SCALE SCALE, KEYSEQ  FROM  SYSCAT.COLUMNS WHERE  TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) ";
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = sql + " AND UPPER(TABNAME) IN (" + buf.toString().toUpperCase() + ") ";
        List columnModels = this.jdbcTemplate.query(sql, (RowMapper)new DB2ColumnMap());
        for (Column columnModel : columnModels) {
            String tableName = columnModel.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(columnModel);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(columnModel);
            map.put(tableName, cols);
        }
        return map;
    }

    @Override
    public String getType(String type) {
        String dbtype = type.toLowerCase();
        if (dbtype.endsWith("bigint") || dbtype.endsWith("decimal") || dbtype.endsWith("double") || dbtype.endsWith("integer") || dbtype.endsWith("real") || dbtype.endsWith("smallint")) {
            return "number";
        }
        if (dbtype.endsWith("blob") || dbtype.endsWith("clob") || dbtype.endsWith("dbclob") || dbtype.endsWith("graphic") || dbtype.endsWith("long vargraphic") || dbtype.endsWith("vargraphic") || dbtype.endsWith("xml")) {
            return "clob";
        }
        if (dbtype.endsWith("character") || dbtype.endsWith("long varchar") || dbtype.endsWith("varchar")) {
            return "varchar";
        }
        if (dbtype.endsWith("date") || dbtype.endsWith("time") || dbtype.endsWith("timestamp")) {
            return "date";
        }
        return "varchar";
    }

    @Override
    public Table getModelByViewName(String viewName) throws SQLException {
        String sql = SQL_GET_ALL_VIEW;
        sql = sql + " AND UPPER(VIEWNAME) = '" + viewName.toUpperCase() + "'";
        Table tableModel = null;
        List tableModels = this.jdbcTemplate.query(sql, this.tableModelRowMapper);
        if (BeanUtils.isEmpty((Object)tableModels)) {
            return null;
        }
        tableModel = (Table)tableModels.get(0);
        List<Column> columnList = this.getColumnsByTableName(viewName);
        tableModel.setColumnList(columnList);
        return tableModel;
    }

    private List<Column> getColumnsByTableName(String tableName) {
        String sql = String.format(SQL_GET_COLUMNS, tableName);
        List list = this.jdbcTemplate.query(sql, (RowMapper)new DB2ColumnMap());
        return list;
    }
}

