package com.artfess.file.config;

import com.artfess.file.util.MinioUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * Minio文件上传配置文件
 */
@Component
public class MinioSetting {

    @Value(value = "${minio.minio_url}")
    private String minioUrl;

    @Value(value = "${minio.minio_name}")
    private String minioName;

    @Value(value = "${minio.minio_pass}")
    private String minioPass;

    @Value(value = "${minio.bucketName}")
    private String bucketName;

    public String getMinioUrl() {
        return minioUrl;
    }

    public void setMinioUrl(String minioUrl) {
        this.minioUrl = minioUrl;
    }

    public String getMinioName() {
        return minioName;
    }

    public void setMinioName(String minioName) {
        this.minioName = minioName;
    }

    public String getMinioPass() {
        return minioPass;
    }

    public void setMinioPass(String minioPass) {
        this.minioPass = minioPass;
    }

    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Bean
    public void initMinio(){
//        if(!minioUrl.startsWith("http")){
//            minioUrl = "http://" + minioUrl;
//        }
        if(!minioUrl.endsWith("/")){
            minioUrl = minioUrl.concat("/");
        }
        MinioUtil.setMinioUrl(minioUrl);
        MinioUtil.setMinioName(minioName);
        MinioUtil.setMinioPass(minioPass);
        MinioUtil.setBucketName(bucketName);
    }

}
