package com.artfess.portal.model;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 首页栏目 Model对象
 *
 * @company 阿特菲斯信息技术有限公司
 * @author maoww
 * @email maoww@jee-soft.cn
 * @date 2018年6月7日
 */
@ApiModel(description="首页栏目 Model对象")
@TableName("portal_sys_news_column")
public class SysIndexNewsColumn extends BaseModel<SysIndexNewsColumn> {


    @ApiModelProperty(name="id", notes="主键")
    @TableId("ID_")
    protected String  id;

    @ApiModelProperty(name="name", notes="公告名称")
    @TableField("NAME_")
    protected String name;

    @ApiModelProperty(name="type", notes="类型 0:新闻公告 1:轮播图")
    @TableField("TYPE_")
    protected String type;

    @ApiModelProperty(name="portalNewsId", notes="公告Id")
    @TableField("PORTAL_NEWS_ID_")
    protected String portalNewsId;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPortalNewsId() {
        return portalNewsId;
    }

    public void setPortalNewsId(String portalNewsId) {
        this.portalNewsId = portalNewsId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
