package com.artfess.base.jackson;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * 处理long类型的值在前端显示的时候精度丢失的问题
 * @author co
 *
 */
public class LongToStringSerializer extends JsonSerializer<Long>{

	@Override
	public void serialize(Long value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
		if (value > 999999999999999L) {
			gen.writeString(value.toString());
		}else{
			gen.writeNumber(value);
		}
	}
}
