package com.artfess.application.model;

import java.io.Serializable;
import java.util.Map;

/**
 * app推送的消息内容
 * 
 * @author pangquan
 *
 */
public class AppPushContent implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 标题
	 */
	private String title;
	/**
	 * 内容
	 */
	private String content;

	private Map<String, Object> params;

	public AppPushContent() {
		super();
	}

	public AppPushContent(String title, String content, Map<String, Object> params) {
		super();
		this.title = title;
		this.content = content;
		this.params = params;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public Map<String, Object> getParams() {
		return params;
	}

	public void setParams(Map<String, Object> params) {
		this.params = params;
	}

}
