package com.artfess.rocketmq.producer;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class RocketMQProducer {

    @Autowired(required = false)
    private RocketMQTemplate rocketMQTemplate;

    /**
     * 发送RocketMQ消息
     *
     * @param topicName 主题
     * @param jsonMessage 消息
     */
    public void send(String topicName, String jsonMessage) {
        SendResult sendResult = rocketMQTemplate.syncSend(topicName, MessageBuilder.withPayload(jsonMessage).build());
        log.info("【sendMsg】sendResult={}", JSON.toJSONString(sendResult));
    }
}
