package com.artfess.report.bigScreen.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 可视化配置表
 *
 * @company 阿特菲斯
 * @author 向贞好
 * @since 2021-07-12
 */
@ApiModel(value="BladeVisualConfig对象", description="可视化配置表")
public class BladeVisualConfig extends BaseModel<BladeVisualConfig> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "可视化表主键")
    @TableField("visual_id")
    private String visualId;

    @ApiModelProperty(value = "配置json")
    @TableField("detail")
    private String detail;

    @ApiModelProperty(value = "组件json")
    @TableField("component")
    private String component;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getVisualId() {
        return visualId;
    }

    public void setVisualId(String visualId) {
        this.visualId = visualId;
    }
    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }
    public String getComponent() {
        return component;
    }

    public void setComponent(String component) {
        this.component = component;
    }



    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BladeVisualConfig{" +
            "id=" + id +
            ", visualId=" + visualId +
            ", detail=" + detail +
            ", component=" + component +

        "}";
    }
}
