package com.artfess.uc.manager.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.manager.HolidayTimeManager;
import com.artfess.uc.manager.ShiftRuleManager;
import com.artfess.uc.model.HolidayTime;
import com.artfess.uc.model.ShiftRule;
import org.springframework.stereotype.Service;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.dao.HolidayDao;
import com.artfess.uc.model.Holiday;
import com.artfess.uc.manager.HolidayManager;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 
 * <pre> 
 * 描述：法定节假日 处理实现类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-08-03 15:50:17
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("holidayManager")
public class HolidayManagerImpl extends BaseManagerImpl<HolidayDao, Holiday> implements HolidayManager{

    @Resource
    HolidayTimeManager holidayTimeManager;
    @Resource
    ShiftRuleManager shiftRuleManager;

    @Override
    public Holiday get(Serializable id){
        Holiday holiday = super.get(id);
        List<HolidayTime> time = holidayTimeManager.getByHolidayId(id);
        holiday.setTime(time);
        return holiday;
    }
    
    

    @Override
	public Holiday getById(Serializable id) {
    	Holiday holiday = super.getById(id);
        List<HolidayTime> time = holidayTimeManager.getByHolidayId(id);
        holiday.setTime(time);
        return holiday;
	}



	@Override
    @Transactional
    public void create(Holiday holiday){
        String id = UniqueIdUtil.getSuid();
        holiday.setId(id);
        holiday.getTime().forEach(item -> {
            item.setHolidayId(id);
            holidayTimeManager.create(item);
        });
        super.create(holiday);
    }

    @Override
    @Transactional
    public void update(Holiday holiday){
        List<HolidayTime> times = holidayTimeManager.getByHolidayId(holiday.getId());
        Map<String,HolidayTime> existTimes = times.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        for (HolidayTime time: holiday.getTime()){
            if (!existTimes.containsKey(time.getId())){
                time.setHolidayId(holiday.getId());
                holidayTimeManager.create(time);
            }else{
                holidayTimeManager.update(time);
                existTimes.remove(time.getId());
            }
        }
        existTimes.forEach((key,value) -> {
            holidayTimeManager.remove(key);
        });
        super.update(holiday);
    }

    @Override
    public String removeWithCheck(String... ids) {
        List<String> failRemoveIds = new ArrayList<>();
        for (String id: ids){
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq("holiday_id_",id);
            List<ShiftRule> rules = shiftRuleManager.list(queryWrapper);
            if (BeanUtils.isNotEmpty(rules)){
                failRemoveIds.add("["+id+"]");
            }else{
                remove(id);
            }
        }
        return String.join("、",failRemoveIds);
    }
}
