package com.artfess.sysConfig.persistence.dao;


import com.artfess.sysConfig.persistence.model.SysDictionary;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 系统字典
 */
public interface SysDictionaryDao extends BaseMapper<SysDictionary> {

    /**
    * @Description: 批量修改字典状态
    * @Param: ids
    * @Param: status
    * @Return: void
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    void updateDictionariesStatus(@Param("ids") List<String> ids, @Param("status") Integer status);

    /**
    * @Description: 移动字典
    * @Param: idsList
    * @Param: treeId
    * @Return: void
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    void moveDictionaries(@Param("ids") List<String> idsList, @Param("treeId")String treeId);

    /**
    * @Description: 根据字典值的id级联查询下级字典
    * @Param: detailId  
    * @Return: java.util.List<com.artfess.portal.model.SysDictionary>
    * @Author: ZQF 
    * @Date: 2021/3/17 
    */
    List<SysDictionary> queryLowerDictionary(@Param("detailId") String detailId);

    /**
    * @Description: 通过字典code获取字典数据
    * @Param: code
    * @Param: key
    * @Param: companyId
    * @Return: java.lang.String
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    String queryDictTextByKey(@Param("code") String code, @Param("key") String key, @Param("tenantId") String tenantId);

}
