package com.artfess.portal.controller;

import com.alibaba.fastjson.JSONArray;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.AreaLevelEnum;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.sysConfig.persistence.manager.SysAreasManager;
import com.artfess.sysConfig.persistence.model.SysAreas;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;

/**
 * @Program: edp
 * @Date: 2021/3/5
 * @Author: ZQF
 * @Description: 系统行政区划
 */
@RestController
@RequestMapping("/sys/sysAreas/v1")
@Api(tags = "行政区划")
@ApiGroup(group = {ApiGroupConsts.GROUP_SYSTEM})
public class SysAreasController extends BaseController<SysAreasManager, SysAreas> {

    @Resource
    SysAreasManager sysAreasManager;

    @PostMapping("slicedQuerySysAreas")
    @ApiOperation(value = "行政区划分页查询", httpMethod = "POST", notes = "行政区划分页查询")
    public PageList<SysAreas> slicedQueryActuator(@ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<SysAreas> queryFilter) throws Exception {
        return sysAreasManager.query(queryFilter);
    }

    @RequestMapping(value = "querySysAreas", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "不分页查询行政区划", httpMethod = "POST", notes = "不分页查询行政区划")
    public List<SysAreas> queryActuator(@ApiParam(name = "sysAreas", value = "通用查询对象") @RequestBody SysAreas sysAreas) throws Exception {
        return sysAreasManager.queryAreasEntity(sysAreas);
    }

    @RequestMapping(value = "saveSysAreas", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存行政区划信息", httpMethod = "POST", notes = "保存行政区划信息")
    public CommonResult<String> saveSysAreas(@ApiParam(name = "sysAreas", value = "行政区划对象") @RequestBody SysAreas sysAreas) throws Exception {
        String msg = sysAreasManager.saveSysAreas(sysAreas);
        return new CommonResult<>(true, msg);
    }

    @RequestMapping(value = "updateSequence", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改排序号", httpMethod = "POST", notes = "批量修改排序号")
    public CommonResult<String> updateSequence(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        sysAreasManager.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }

    @RequestMapping(value = "deleteBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量删除", httpMethod = "POST", notes = "批量删除")
    public CommonResult<String> deleteBatch(@ApiParam(name = "ids", value = "Id集合，以,隔开") @RequestParam String ids) throws Exception {
        sysAreasManager.deleteBatch(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "townTree", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取乡镇下拉树", httpMethod = "POST", notes = "获取乡镇下拉树")
    public CommonResult<String> townTree(@ApiParam(name = "sysAreas", value = "通用查询对象") @RequestBody SysAreas sysAreas) throws Exception {
        sysAreas.setLevels(AreaLevelEnum.townLevels());
        List<SysAreas> array = this.baseService.tree(sysAreas);
        return CommonResult.success(array, "");
    }

}
