/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.portal.model.SysIndexColumn;
import com.artfess.portal.model.SysIndexLayoutManage;
import com.artfess.portal.persistence.manager.SysIndexColumnManager;
import com.artfess.portal.persistence.manager.SysIndexLayoutManageManager;
import com.artfess.portal.persistence.manager.SysIndexLayoutManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IOrgService;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/sysIndexLayoutManage/sysIndexLayoutManage/v1"})
@Api(tags={"\u95e8\u6237\u5e03\u5c40\u7ba1\u7406"})
@ApiGroup(group={"group_system"})
public class SysIndexLayoutManageController
extends BaseController<SysIndexLayoutManageManager, SysIndexLayoutManage> {
    @Resource
    private SysIndexLayoutManageManager sysIndexLayoutManageService;
    @Resource
    private SysIndexLayoutManager sysIndexLayoutService;
    @Resource
    private SysIndexColumnManager sysIndexColumnService;
    @Resource
    private IOrgService sysOrgService;
    @Resource
    IUserService ius;
    @Value(value="${system.saas.enable:false}")
    Boolean saasEnable;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u5e03\u5c40\u7ba1\u7406\u5206\u9875\u5217\u8868", httpMethod="POST", notes="\u53d6\u5f97\u5e03\u5c40\u7ba1\u7406\u5206\u9875\u5217\u8868")
    public PageList<SysIndexLayoutManage> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexLayoutManage> queryFilter) throws Exception {
        if (BeanUtils.isNotEmpty((Object)ContextUtil.getCurrentUser()) && ContextUtil.getCurrentUser().isAdmin()) {
            List list = queryFilter.getQuerys();
            for (QueryField queryField : list) {
                if (!"orgId".equals(queryField.getProperty())) continue;
                queryField.setGroup("orgAuthId");
                queryField.setRelation(FieldRelation.OR);
            }
            queryFilter.addFilter("ID", (Object)"1", QueryOP.EQUAL, FieldRelation.OR, "orgAuthId");
        }
        queryFilter.addFilter("IS_DEF", (Object)0, QueryOP.EQUAL, FieldRelation.AND);
        return this.sysIndexLayoutManageService.query(queryFilter);
    }

    @RequestMapping(value={"getSysDefaultLayout"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u9ed8\u8ba4\u7684\u5e03\u5c40", httpMethod="POST", notes="\u83b7\u53d6\u7cfb\u7edf\u9ed8\u8ba4\u7684\u5e03\u5c40")
    public PageList<SysIndexLayoutManage> getSysDefaultLayout(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexLayoutManage> queryFilter) throws Exception {
        queryFilter.addFilter("IS_DEF", (Object)1, QueryOP.EQUAL);
        return this.sysIndexLayoutManageService.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7id\u53d6\u5f97\u5e03\u5c40\u7ba1\u7406\u5206\u9875\u5217\u8868", httpMethod="GET", notes="\u901a\u8fc7id\u53d6\u5f97\u5e03\u5c40\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SysIndexLayoutManage getJson(@ApiParam(name="id", value="\u4e3b\u952eid") @RequestParam String id) throws Exception {
        return (SysIndexLayoutManage)this.sysIndexLayoutManageService.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u5e03\u5c40\u7ba1\u7406", httpMethod="DELETE", notes="\u5220\u9664\u5e03\u5c40\u7ba1\u7406")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.sysIndexLayoutManageService.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u5e03\u5c40\u7ba1\u7406\u6210\u529f!", null);
        }
        catch (Exception ex) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25" + ex.getMessage(), null);
        }
    }

    @RequestMapping(value={"design"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u8ba1\u9996\u9875\u5e03\u5c40", httpMethod="GET", notes="\u8bbe\u8ba1\u9996\u9875\u5e03\u5c40")
    public Map<String, Object> design(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id, @ApiParam(name="layoutType", value="\u90e8\u95e8id", required=false) @RequestParam short layoutType) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IUser user = ContextUtil.getCurrentUser();
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("IS_PUBLIC", (Object)layoutType, QueryOP.EQUAL);
        if (this.saasEnable.booleanValue()) {
            queryFilter.addFilter("tenant_id_", (Object)user.getTenantId(), QueryOP.EQUAL, FieldRelation.OR, "tenantId");
            queryFilter.addFilter("tenant_id_", (Object)"-1", QueryOP.EQUAL, FieldRelation.OR, "tenantId");
        }
        List<SysIndexColumn> columnList = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            columnList = this.sysIndexColumnService.getAllByLayoutType(queryFilter);
        }
        Map<String, List<Map<String, Object>>> columnMap = this.sysIndexColumnService.getColumnMap2(columnList);
        SysIndexLayoutManage sysIndexLayoutManage = (SysIndexLayoutManage)this.sysIndexLayoutManageService.get((Serializable)((Object)id));
        map.put("columnMap", columnMap);
        map.put("sysIndexLayout", (Object)sysIndexLayoutManage);
        return map;
    }

    @RequestMapping(value={"saveLayout"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u9996\u9875\u5e03\u5c40", httpMethod="POST", notes="\u4fdd\u5b58\u9996\u9875\u5e03\u5c40")
    public CommonResult<String> saveLayout(@ApiParam(name="indexLayout", value="\u6570\u636e\u6e90\u5bf9\u8c61", required=true) @RequestBody SysIndexLayoutManage indexLayout) throws Exception {
        try {
            if (BeanUtils.isEmpty((Object)indexLayout.getId())) {
                indexLayout.setId(UniqueIdUtil.getSuid());
                this.sysIndexLayoutManageService.create((Model)indexLayout);
            } else {
                this.sysIndexLayoutManageService.update((Model)indexLayout);
            }
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"setShareToSub"}, method={RequestMethod.GET})
    @ApiOperation(value="\u8bbe\u7f6e\u662f\u5426\u5171\u4eab\u7ed9\u5b50\u90e8\u95e8", httpMethod="GET", notes="\u8bbe\u7f6e\u662f\u5426\u5171\u4eab\u7ed9\u5b50\u90e8\u95e8")
    public CommonResult<String> setShareToSub(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="shareToSub", required=true) @RequestParam Short shareToSub) throws Exception {
        try {
            SysIndexLayoutManage layout = (SysIndexLayoutManage)this.sysIndexLayoutManageService.get((Serializable)((Object)id));
            layout.setShareToSub(shareToSub);
            this.sysIndexLayoutManageService.update((Model)layout);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", null);
        }
        catch (Exception ex) {
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25" + ex.getMessage(), null);
        }
    }

    @RequestMapping(value={"enable"}, method={RequestMethod.GET})
    @ApiOperation(value="\u8bbe\u7f6e\u542f\u7528/\u505c\u7528", httpMethod="GET", notes="\u8bbe\u7f6e\u542f\u7528/\u505c\u7528")
    public CommonResult<String> enable(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="enable", required=true) @RequestParam Short enable) throws Exception {
        this.sysIndexLayoutManageService.setEnable(id, enable);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", null);
    }

    @PostMapping(value={"exportDefaultLayout"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u5e03\u5c40", httpMethod="POST", notes="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u5e03\u5c40")
    public void exportDefaultLayout(@ApiParam(name="ids", value="id\u96c6\u5408") @RequestBody List<String> ids, HttpServletRequest request, HttpServletResponse response, @RequestParam boolean isDefault) throws Exception {
        String filePrefix = isDefault ? "defaultLayout" : "orgLayout";
        String fileName = filePrefix + "_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MM_dd_HHmm");
        String json = ((SysIndexLayoutManageManager)this.baseService).exportDefaultLayout(ids, isDefault);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)(filePrefix + ".json"), (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"importDefaultLayout"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5e03\u5c40", httpMethod="POST", notes="\u5bfc\u5165\u5e03\u5c40")
    public CommonResult importDefaultLayout(MultipartHttpServletRequest request, @RequestParam String orgId, @RequestParam boolean isDefault) throws Exception {
        MultipartFile file = request.getFile("file");
        String uzPath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            ((SysIndexLayoutManageManager)this.baseService).importFile(uzPath, orgId, isDefault);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
    }
}

