package com.artfess.base.util;

import java.util.Map;

/**
 * 清空系统的线程变量
 * @author jason
 * @date 2020-11-24
 *
 */
public class ThreadLocalCleanUtil {
	/**
	 * 清理线程变量  
	 * 1. ContextThread 实现类的线程变量清空
	 * 2. FormContextThread 线程变量
	 * 3. 消息的线程变量
	 */
	public static void cleanAll(){
		AuthenticationUtil.removeAll();
		Map<String, ContextThread> contextThreadMap = AppUtil.getBeansOfType(ContextThread.class);
		if(BeanUtils.isNotEmpty(contextThreadMap)) {
			contextThreadMap.forEach((key,contextThread)->{					
				contextThread.cleanAll();
			});
		}
		FormContextThread formContextThread = AppUtil.getBean(FormContextThread.class);
		if(BeanUtils.isNotEmpty(formContextThread)) {
			formContextThread.cleanAll();
		}
		
		ThreadMsgUtil.clean();
		ThreadMsgUtil.cleanMapMsg();
	}
}
