package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 设备状态
 */
@Getter
public enum DeviceStatusEnum {
    /**
     * -1：报废，1：正常、2：故障、3：报警、9：其他
     */

    BF("-1", "报废"),

    ZC("1", "正常"),

    GZ("2", "故障"),

    BJ("3", "报警"),

    OTHER("9", "其他"),

    ;

    DeviceStatusEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        DeviceStatusEnum[] values = values();
        for (DeviceStatusEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }


    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        DeviceStatusEnum[] values = values();
        for (DeviceStatusEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
