package com.artfess.device.monitor.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 实时监控-路障设备状态信息（DEVICE_DATA_BARRICADE_STATUS）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2022-09-13
 */
@Data
@TableName("device_data_barricade_status")
@ApiModel(value="DeviceDataBarricadeStatus对象", description="实时监控-路障设备状态信息（DEVICE_DATA_BARRICADE_STATUS）")
public class DeviceDataBarricadeStatus extends BaseModel<DeviceDataBarricadeStatus> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采集时间")
    @TableField("COLL_TIME_")
    private LocalDateTime collTime;

    @ApiModelProperty(value = "设备唯一标识")
    @TableField("DEVICE_CODE_")
    private String deviceCode;

    @ApiModelProperty(value = "升降柱最近的一次动作【字典】（01-上升，10-下降）")
    @TableField("LAST_ACTION_")
    private String lastAction;

    @ApiModelProperty(value = "升降柱位置状态【字典】（00-底部，FF-顶部，55-中间）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "报警状态【字典】(0001-上限位报警，0002-下限位报警，0003-补压报警，空字符串-没有报警)")
    @TableField("ALERT_")
    private String alert;

    @ApiModelProperty(value = "报警ID")
    @TableField("WARN_ID_")
    private String warnId;

    @ApiModelProperty(value = "入库时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;

}
