package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * 设备扩展信息配置
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@FieldRepeat(fields = {"code","name"},message = "参数名称或代码不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="DeviceParamsConf对象", description="设备扩展信息配置")
public class DeviceParamsConf extends BaseModel<DeviceParamsConf> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "产品扩展信息配置ID")
    @TableField("product_conf_id_")
    private String productConfId;

    @NotBlank(message = "请选择设备",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备ID")
    @TableField("device_id_")
    private String deviceId;

    @NotBlank(message = "请输入参数名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备参数名称")
    @TableField("name_")
    private String name;

    @NotBlank(message = "请输入参数代码",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备参数代码")
    @TableField("code_")
    private String code;

    @NotBlank(message = "请选择设备控件类型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "设备控件类型【字典】（input：手动输入，number：数字框，select：下拉框，date：日期框，checkbox：复选框，radio：单选框）")
    @TableField("ctl_type_")
    private String ctlType;

    @NotNull(message = "请填写布局方式",groups = {AddGroup.class,UpdateGroup.class})
    @Min(value = 1, message = "最小值为1")
    @Max(value = 24, message = "最大值为24")
    @ApiModelProperty(value = "布局")
    @TableField("layout_")
    private Integer layout;

    @ApiModelProperty(value = "是否必填（0：否，1：是）,默认不必填")
    @TableField("is_required_")
    private String isRequired;

    @ApiModelProperty(value = "JSON值")
    @TableField("json_")
    private String json;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;


    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

}
