package com.artfess.form.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

/**
 * form_import_check_jar
 * <pre>
 * 描述：form_import_check_jar 实体对象
 * 构建组：x7
 * 作者:heyf
 * 邮箱:heyf@jee-soft.cn
 * 日期:2020-07-13 15:35:03
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@TableName("form_import_check_jar")
@ApiModel(value = "FormImportCheckJar", description = "form_import_check_jar")
public class FormImportCheckJar extends BaseModel<FormImportCheckJar> {

    private static final long serialVersionUID = 1L;
    @XmlTransient
    @TableId("ID_")
    @ApiModelProperty(value = "ID_")
    protected String id;

    @XmlAttribute(name = "classPath")
    @TableField("CLASS_PATH_")
    @ApiModelProperty(value = "校验类路径")
    protected String classPath;

    @XmlAttribute(name = "desc")
    @TableField("DESC_")
    @ApiModelProperty(value = "描述")
    protected String desc;

    @XmlAttribute(name = "filePath")
    @TableField("FILE_PATH_")
    @ApiModelProperty(value = "校验jar包位置")
    protected String filePath;

    public void setId(String id) {
        this.id = id;
    }

    /**
     * 返回 ID_
     *
     * @return
     */
    public String getId() {
        return this.id;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    /**
     * 返回 校验类路径
     *
     * @return
     */
    public String getClassPath() {
        return this.classPath;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 返回 描述
     *
     * @return
     */
    public String getDesc() {
        return this.desc;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    /**
     * 返回 校验jar包位置
     *
     * @return
     */
    public String getFilePath() {
        return this.filePath;
    }

    /**
     * @see Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this)
                .append("id", this.id)
                .append("classPath", this.classPath)
                .append("desc", this.desc)
                .append("filePath", this.filePath)
                .toString();
    }
}