/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.safty.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.manage.safty.dao.CmgtSaftyTargetDao;
import com.artfess.manage.safty.manager.CmgtSaftyTargetCheckManager;
import com.artfess.manage.safty.manager.CmgtSaftyTargetManager;
import com.artfess.manage.safty.model.CmgtSaftyTarget;
import com.artfess.manage.safty.model.CmgtSaftyTargetCheck;
import com.artfess.uc.dao.UserDao;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CmgtSaftyTargetManagerImpl
extends BaseManagerImpl<CmgtSaftyTargetDao, CmgtSaftyTarget>
implements CmgtSaftyTargetManager {
    @Resource
    private UserDao userDao;
    @Resource
    private CmgtSaftyTargetCheckManager checkManager;

    public PageList<CmgtSaftyTarget> query(QueryFilter<CmgtSaftyTarget> queryFilter) {
        List details = this.checkManager.list();
        PageList result = super.query(queryFilter);
        result.getRows().forEach(r -> r.getDetail().addAll(details.stream().filter(d -> r.getId().equals(d.getTargetId())).collect(Collectors.toList())));
        return result;
    }

    public CmgtSaftyTarget getById(Serializable id) {
        CmgtSaftyTarget result = (CmgtSaftyTarget)((Object)super.getById(id));
        List detils = this.checkManager.list((Wrapper)new QueryWrapper().eq((Object)"target_year_", (Object)id));
        result.setDetail(detils);
        return result;
    }

    public void removeByIds(String ... ids) {
        List detailIds = this.checkManager.list((Wrapper)new QueryWrapper().in((Object)"target_year_", (Object[])ids)).stream().map(CmgtSaftyTargetCheck::getId).collect(Collectors.toList());
        this.checkManager.removeByIds(detailIds);
        super.removeByIds(ids);
    }

    public boolean save(CmgtSaftyTarget entity) {
        if (entity.getSn() == null) {
            entity.setSn(this.count() + 1);
        }
        boolean result = super.save((Object)entity);
        if (BeanUtils.isNotEmpty(entity.getDetail())) {
            entity.getDetail().forEach(d -> d.setTargetId(entity.getId()));
            this.checkManager.saveBatch(entity.getDetail());
        }
        return result;
    }

    public boolean updateById(CmgtSaftyTarget entity) {
        return super.updateById((Object)entity);
    }
}

