/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.CodePrefix;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialSignWarehouseDao;
import com.artfess.manage.material.manager.CmgtMaterialFlowLogManager;
import com.artfess.manage.material.manager.CmgtMaterialOrderManager;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.manager.CmgtMaterialSignWarehouseDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialSignWarehouseManager;
import com.artfess.manage.material.manager.CmgtMaterialUsedDetailManager;
import com.artfess.manage.material.model.CmgtMaterialFlowLog;
import com.artfess.manage.material.model.CmgtMaterialOrder;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.artfess.manage.material.model.CmgtMaterialSignWarehouse;
import com.artfess.manage.material.model.CmgtMaterialSignWarehouseDetail;
import com.artfess.manage.material.model.CmgtMaterialUsedDetail;
import com.artfess.redis.util.CodeCreatorUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.google.api.client.util.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CmgtMaterialSignWarehouseManagerImpl
extends BaseManagerImpl<CmgtMaterialSignWarehouseDao, CmgtMaterialSignWarehouse>
implements CmgtMaterialSignWarehouseManager {
    @Resource
    private BaseContext baseContext;
    @Autowired
    private CmgtMaterialSignWarehouseDetailManager signWarehouseDetailManager;
    @Resource
    private CmgtMaterialUsedDetailManager usedDetailManager;
    @Resource
    private CmgtMaterialFlowLogManager flowLogManager;
    @Autowired
    private CmgtMaterialQuantityManage quantityManage;
    @Autowired
    private CmgtMaterialOrderManager orderManager;
    @Resource
    private CodeCreatorUtil codeCreatorUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(CmgtMaterialSignWarehouse t) {
        String code = this.codeCreatorUtil.createCodeYYYYMMDD(CodePrefix.SIGN_WAREHOUSE, 12);
        t.setCode(code);
        int insert = ((CmgtMaterialSignWarehouseDao)this.baseMapper).insert((Object)t);
        if (insert > 0) {
            this.processDetailList(t);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(CmgtMaterialSignWarehouse t) {
        CmgtMaterialSignWarehouse warehouse = (CmgtMaterialSignWarehouse)((Object)((CmgtMaterialSignWarehouseDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == warehouse) {
            throw new BaseException("\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
        }
        t.setCode(warehouse.getCode());
        t.setStatus(warehouse.getStatus());
        int insert = ((CmgtMaterialSignWarehouseDao)this.baseMapper).updateById((Object)t);
        if (insert > 0) {
            this.processDetailList(t);
            return true;
        }
        return false;
    }

    @Override
    public CmgtMaterialSignWarehouse findById(String id) {
        CmgtMaterialSignWarehouse cmgtMaterialSignWarehouse = (CmgtMaterialSignWarehouse)((Object)((CmgtMaterialSignWarehouseDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null == cmgtMaterialSignWarehouse) {
            return new CmgtMaterialSignWarehouse();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sign_warehouse_id_", (Object)id);
        List cmgtMaterialSignWarehouseDetails = this.signWarehouseDetailManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        cmgtMaterialSignWarehouse.setDetailList(cmgtMaterialSignWarehouseDetails);
        return cmgtMaterialSignWarehouse;
    }

    private void processDetailList(CmgtMaterialSignWarehouse t) {
        CmgtMaterialOrder cmgtMaterialOrder;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sign_warehouse_id_", (Object)t.getId());
        this.signWarehouseDetailManager.remove((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(t.getDetailList())) {
            return;
        }
        QueryWrapper usedQuery = new QueryWrapper();
        usedQuery.eq((Object)"create_org_id_", (Object)this.baseContext.getCurrentOrgId());
        this.usedDetailManager.remove((Wrapper)usedQuery);
        ArrayList usedDetails = Lists.newArrayList();
        ArrayList logList = Lists.newArrayList();
        ArrayList quantityList = Lists.newArrayList();
        t.getDetailList().forEach(detail -> {
            detail.setSignWarehouseId(t.getId());
            this.createLogs(t, logList, quantityList, (CmgtMaterialSignWarehouseDetail)((Object)detail));
            this.createUsedMaterial(usedDetails, (CmgtMaterialSignWarehouseDetail)((Object)detail));
        });
        this.signWarehouseDetailManager.saveOrUpdateBatch(t.getDetailList());
        this.usedDetailManager.saveBatch(usedDetails);
        this.flowLogManager.saveBatch(logList);
        this.quantityManage.saveOrUpdateBatch(quantityList);
        if ("2".equals(t.getStatus()) && null != (cmgtMaterialOrder = (CmgtMaterialOrder)this.orderManager.get((Serializable)((Object)t.getOrderId())))) {
            cmgtMaterialOrder.setStatus("2");
            cmgtMaterialOrder.setCompleteDate(LocalDateTime.now());
            this.orderManager.update((Model)cmgtMaterialOrder);
        }
    }

    private void createLogs(CmgtMaterialSignWarehouse t, List<CmgtMaterialFlowLog> logList, List<CmgtMaterialQuantity> quantityList, CmgtMaterialSignWarehouseDetail detail) {
        if ("2".equals(t.getStatus())) {
            CmgtMaterialFlowLog log = new CmgtMaterialFlowLog();
            log.setInoutType("1");
            log.setInoutId(t.getId());
            log.setMaterialId(detail.getMaterialId());
            log.setMaterialName(detail.getName());
            log.setModel(detail.getModel());
            log.setUnit(detail.getUnit());
            log.setWarehouse(t.getWarehouse());
            log.setQuantity(detail.getQuantity());
            log.setForTheDate(LocalDateTime.now());
            log.setFortheOrg(this.baseContext.getCurrentOrgName());
            log.setFortheUser(this.baseContext.getCurrentUserName());
            logList.add(log);
            QueryWrapper quantityQueryWrapper = new QueryWrapper();
            quantityQueryWrapper.eq((Object)"WAREHOUSE_", (Object)t.getWarehouse());
            quantityQueryWrapper.eq((Object)"material_id_", (Object)detail.getMaterialId());
            CmgtMaterialQuantity cmgtMaterialQuantity = (CmgtMaterialQuantity)((Object)this.quantityManage.getBaseMapper().selectOne((Wrapper)quantityQueryWrapper));
            if (null == cmgtMaterialQuantity) {
                cmgtMaterialQuantity = new CmgtMaterialQuantity();
                cmgtMaterialQuantity.setWarehouse(t.getWarehouse());
                cmgtMaterialQuantity.setMid(detail.getMaterialId());
                cmgtMaterialQuantity.setModel(detail.getModel());
                cmgtMaterialQuantity.setUnit(detail.getUnit());
                cmgtMaterialQuantity.setQuantity(detail.getQuantity());
                cmgtMaterialQuantity.setAmount(detail.getAmount());
            } else {
                cmgtMaterialQuantity.setQuantity(cmgtMaterialQuantity.getQuantity().add(detail.getQuantity()));
                cmgtMaterialQuantity.setAmount(cmgtMaterialQuantity.getAmount().add(detail.getAmount()));
            }
            quantityList.add(cmgtMaterialQuantity);
        }
    }

    private void createUsedMaterial(List<CmgtMaterialUsedDetail> usedDetails, CmgtMaterialSignWarehouseDetail detail) {
        CmgtMaterialUsedDetail cmgtMaterialUsedDetail = new CmgtMaterialUsedDetail();
        cmgtMaterialUsedDetail.setMaterialId(detail.getMaterialId());
        cmgtMaterialUsedDetail.setModel(detail.getModel());
        cmgtMaterialUsedDetail.setUnit(detail.getUnit());
        cmgtMaterialUsedDetail.setSn(detail.getSn());
        usedDetails.add(cmgtMaterialUsedDetail);
    }
}

