package com.artfess.manage.safty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * cmgt_safty_danger_checkrecord
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-01
 */
@Data
@ApiModel(value="CmgtSaftyDangerCheckrecord对象", description="安全隐患排查记录")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtSaftyDangerCheckrecord extends AutoFillModel<CmgtSaftyDangerCheckrecord> {

    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 排查计划ID */
    @ApiModelProperty(value = "排查计划ID")
    @TableField("checkplan_id_")
    private String checkplanId;

    /** 隐患类型 */
    @ApiModelProperty(value = "隐患类型")
    @TableField("danger_type_")
//    @NotBlank(message = "隐患类型",groups = {AddGroup.class,UpdateGroup.class})
    private String dangerType;

    /** 是否重大隐患 */
    @ApiModelProperty(value = "是否重大隐患")
    @TableField("imark_")
    private String imark;

    /** 排查时间 */
    @ApiModelProperty(value = "排查时间")
    @TableField("check_date_")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    private LocalDate checkDate;

    /** 检查人 */
    @ApiModelProperty(value = "检查人")
    @TableField("check_user_")
    private String checkUser;

    /** 检查内容 */
    @ApiModelProperty(value = "检查内容")
    @TableField("content_")
    private String content;

    /** 检查对象 */
    @ApiModelProperty(value = "检查对象")
    @TableField("recipient_")
    private String recipient;

    /** 检查地点 */
    @ApiModelProperty(value = "检查地点")
    @TableField("location_")
    private String location;

    /** 检查结果 */
    @ApiModelProperty(value = "检查结果")
    @TableField("result_")
    private String result;

    /** 隐患内容 */
    @ApiModelProperty(value = "隐患内容")
    @TableField("danger_")
    private String danger;

    /** 隐患排查方案 */
    @ApiModelProperty(value = "隐患排查方案")
    @TableField("pcfa_")
    private String pcfa;

    /** 隐患复查人 */
    @ApiModelProperty(value = "隐患复查人")
    @TableField("reviewer_")
    private String reviewer;

    /** 复查时间 */
    @ApiModelProperty(value = "复查时间")
    @TableField("review_date_")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    private LocalDate reviewDate;

    /** 复查结果 */
    @ApiModelProperty(value = "复查结果")
    @TableField("review_result_")
    private String reviewResult;

    /** 遗留问题 */
    @ApiModelProperty(value = "遗留问题")
    @TableField("remaining_problem_")
    private String remainingProblem;

    /** 整改期限 */
    @ApiModelProperty(value = "整改期限")
    @TableField("time_limit_")
    private String timeLimit;

    /** 隐患处理负责人 */
    @ApiModelProperty(value = "隐患处理负责人")
    @TableField("resolver_")
    private String resolver;

    /** 负责机构 */
    @ApiModelProperty(value = "负责机构")
    @TableField("resolving_org__")
    private String resolvingOrg;

    /** 隐患处理措施 */
    @ApiModelProperty(value = "隐患处理措施")
    @TableField("resolving_measure__")
    private String resolvingMeasure;

    /** 隐患处理情况 */
    @ApiModelProperty(value = "隐患处理情况")
    @TableField("resolving_remark_")
    private String resolvingRemark;

    /** 隐患处理时间 */
    @ApiModelProperty(value = "隐患处理时间")
    @TableField("resolving_date_")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone="GMT+8")
    private LocalDate resolvingDate;


    /** 排查时附件 */
    @TableField("base_info_files_")
    @ApiModelProperty(value = "排查时附件列表")
    private String baseInfoFiles;

    /** 复查时附件 */
    @TableField("fc_files_")
    @ApiModelProperty(value = "复查时附件列表")
    private String fcFiles;

    /** 状态 */
    @ApiModelProperty(value = "状态")
    @TableField("status_")
    private String status;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    /** 删除标识，1已删除，0未删除 */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;


    /** 版本号 */
    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    /** 数据时间戳 */
    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;


}
