package com.artfess.manage.material.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 常用物资-明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Data
@ApiModel(value="CmgtMaterialUsedDetail对象", description="常用物资-明细表")
public class CmgtMaterialUsedDetail extends AutoFillModel<CmgtMaterialUsedDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择要添加的物资",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "物资id")
    @TableField("material_id_")
    private String materialId;

    @NotBlank(message = "请选择要添加的物资",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "品名")
    @TableField("name_")
    private String name;

    @NotBlank(message = "请提交物资型号",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "型号")
    @TableField("model_")
    private String model;

    @NotBlank(message = "请提交物资计量单位",groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "计量单位")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "描述")
    @TableField("description_")
    private String description;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
