package com.artfess.manage.material.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * cmgt_material_custom
 *
 * @company 阿特菲斯信息技术有限公司
 * @author fanxm
 * @since 2022-08-24
 */
@Data
@ApiModel(value="CmgtMaterialCustom对象", description="物资供应商信息")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtMaterialCustom extends AutoFillModel<CmgtMaterialCustom> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 供应商名称 */
    @ApiModelProperty(value = "供应商名称")
    @TableField("name_")
    private String name;

    /** 联系人 */
    @ApiModelProperty(value = "联系人")
    @TableField("link_man_")
    private String linkMan;

    /** 联系电话 */
    @ApiModelProperty(value = "联系电话")
    @TableField("phone_")
    private String phone;

    /** 地址 */
    @ApiModelProperty(value = "地址")
    @TableField("addr_")
    private String addr;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

}
